/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.management.ManagementPermission;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.api.RegistryService;
import org.wso2.carbon.registry.app.RemoteRegistryService;
import org.wso2.carbon.registry.app.Utils;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.caching.CachingHandler;
import org.wso2.carbon.registry.core.config.Mount;
import org.wso2.carbon.registry.core.config.RegistryConfiguration;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.dao.LogsDAO;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.EmbeddedRegistryService;
import org.wso2.carbon.registry.core.jdbc.handlers.HandlerLifecycleManager;
import org.wso2.carbon.registry.core.jdbc.handlers.HandlerManager;
import org.wso2.carbon.registry.core.jdbc.handlers.builtin.CommentCollectionURLHandler;
import org.wso2.carbon.registry.core.jdbc.handlers.builtin.CommentURLHandler;
import org.wso2.carbon.registry.core.jdbc.handlers.builtin.OperationStatisticsHandler;
import org.wso2.carbon.registry.core.jdbc.handlers.builtin.RatingCollectionURLHandler;
import org.wso2.carbon.registry.core.jdbc.handlers.builtin.RatingURLHandler;
import org.wso2.carbon.registry.core.jdbc.handlers.builtin.RegexBaseRestrictionHandler;
import org.wso2.carbon.registry.core.jdbc.handlers.builtin.SQLQueryHandler;
import org.wso2.carbon.registry.core.jdbc.handlers.builtin.SimulationHandler;
import org.wso2.carbon.registry.core.jdbc.handlers.builtin.TagURLHandler;
import org.wso2.carbon.registry.core.jdbc.handlers.filters.MediaTypeMatcher;
import org.wso2.carbon.registry.core.jdbc.handlers.filters.SimulationFilter;
import org.wso2.carbon.registry.core.jdbc.handlers.filters.URLMatcher;
import org.wso2.carbon.registry.core.secure.AuthorizeRoleListener;
import org.wso2.carbon.registry.core.service.SimulationService;
import org.wso2.carbon.registry.core.service.TenantRegistryLoader;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.statistics.StatisticsCollector;
import org.wso2.carbon.registry.core.utils.LogQueue;
import org.wso2.carbon.registry.core.utils.LogRecord;
import org.wso2.carbon.registry.core.utils.LogWriter;
import org.wso2.carbon.registry.core.utils.MediaTypesUtils;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.user.core.listener.AuthorizationManagerListener;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.AbstractAxis2ConfigurationContextObserver;
import org.wso2.carbon.utils.AuthenticationObserver;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.WaitBeforeShutdownObserver;

public class RegistryCoreServiceComponent {
    private static RegistryConfiguration registryConfig;
    private static RealmService realmService;
    private static final Log log;
    private static BundleContext bundleContext;
    private static Stack<ServiceRegistration> registrations;
    private static org.wso2.carbon.registry.core.service.RegistryService registryService;

    protected void activate(ComponentContext context) {
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        carbonContext.setTenantDomain("carbon.super");
        carbonContext.setTenantId(-1234);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
        try {
            bundleContext = context.getBundleContext();
            registryService = this.buildRegistryService();
            log.debug((Object)"Completed initializing the Registry Kernel");
            registrations.push(bundleContext.registerService(new String[]{org.wso2.carbon.registry.core.service.RegistryService.class.getName(), RegistryService.class.getName()}, (Object)registryService, null));
            registrations.push(bundleContext.registerService(SimulationService.class.getName(), (Object)new DefaultSimulationService(), null));
            TenantDeploymentListenerImpl listener = new TenantDeploymentListenerImpl(registryService);
            registrations.push(bundleContext.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)listener, null));
            registrations.push(bundleContext.registerService(AuthenticationObserver.class.getName(), (Object)listener, null));
            registrations.push(bundleContext.registerService(TenantRegistryLoader.class.getName(), (Object)listener, null));
            log.debug((Object)"Registry Core bundle is activated ");
        }
        catch (Throwable e) {
            log.error((Object)"Failed to activate Registry Core bundle ", e);
        }
    }

    private void startLogWriter(org.wso2.carbon.registry.core.service.RegistryService registryService) throws RegistryException {
        UserRegistry registry = registryService.getRegistry("wso2.system.user");
        final RegistryContext registryContext = registry.getRegistryContext();
        if (bundleContext != null) {
            bundleContext.registerService(LogQueue.class.getName(), (Object)registryContext.getLogWriter().getLogQueue(), null);
            bundleContext.registerService(WaitBeforeShutdownObserver.class.getName(), (Object)new WaitBeforeShutdownObserver(){

                public void startingShutdown() {
                    LogWriter logWriter = registryContext.getLogWriter();
                    LogQueue logQueue = logWriter.getLogQueue();
                    logWriter.setCanWriteLogs(false);
                    if (logQueue.size() > 0) {
                        log.info((Object)"Writing logs ");
                        int queueLength = logQueue.size();
                        LogRecord[] logRecords = new LogRecord[queueLength];
                        for (int a = 0; a < queueLength; ++a) {
                            LogRecord logRecord;
                            logRecords[a] = logRecord = (LogRecord)logQueue.poll();
                        }
                        LogsDAO logsDAO = registryContext.getDataAccessManager().getDAOManager().getLogsDAO();
                        try {
                            logsDAO.saveLogBatch(logRecords);
                        }
                        catch (RegistryException e) {
                            log.error((Object)"Unable to save log records", (Throwable)((Object)e));
                        }
                    }
                }

                public boolean isTaskComplete() {
                    LogWriter logWriter = registryContext.getLogWriter();
                    LogQueue logQueue = logWriter.getLogQueue();
                    if (logQueue.size() > 0) {
                        logWriter.interrupt();
                        return false;
                    }
                    return true;
                }
            }, null);
        }
    }

    protected void deactivate(ComponentContext context) {
        while (!registrations.empty()) {
            registrations.pop().unregister();
        }
        registryService = null;
        bundleContext = null;
        log.debug((Object)"Registry Core bundle is deactivated ");
    }

    private void defineFixedMount(Registry registry, String path, boolean isSuperTenant) throws RegistryException {
        Resource r;
        RegistryContext registryContext = registry.getRegistryContext();
        String relativePath = RegistryUtils.getRelativePath(registryContext, path);
        String lookupPath = RegistryUtils.getAbsolutePath(registryContext, "/_system/local/repository/components/org.wso2.carbon.registry/mount") + "/" + relativePath.replace("/", "-");
        if (isSuperTenant) {
            if (!registry.resourceExists(lookupPath)) {
                return;
            }
            r = registry.get(lookupPath);
        } else {
            r = registry.newResource();
            r.setContent("application/vnd.wso2.mount");
        }
        r.addProperty("registry.fixedmount", Boolean.toString(true));
        registry.put(lookupPath, r);
    }

    private boolean isFixedMount(Registry registry, String path, String targetPath, boolean isSuperTenant) throws RegistryException {
        RegistryContext registryContext = registry.getRegistryContext();
        String relativePath = RegistryUtils.getRelativePath(registryContext, path);
        String lookupPath = RegistryUtils.getAbsolutePath(registryContext, "/_system/local/repository/components/org.wso2.carbon.registry/mount") + "/" + relativePath.replace("/", "-");
        if (!registry.resourceExists(lookupPath)) {
            return false;
        }
        Resource r = registry.get(lookupPath);
        return (!isSuperTenant || targetPath.equals(r.getProperty("subPath"))) && Boolean.toString(true).equals(r.getProperty("registry.fixedmount"));
    }

    private static void setupMediaTypes(org.wso2.carbon.registry.core.service.RegistryService registryService, int tenantId) {
        try {
            UserRegistry registry = registryService.getConfigSystemRegistry(tenantId);
            MediaTypesUtils.getResourceMediaTypeMappings(registry);
            MediaTypesUtils.getCustomUIMediaTypeMappings(registry);
            MediaTypesUtils.getCollectionMediaTypeMappings(registry);
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to create fixed remote mounts.", (Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeTenant(org.wso2.carbon.registry.core.service.RegistryService registryService, int tenantId) {
        try {
            HandlerManager handlerManager;
            UserRegistry systemRegistry = registryService.getConfigSystemRegistry();
            if (systemRegistry.getRegistryContext() != null && (handlerManager = systemRegistry.getRegistryContext().getHandlerManager()) instanceof HandlerLifecycleManager) {
                ((HandlerLifecycleManager)handlerManager).init(tenantId);
            }
            systemRegistry = registryService.getRegistry("wso2.system.user", tenantId);
            RegistryUtils.addMountCollection(systemRegistry);
            RegistryUtils.registerMountPoints(systemRegistry, tenantId);
            new RegistryCoreServiceComponent().setupMounts(registryService, tenantId);
            RegistryCoreServiceComponent.setupMediaTypes(registryService, tenantId);
            try {
                CurrentSession.setTenantId(tenantId);
                RegistryContext registryContext = systemRegistry.getRegistryContext();
                RegistryUtils.addUserProfileCollection(systemRegistry, RegistryUtils.getAbsolutePath(registryContext, registryContext.getProfilesPath()));
                RegistryUtils.addServiceStoreCollection(systemRegistry, RegistryUtils.getAbsolutePath(registryContext, registryContext.getServicePath()));
                RegistryUtils.addServiceConfigResources(systemRegistry);
            }
            finally {
                CurrentSession.removeTenantId();
            }
        }
        catch (RegistryException e) {
            log.error((Object)("Unable to initialize registry for tenant " + tenantId + "."), (Throwable)((Object)e));
        }
    }

    private void createPseudoLink(Registry registry, String path, String target, String targetSubPath) throws RegistryException {
        Resource resource;
        if (registry.resourceExists(path)) {
            resource = registry.get(path);
            resource.addProperty("registry.existingresource", "true");
        } else {
            resource = new CollectionImpl();
        }
        resource.addProperty("registry.nonrecursive", "true");
        resource.addProperty("registry.linkrestoration", path + ";" + target + ";" + targetSubPath + ";" + CurrentSession.getUser());
        resource.setMediaType("application/vnd.wso2-link");
        registry.put(path, resource);
        resource.discard();
    }

    private void setupMounts(org.wso2.carbon.registry.core.service.RegistryService registryService, int tenantId) {
        try {
            boolean isSuperTenant = tenantId == -1234;
            UserRegistry superTenantRegistry = registryService.getRegistry("wso2.system.user");
            UserRegistry registry = registryService.getRegistry("wso2.system.user", tenantId);
            RegistryContext registryContext = superTenantRegistry.getRegistryContext();
            for (Mount mount : registryContext.getMounts()) {
                if (this.isFixedMount(registry, mount.getPath(), mount.getTargetPath(), isSuperTenant)) {
                    this.addFixedMount(tenantId, superTenantRegistry, mount.getPath());
                    continue;
                }
                if (!registry.resourceExists(mount.getPath())) {
                    if (isSuperTenant) {
                        superTenantRegistry.createLink(mount.getPath(), mount.getInstanceId(), mount.getTargetPath());
                    } else {
                        this.createPseudoLink(registry, mount.getPath(), mount.getInstanceId(), mount.getTargetPath());
                        this.addFixedMount(tenantId, superTenantRegistry, mount.getPath());
                    }
                    this.defineFixedMount(registry, mount.getPath(), isSuperTenant);
                } else if (mount.isOverwrite()) {
                    registry.delete(mount.getPath());
                    if (isSuperTenant) {
                        superTenantRegistry.createLink(mount.getPath(), mount.getInstanceId(), mount.getTargetPath());
                    } else {
                        this.createPseudoLink(registry, mount.getPath(), mount.getInstanceId(), mount.getTargetPath());
                        this.addFixedMount(tenantId, superTenantRegistry, mount.getPath());
                    }
                    this.defineFixedMount(registry, mount.getPath(), isSuperTenant);
                } else if (mount.isVirtual()) {
                    Resource r = registry.get(mount.getPath());
                    if (Boolean.toString(true).equals(r.getProperty("registry.link"))) {
                        log.error((Object)("Unable to create virtual remote mount at location: " + mount.getPath() + ". Virtual remote mounts can only be created " + "for physical resources."));
                        continue;
                    }
                    if (isSuperTenant) {
                        superTenantRegistry.createLink(mount.getPath(), mount.getInstanceId(), mount.getTargetPath());
                    } else {
                        this.createPseudoLink(registry, mount.getPath(), mount.getInstanceId(), mount.getTargetPath());
                        this.addFixedMount(tenantId, superTenantRegistry, mount.getPath());
                    }
                    this.defineFixedMount(registry, mount.getPath(), isSuperTenant);
                } else {
                    log.error((Object)("Unable to create remote mount. A resource already exists at the given location: " + mount.getPath()));
                    continue;
                }
                try {
                    if (registry.resourceExists(mount.getPath())) continue;
                    log.debug((Object)("Target path does not exist for the given mount: " + mount.getPath()));
                }
                catch (Exception e) {
                    log.warn((Object)("Target path does not exist for the given mount: " + mount.getPath()), (Throwable)e);
                }
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to create fixed remote mounts.", (Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFixedMount(int tenantId, Registry registry, String path) throws RegistryException {
        CurrentSession.setCallerTenantId(tenantId);
        try {
            RegistryContext registryContext = registry.getRegistryContext();
            String relativePath = RegistryUtils.getRelativePath(registryContext, path);
            String lookupPath = RegistryUtils.getAbsolutePath(registryContext, "/_system/local/repository/components/org.wso2.carbon.registry/mount") + "/" + relativePath.replace("/", "-");
            if (!registry.resourceExists(lookupPath)) {
                return;
            }
            Resource r = registry.get(lookupPath);
            String mountPath = r.getProperty("path");
            String target = r.getProperty("target");
            String targetSubPath = r.getProperty("subPath");
            String author = r.getProperty("author");
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Creating the mount point. path: " + path + ", " + "target: " + target + ", " + "target sub path " + targetSubPath + "."));
                }
                RegistryUtils.registerHandlerForRemoteLinks(registry.getRegistryContext(), mountPath, target, targetSubPath, author);
            }
            catch (RegistryException e) {
                log.error((Object)("Couldn't mount " + target + "."), (Throwable)((Object)e));
            }
        }
        finally {
            CurrentSession.removeCallerTenantId();
        }
    }

    public void registerBuiltInHandlers(org.wso2.carbon.registry.core.service.RegistryService registryService) throws RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Registering the built-in handlers.");
        }
        UserRegistry registry = registryService.getRegistry("wso2.system.user");
        RegistryContext registryContext = registry.getRegistryContext();
        HandlerManager handlerManager = registryContext.getHandlerManager();
        if (log.isTraceEnabled()) {
            log.trace((Object)"Engaging the Operation Statistics Handler.");
        }
        OperationStatisticsHandler systemStatisticsHandler = new OperationStatisticsHandler();
        URLMatcher systemStatisticsURLMatcher = new URLMatcher();
        systemStatisticsURLMatcher.setPattern(".*");
        handlerManager.addHandler(null, systemStatisticsURLMatcher, systemStatisticsHandler);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Engaging the Comment URL Handler.");
        }
        CommentURLHandler commentURLHandler = new CommentURLHandler();
        URLMatcher commentURLMatcher = new URLMatcher();
        commentURLMatcher.setGetPattern(".+;comments:[0-9]+");
        commentURLMatcher.setDeletePattern(".+;comments:[0-9]+");
        handlerManager.addHandler(new String[]{"GET", "DELETE"}, commentURLMatcher, commentURLHandler);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Engaging the Comment Collection URL Handler.");
        }
        CommentCollectionURLHandler commentCollectionURLHandler = new CommentCollectionURLHandler();
        URLMatcher commentCollectionURLMatcher = new URLMatcher();
        commentCollectionURLMatcher.setGetPattern(".+;comments");
        handlerManager.addHandler(new String[]{"GET"}, commentCollectionURLMatcher, commentCollectionURLHandler);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Engaging the Rating URL Handler.");
        }
        RatingURLHandler ratingURLHandler = new RatingURLHandler();
        URLMatcher ratingURLMatcher = new URLMatcher();
        ratingURLMatcher.setGetPattern(".+;ratings:.+");
        handlerManager.addHandler(new String[]{"GET"}, ratingURLMatcher, ratingURLHandler);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Engaging the Rating Collection URL Handler.");
        }
        RatingCollectionURLHandler ratingCollectionURLHandler = new RatingCollectionURLHandler();
        URLMatcher ratingCollectionURLMatcher = new URLMatcher();
        ratingCollectionURLMatcher.setGetPattern(".+;ratings");
        handlerManager.addHandler(new String[]{"GET"}, ratingCollectionURLMatcher, ratingCollectionURLHandler);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Engaging the Tag URL Handler.");
        }
        TagURLHandler tagURLHandler = new TagURLHandler();
        URLMatcher tagURLMatcher = new URLMatcher();
        tagURLMatcher.setGetPattern(".+;.+:.+:.+");
        handlerManager.addHandler(new String[]{"GET"}, tagURLMatcher, tagURLHandler);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Engaging the SQL Query Handler.");
        }
        SQLQueryHandler sqlQueryHandler = new SQLQueryHandler();
        MediaTypeMatcher sqlMediaTypeMatcher = new MediaTypeMatcher("application/vnd.sql.query");
        handlerManager.addHandler(new String[]{"GET", "PUT"}, sqlMediaTypeMatcher, sqlQueryHandler);
        handlerManager.addHandler(null, new SimulationFilter(), new SimulationHandler(), "reporting");
        if (log.isTraceEnabled()) {
            log.trace((Object)"Engaging the Cashing Registry Handler.");
        }
        CachingHandler cachingHandler = new CachingHandler();
        URLMatcher cachingURLMatcher = new URLMatcher();
        cachingURLMatcher.setPattern(".*");
        handlerManager.addHandler(null, cachingURLMatcher, cachingHandler);
        handlerManager.addHandler(null, cachingURLMatcher, cachingHandler, "reporting");
        if (log.isTraceEnabled()) {
            log.trace((Object)"Engaging the RegexBase Restriction Handler.");
        }
        RegexBaseRestrictionHandler regexBaseRestrictionHandler = new RegexBaseRestrictionHandler();
        URLMatcher logUrlMatcher = new URLMatcher();
        logUrlMatcher.setPattern(".*");
        handlerManager.addHandler(new String[]{"RENAME", "MOVE"}, logUrlMatcher, regexBaseRestrictionHandler, "default");
    }

    public org.wso2.carbon.registry.core.service.RegistryService buildRegistryService() throws Exception {
        String registryRoot;
        org.wso2.carbon.registry.core.service.RegistryService registryService;
        RegistryCoreServiceComponent.updateRegistryConfiguration(this.getRegistryConfiguration());
        ServerConfiguration serverConfig = this.getServerConfiguration();
        this.setSystemTrustStore(serverConfig);
        if ("remote".equals(registryConfig.getRegistryType())) {
            registryService = this.getRemoteRegistryService(registryConfig);
            registryRoot = registryConfig.getValue("registryRoot");
        } else {
            registryService = this.getEmbeddedRegistryService();
            Utils.setEmbeddedRegistry((EmbeddedRegistryService)registryService);
            registryRoot = RegistryContext.getBaseInstance().getRegistryRoot();
        }
        UserRegistry systemRegistry = registryService.getRegistry("wso2.system.user");
        RegistryContext registryContext = systemRegistry.getRegistryContext();
        this.startLogWriter(registryService);
        this.setupMounts(registryService, -1234);
        this.registerBuiltInHandlers(registryService);
        RegistryCoreServiceComponent.setupMediaTypes(registryService, -1234);
        RegistryUtils.addUserProfileCollection(systemRegistry, registryContext.getProfilesPath());
        RegistryUtils.addServiceStoreCollection(systemRegistry, registryContext.getServicePath());
        RegistryUtils.addServiceConfigResources(systemRegistry);
        if (log.isInfoEnabled()) {
            String registryMode = "READ-WRITE";
            if (RegistryUtils.isRegistryReadOnly(RegistryContext.getBaseInstance())) {
                registryMode = "READ-ONLY";
            }
            if (registryRoot != null) {
                log.info((Object)("Registry Root    : " + registryRoot));
            }
            log.info((Object)("Registry Mode    : " + registryMode));
            if (!"embedded".equals(registryConfig.getRegistryType())) {
                log.info((Object)("Registry Type    : " + registryConfig.getRegistryType()));
            }
        }
        return registryService;
    }

    private File getConfigFile() throws RegistryException {
        String configPath = CarbonUtils.getRegistryXMLPath();
        if (configPath != null) {
            File registryXML = new File(configPath);
            if (!registryXML.exists()) {
                String msg = "Registry configuration file (registry.xml) file does not exist in the path " + configPath;
                log.error((Object)msg);
                throw new RegistryException(msg);
            }
            return registryXML;
        }
        String msg = "Cannot find registry.xml";
        log.error((Object)msg);
        throw new RegistryException(msg);
    }

    private org.wso2.carbon.registry.core.service.RegistryService getEmbeddedRegistryService() throws Exception {
        FileInputStream configInputStream = new FileInputStream(this.getConfigFile());
        RegistryContext registryContext = RegistryContext.getBaseInstance((InputStream)configInputStream, realmService);
        registryContext.setSetup(System.getProperty("setup") != null);
        return new EmbeddedRegistryService(registryContext);
    }

    private org.wso2.carbon.registry.core.service.RegistryService getRemoteRegistryService(RegistryConfiguration regConfig) throws Exception {
        String url = regConfig.getValue("Url");
        String username = regConfig.getValue("Username");
        String password = regConfig.getValue("Password");
        String chroot = regConfig.getValue("registryRoot");
        return new RemoteRegistryService(url, username, password, realmService, chroot);
    }

    private RegistryConfiguration getRegistryConfiguration() throws RegistryException {
        String path = CarbonUtils.getServerXml();
        return new RegistryConfiguration(path);
    }

    private void setSystemTrustStore(ServerConfiguration serverConfiguration) throws RegistryException {
        if (serverConfiguration != null) {
            String location = serverConfiguration.getFirstProperty("Security.TrustStore.Location");
            String password = serverConfiguration.getFirstProperty("Security.TrustStore.Password");
            String type = serverConfiguration.getFirstProperty("Security.TrustStore.Type");
            if (location != null && password != null) {
                System.setProperty("javax.net.ssl.trustStore", location);
                System.setProperty("javax.net.ssl.trustStoreType", type);
                System.setProperty("javax.net.ssl.trustStorePassword", password);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerConfiguration getServerConfiguration() throws RegistryException {
        ServerConfiguration serverConfig = ServerConfiguration.getInstance();
        try {
            File carbonXML = new File(CarbonUtils.getServerXml());
            FileInputStream inputStream = new FileInputStream(carbonXML);
            try {
                serverConfig.init((InputStream)inputStream);
            }
            finally {
                ((InputStream)inputStream).close();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error initializing the Server Configuration", (Throwable)e);
            throw new RegistryException("Error initializing the Server Configuration", e);
        }
        return serverConfig;
    }

    protected void setRealmService(RealmService realmService) {
        RegistryCoreServiceComponent.updateRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        RegistryCoreServiceComponent.updateRealmService(null);
    }

    protected synchronized void setStatisticsCollector(StatisticsCollector statisticsCollector) {
        RegistryContext.getBaseInstance().addStatisticsCollector(statisticsCollector);
    }

    protected synchronized void unsetStatisticsCollector(StatisticsCollector statisticsCollector) {
        RegistryContext.getBaseInstance().removeStatisticsCollector(statisticsCollector);
    }

    private static void updateRealmService(RealmService service) {
        realmService = service;
    }

    private static void updateRegistryConfiguration(RegistryConfiguration config) {
        registryConfig = config;
    }

    @Deprecated
    public static RegistryConfiguration getRegistryConfig() {
        return registryConfig;
    }

    @Deprecated
    public static void setRegistryConfig(RegistryConfiguration registryConfig) {
        RegistryCoreServiceComponent.registryConfig = registryConfig;
    }

    public static void addAuthorizeRoleListener(int executionId, String path, String permission, String executeAction, String[] actions) {
        if (bundleContext != null) {
            registrations.push(bundleContext.registerService(AuthorizationManagerListener.class.getName(), (Object)new AuthorizeRoleListener(executionId, path, permission, executeAction, actions), null));
        }
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    public static org.wso2.carbon.registry.core.service.RegistryService getRegistryService() {
        return registryService;
    }

    static {
        log = LogFactory.getLog(RegistryCoreServiceComponent.class);
        registrations = new Stack();
    }

    private static class TenantDeploymentListenerImpl
    extends AbstractAxis2ConfigurationContextObserver
    implements TenantRegistryLoader,
    AuthenticationObserver {
        private org.wso2.carbon.registry.core.service.RegistryService service;
        private List<Integer> initializedTenants = new LinkedList<Integer>();

        private TenantDeploymentListenerImpl(org.wso2.carbon.registry.core.service.RegistryService service) {
            this.service = service;
        }

        private synchronized boolean canInitializeTenant(int tenantId) {
            if (this.initializedTenants.contains(tenantId)) {
                return false;
            }
            this.initializedTenants.add(tenantId);
            return true;
        }

        public void createdConfigurationContext(ConfigurationContext configurationContext) {
            int tenantId = PrivilegedCarbonContext.getCurrentContext((ConfigurationContext)configurationContext).getTenantId();
            this.loadTenantRegistry(tenantId);
        }

        public void startedAuthentication(int tenantId) {
            this.loadTenantRegistry(tenantId);
        }

        @Override
        public void loadTenantRegistry(int tenantId) {
            if (tenantId != -1 && tenantId != -1234 && this.canInitializeTenant(tenantId)) {
                RegistryCoreServiceComponent.initializeTenant(this.service, tenantId);
            }
        }

        public void completedAuthentication(int tenantId, boolean isSuccessful) {
        }
    }

    public static class DefaultSimulationService
    implements SimulationService {
        @Override
        public void setSimulation(boolean simulation) {
            SimulationFilter.setSimulation(simulation);
        }

        @Override
        public Map<String, List<String[]>> getSimulationStatus() {
            return SimulationHandler.getStatus();
        }
    }
}

