/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
package org.apache.airavata.model.user;

import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;

import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.server.AbstractNonblockingServer.*;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import java.util.BitSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings({"cast", "rawtypes", "serial", "unchecked"})
/**
 * * A structure holding the user profile and its child models.
 * *
 * * Notes:
 * *  The model does not include passwords as it is assumed an external identity provider is used to authenticate user.
 * *  References:
 * *     NSF Demographic Information - http://www.nsf.gov/pubs/2000/00form1225/00form1225.doc
 * *     LDAP Schema - https://tools.ietf.org/html/rfc4519
 * *     SCIM 2.0 - https://tools.ietf.org/html/rfc7643
 * *
 * * userModelVersion:
 * *  Version number of profile
 * *
 * * airavataInternalUserId:
 * *  internal to Airavata, not intended to be used outside of the Airavata platform or possibly by gateways
 * *  (that is, never shown to users), never reassigned, REQUIRED
 * *
 * * userId:
 * *  Externally assertable unique identifier. SAML (primarly in higher education, academic) tends to keep
 * *   user name less opaque. OpenID Connect maintains them to be opaque.
 * *
 * * firstName, middleName, lastName:
 * *  First and Last names as assertede by the user
 * *
 * * namePrefix, nameSuffix:
 * *  prefix and suffix to the users name as asserted by the user
 * *
 * * emails:
 * *   Email identifier are Verified, REQUIRED and MULTIVALUED
 * *
 * * userName:
 * *  Name-based identifiers can be multivalues. To keep it simple, Airavata will make it a string.
 * *   In the future these can be enumerated as:
 *     *   Official name (as asserted possibly by some external identity provider)
 *     *   Prefered name (as asserted or suggested by user directly)
 *     *   Components:
 *     *      givenName
 *     *      surname (familyName)
 *     *      displayName (often asserted by user to handle things like middle names, suffix, prefix, and the like)
 * *
 * * orcidId: ORCID ID - http://orcid.org/about/what-is-orcid)
 * *
 * * phones: Telephone MULTIVALUED
 * *
 * * country: Country of Residance
 * *
 * * nationality Countries of citizenship
 * *
 * * comments:
 * *   Free-form information (treated as opaque by Airavata and simply passed to resource).
 * *
 * * labeledURI:
 *   * Google Scholar, Web of Science, ACS, e.t.c
 * *
 * * timeZone:
 * *  User’s preferred timezone - IANA Timezone Databases - http://www.iana.org/time-zones.
 * *
 */
@Generated(value = "Autogenerated by Thrift Compiler (0.9.3)")
public class UserProfile implements org.apache.thrift.TBase<UserProfile, UserProfile._Fields>, java.io.Serializable, Cloneable, Comparable<UserProfile> {
  private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("UserProfile");

  private static final org.apache.thrift.protocol.TField USER_MODEL_VERSION_FIELD_DESC = new org.apache.thrift.protocol.TField("userModelVersion", org.apache.thrift.protocol.TType.STRING, (short)1);
  private static final org.apache.thrift.protocol.TField AIRAVATA_INTERNAL_USER_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("airavataInternalUserId", org.apache.thrift.protocol.TType.STRING, (short)2);
  private static final org.apache.thrift.protocol.TField USER_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("userId", org.apache.thrift.protocol.TType.STRING, (short)3);
  private static final org.apache.thrift.protocol.TField GATEWAY_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("gatewayId", org.apache.thrift.protocol.TType.STRING, (short)4);
  private static final org.apache.thrift.protocol.TField EMAILS_FIELD_DESC = new org.apache.thrift.protocol.TField("emails", org.apache.thrift.protocol.TType.LIST, (short)5);
  private static final org.apache.thrift.protocol.TField FIRST_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("firstName", org.apache.thrift.protocol.TType.STRING, (short)6);
  private static final org.apache.thrift.protocol.TField LAST_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("lastName", org.apache.thrift.protocol.TType.STRING, (short)7);
  private static final org.apache.thrift.protocol.TField MIDDLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("middleName", org.apache.thrift.protocol.TType.STRING, (short)8);
  private static final org.apache.thrift.protocol.TField NAME_PREFIX_FIELD_DESC = new org.apache.thrift.protocol.TField("namePrefix", org.apache.thrift.protocol.TType.STRING, (short)9);
  private static final org.apache.thrift.protocol.TField NAME_SUFFIX_FIELD_DESC = new org.apache.thrift.protocol.TField("nameSuffix", org.apache.thrift.protocol.TType.STRING, (short)10);
  private static final org.apache.thrift.protocol.TField ORCID_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("orcidId", org.apache.thrift.protocol.TType.STRING, (short)11);
  private static final org.apache.thrift.protocol.TField PHONES_FIELD_DESC = new org.apache.thrift.protocol.TField("phones", org.apache.thrift.protocol.TType.LIST, (short)12);
  private static final org.apache.thrift.protocol.TField COUNTRY_FIELD_DESC = new org.apache.thrift.protocol.TField("country", org.apache.thrift.protocol.TType.STRING, (short)13);
  private static final org.apache.thrift.protocol.TField NATIONALITY_FIELD_DESC = new org.apache.thrift.protocol.TField("nationality", org.apache.thrift.protocol.TType.LIST, (short)14);
  private static final org.apache.thrift.protocol.TField HOME_ORGANIZATION_FIELD_DESC = new org.apache.thrift.protocol.TField("homeOrganization", org.apache.thrift.protocol.TType.STRING, (short)15);
  private static final org.apache.thrift.protocol.TField ORGINATION_AFFILIATION_FIELD_DESC = new org.apache.thrift.protocol.TField("orginationAffiliation", org.apache.thrift.protocol.TType.STRING, (short)16);
  private static final org.apache.thrift.protocol.TField CREATION_TIME_FIELD_DESC = new org.apache.thrift.protocol.TField("creationTime", org.apache.thrift.protocol.TType.I64, (short)17);
  private static final org.apache.thrift.protocol.TField LAST_ACCESS_TIME_FIELD_DESC = new org.apache.thrift.protocol.TField("lastAccessTime", org.apache.thrift.protocol.TType.I64, (short)18);
  private static final org.apache.thrift.protocol.TField VALID_UNTIL_FIELD_DESC = new org.apache.thrift.protocol.TField("validUntil", org.apache.thrift.protocol.TType.I64, (short)19);
  private static final org.apache.thrift.protocol.TField STATE_FIELD_DESC = new org.apache.thrift.protocol.TField("State", org.apache.thrift.protocol.TType.I32, (short)20);
  private static final org.apache.thrift.protocol.TField COMMENTS_FIELD_DESC = new org.apache.thrift.protocol.TField("comments", org.apache.thrift.protocol.TType.STRING, (short)21);
  private static final org.apache.thrift.protocol.TField LABELED_URI_FIELD_DESC = new org.apache.thrift.protocol.TField("labeledURI", org.apache.thrift.protocol.TType.LIST, (short)22);
  private static final org.apache.thrift.protocol.TField GPG_KEY_FIELD_DESC = new org.apache.thrift.protocol.TField("gpgKey", org.apache.thrift.protocol.TType.STRING, (short)23);
  private static final org.apache.thrift.protocol.TField TIME_ZONE_FIELD_DESC = new org.apache.thrift.protocol.TField("timeZone", org.apache.thrift.protocol.TType.STRING, (short)24);
  private static final org.apache.thrift.protocol.TField NSF_DEMOGRAPHICS_FIELD_DESC = new org.apache.thrift.protocol.TField("nsfDemographics", org.apache.thrift.protocol.TType.STRUCT, (short)25);

  private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
  static {
    schemes.put(StandardScheme.class, new UserProfileStandardSchemeFactory());
    schemes.put(TupleScheme.class, new UserProfileTupleSchemeFactory());
  }

  private String userModelVersion; // required
  private String airavataInternalUserId; // required
  private String userId; // required
  private String gatewayId; // required
  private List<String> emails; // required
  private String firstName; // required
  private String lastName; // required
  private String middleName; // optional
  private String namePrefix; // optional
  private String nameSuffix; // optional
  private String orcidId; // optional
  private List<String> phones; // optional
  private String country; // optional
  private List<String> nationality; // optional
  private String homeOrganization; // optional
  private String orginationAffiliation; // optional
  private long creationTime; // required
  private long lastAccessTime; // required
  private long validUntil; // required
  private Status State; // required
  private String comments; // optional
  private List<String> labeledURI; // optional
  private String gpgKey; // optional
  private String timeZone; // optional
  private NSFDemographics nsfDemographics; // optional

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements org.apache.thrift.TFieldIdEnum {
    USER_MODEL_VERSION((short)1, "userModelVersion"),
    AIRAVATA_INTERNAL_USER_ID((short)2, "airavataInternalUserId"),
    USER_ID((short)3, "userId"),
    GATEWAY_ID((short)4, "gatewayId"),
    EMAILS((short)5, "emails"),
    FIRST_NAME((short)6, "firstName"),
    LAST_NAME((short)7, "lastName"),
    MIDDLE_NAME((short)8, "middleName"),
    NAME_PREFIX((short)9, "namePrefix"),
    NAME_SUFFIX((short)10, "nameSuffix"),
    ORCID_ID((short)11, "orcidId"),
    PHONES((short)12, "phones"),
    COUNTRY((short)13, "country"),
    NATIONALITY((short)14, "nationality"),
    HOME_ORGANIZATION((short)15, "homeOrganization"),
    ORGINATION_AFFILIATION((short)16, "orginationAffiliation"),
    CREATION_TIME((short)17, "creationTime"),
    LAST_ACCESS_TIME((short)18, "lastAccessTime"),
    VALID_UNTIL((short)19, "validUntil"),
    /**
     * 
     * @see Status
     */
    STATE((short)20, "State"),
    COMMENTS((short)21, "comments"),
    LABELED_URI((short)22, "labeledURI"),
    GPG_KEY((short)23, "gpgKey"),
    TIME_ZONE((short)24, "timeZone"),
    NSF_DEMOGRAPHICS((short)25, "nsfDemographics");

    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }

    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      switch(fieldId) {
        case 1: // USER_MODEL_VERSION
          return USER_MODEL_VERSION;
        case 2: // AIRAVATA_INTERNAL_USER_ID
          return AIRAVATA_INTERNAL_USER_ID;
        case 3: // USER_ID
          return USER_ID;
        case 4: // GATEWAY_ID
          return GATEWAY_ID;
        case 5: // EMAILS
          return EMAILS;
        case 6: // FIRST_NAME
          return FIRST_NAME;
        case 7: // LAST_NAME
          return LAST_NAME;
        case 8: // MIDDLE_NAME
          return MIDDLE_NAME;
        case 9: // NAME_PREFIX
          return NAME_PREFIX;
        case 10: // NAME_SUFFIX
          return NAME_SUFFIX;
        case 11: // ORCID_ID
          return ORCID_ID;
        case 12: // PHONES
          return PHONES;
        case 13: // COUNTRY
          return COUNTRY;
        case 14: // NATIONALITY
          return NATIONALITY;
        case 15: // HOME_ORGANIZATION
          return HOME_ORGANIZATION;
        case 16: // ORGINATION_AFFILIATION
          return ORGINATION_AFFILIATION;
        case 17: // CREATION_TIME
          return CREATION_TIME;
        case 18: // LAST_ACCESS_TIME
          return LAST_ACCESS_TIME;
        case 19: // VALID_UNTIL
          return VALID_UNTIL;
        case 20: // STATE
          return STATE;
        case 21: // COMMENTS
          return COMMENTS;
        case 22: // LABELED_URI
          return LABELED_URI;
        case 23: // GPG_KEY
          return GPG_KEY;
        case 24: // TIME_ZONE
          return TIME_ZONE;
        case 25: // NSF_DEMOGRAPHICS
          return NSF_DEMOGRAPHICS;
        default:
          return null;
      }
    }

    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }

    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }

    private final short _thriftId;
    private final String _fieldName;

    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }

    public short getThriftFieldId() {
      return _thriftId;
    }

    public String getFieldName() {
      return _fieldName;
    }
  }

  // isset id assignments
  private static final int __CREATIONTIME_ISSET_ID = 0;
  private static final int __LASTACCESSTIME_ISSET_ID = 1;
  private static final int __VALIDUNTIL_ISSET_ID = 2;
  private byte __isset_bitfield = 0;
  private static final _Fields optionals[] = {_Fields.MIDDLE_NAME,_Fields.NAME_PREFIX,_Fields.NAME_SUFFIX,_Fields.ORCID_ID,_Fields.PHONES,_Fields.COUNTRY,_Fields.NATIONALITY,_Fields.HOME_ORGANIZATION,_Fields.ORGINATION_AFFILIATION,_Fields.COMMENTS,_Fields.LABELED_URI,_Fields.GPG_KEY,_Fields.TIME_ZONE,_Fields.NSF_DEMOGRAPHICS};
  public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
  static {
    Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
    tmpMap.put(_Fields.USER_MODEL_VERSION, new org.apache.thrift.meta_data.FieldMetaData("userModelVersion", org.apache.thrift.TFieldRequirementType.REQUIRED, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.AIRAVATA_INTERNAL_USER_ID, new org.apache.thrift.meta_data.FieldMetaData("airavataInternalUserId", org.apache.thrift.TFieldRequirementType.REQUIRED, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.USER_ID, new org.apache.thrift.meta_data.FieldMetaData("userId", org.apache.thrift.TFieldRequirementType.REQUIRED, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.GATEWAY_ID, new org.apache.thrift.meta_data.FieldMetaData("gatewayId", org.apache.thrift.TFieldRequirementType.REQUIRED, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.EMAILS, new org.apache.thrift.meta_data.FieldMetaData("emails", org.apache.thrift.TFieldRequirementType.REQUIRED, 
        new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
            new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING))));
    tmpMap.put(_Fields.FIRST_NAME, new org.apache.thrift.meta_data.FieldMetaData("firstName", org.apache.thrift.TFieldRequirementType.REQUIRED, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.LAST_NAME, new org.apache.thrift.meta_data.FieldMetaData("lastName", org.apache.thrift.TFieldRequirementType.REQUIRED, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.MIDDLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("middleName", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.NAME_PREFIX, new org.apache.thrift.meta_data.FieldMetaData("namePrefix", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.NAME_SUFFIX, new org.apache.thrift.meta_data.FieldMetaData("nameSuffix", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.ORCID_ID, new org.apache.thrift.meta_data.FieldMetaData("orcidId", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.PHONES, new org.apache.thrift.meta_data.FieldMetaData("phones", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
            new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING))));
    tmpMap.put(_Fields.COUNTRY, new org.apache.thrift.meta_data.FieldMetaData("country", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.NATIONALITY, new org.apache.thrift.meta_data.FieldMetaData("nationality", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
            new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING))));
    tmpMap.put(_Fields.HOME_ORGANIZATION, new org.apache.thrift.meta_data.FieldMetaData("homeOrganization", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.ORGINATION_AFFILIATION, new org.apache.thrift.meta_data.FieldMetaData("orginationAffiliation", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.CREATION_TIME, new org.apache.thrift.meta_data.FieldMetaData("creationTime", org.apache.thrift.TFieldRequirementType.REQUIRED, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
    tmpMap.put(_Fields.LAST_ACCESS_TIME, new org.apache.thrift.meta_data.FieldMetaData("lastAccessTime", org.apache.thrift.TFieldRequirementType.REQUIRED, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
    tmpMap.put(_Fields.VALID_UNTIL, new org.apache.thrift.meta_data.FieldMetaData("validUntil", org.apache.thrift.TFieldRequirementType.REQUIRED, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
    tmpMap.put(_Fields.STATE, new org.apache.thrift.meta_data.FieldMetaData("State", org.apache.thrift.TFieldRequirementType.REQUIRED, 
        new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, Status.class)));
    tmpMap.put(_Fields.COMMENTS, new org.apache.thrift.meta_data.FieldMetaData("comments", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.LABELED_URI, new org.apache.thrift.meta_data.FieldMetaData("labeledURI", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
            new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING))));
    tmpMap.put(_Fields.GPG_KEY, new org.apache.thrift.meta_data.FieldMetaData("gpgKey", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.TIME_ZONE, new org.apache.thrift.meta_data.FieldMetaData("timeZone", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.NSF_DEMOGRAPHICS, new org.apache.thrift.meta_data.FieldMetaData("nsfDemographics", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, NSFDemographics.class)));
    metaDataMap = Collections.unmodifiableMap(tmpMap);
    org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(UserProfile.class, metaDataMap);
  }

  public UserProfile() {
    this.userModelVersion = "1.0";

    this.airavataInternalUserId = "DO_NOT_SET_AT_CLIENTS";

  }

  public UserProfile(
    String userModelVersion,
    String airavataInternalUserId,
    String userId,
    String gatewayId,
    List<String> emails,
    String firstName,
    String lastName,
    long creationTime,
    long lastAccessTime,
    long validUntil,
    Status State)
  {
    this();
    this.userModelVersion = userModelVersion;
    this.airavataInternalUserId = airavataInternalUserId;
    this.userId = userId;
    this.gatewayId = gatewayId;
    this.emails = emails;
    this.firstName = firstName;
    this.lastName = lastName;
    this.creationTime = creationTime;
    setCreationTimeIsSet(true);
    this.lastAccessTime = lastAccessTime;
    setLastAccessTimeIsSet(true);
    this.validUntil = validUntil;
    setValidUntilIsSet(true);
    this.State = State;
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public UserProfile(UserProfile other) {
    __isset_bitfield = other.__isset_bitfield;
    if (other.isSetUserModelVersion()) {
      this.userModelVersion = other.userModelVersion;
    }
    if (other.isSetAiravataInternalUserId()) {
      this.airavataInternalUserId = other.airavataInternalUserId;
    }
    if (other.isSetUserId()) {
      this.userId = other.userId;
    }
    if (other.isSetGatewayId()) {
      this.gatewayId = other.gatewayId;
    }
    if (other.isSetEmails()) {
      List<String> __this__emails = new ArrayList<String>(other.emails);
      this.emails = __this__emails;
    }
    if (other.isSetFirstName()) {
      this.firstName = other.firstName;
    }
    if (other.isSetLastName()) {
      this.lastName = other.lastName;
    }
    if (other.isSetMiddleName()) {
      this.middleName = other.middleName;
    }
    if (other.isSetNamePrefix()) {
      this.namePrefix = other.namePrefix;
    }
    if (other.isSetNameSuffix()) {
      this.nameSuffix = other.nameSuffix;
    }
    if (other.isSetOrcidId()) {
      this.orcidId = other.orcidId;
    }
    if (other.isSetPhones()) {
      List<String> __this__phones = new ArrayList<String>(other.phones);
      this.phones = __this__phones;
    }
    if (other.isSetCountry()) {
      this.country = other.country;
    }
    if (other.isSetNationality()) {
      List<String> __this__nationality = new ArrayList<String>(other.nationality);
      this.nationality = __this__nationality;
    }
    if (other.isSetHomeOrganization()) {
      this.homeOrganization = other.homeOrganization;
    }
    if (other.isSetOrginationAffiliation()) {
      this.orginationAffiliation = other.orginationAffiliation;
    }
    this.creationTime = other.creationTime;
    this.lastAccessTime = other.lastAccessTime;
    this.validUntil = other.validUntil;
    if (other.isSetState()) {
      this.State = other.State;
    }
    if (other.isSetComments()) {
      this.comments = other.comments;
    }
    if (other.isSetLabeledURI()) {
      List<String> __this__labeledURI = new ArrayList<String>(other.labeledURI);
      this.labeledURI = __this__labeledURI;
    }
    if (other.isSetGpgKey()) {
      this.gpgKey = other.gpgKey;
    }
    if (other.isSetTimeZone()) {
      this.timeZone = other.timeZone;
    }
    if (other.isSetNsfDemographics()) {
      this.nsfDemographics = new NSFDemographics(other.nsfDemographics);
    }
  }

  public UserProfile deepCopy() {
    return new UserProfile(this);
  }

  @Override
  public void clear() {
    this.userModelVersion = "1.0";

    this.airavataInternalUserId = "DO_NOT_SET_AT_CLIENTS";

    this.userId = null;
    this.gatewayId = null;
    this.emails = null;
    this.firstName = null;
    this.lastName = null;
    this.middleName = null;
    this.namePrefix = null;
    this.nameSuffix = null;
    this.orcidId = null;
    this.phones = null;
    this.country = null;
    this.nationality = null;
    this.homeOrganization = null;
    this.orginationAffiliation = null;
    setCreationTimeIsSet(false);
    this.creationTime = 0;
    setLastAccessTimeIsSet(false);
    this.lastAccessTime = 0;
    setValidUntilIsSet(false);
    this.validUntil = 0;
    this.State = null;
    this.comments = null;
    this.labeledURI = null;
    this.gpgKey = null;
    this.timeZone = null;
    this.nsfDemographics = null;
  }

  public String getUserModelVersion() {
    return this.userModelVersion;
  }

  public void setUserModelVersion(String userModelVersion) {
    this.userModelVersion = userModelVersion;
  }

  public void unsetUserModelVersion() {
    this.userModelVersion = null;
  }

  /** Returns true if field userModelVersion is set (has been assigned a value) and false otherwise */
  public boolean isSetUserModelVersion() {
    return this.userModelVersion != null;
  }

  public void setUserModelVersionIsSet(boolean value) {
    if (!value) {
      this.userModelVersion = null;
    }
  }

  public String getAiravataInternalUserId() {
    return this.airavataInternalUserId;
  }

  public void setAiravataInternalUserId(String airavataInternalUserId) {
    this.airavataInternalUserId = airavataInternalUserId;
  }

  public void unsetAiravataInternalUserId() {
    this.airavataInternalUserId = null;
  }

  /** Returns true if field airavataInternalUserId is set (has been assigned a value) and false otherwise */
  public boolean isSetAiravataInternalUserId() {
    return this.airavataInternalUserId != null;
  }

  public void setAiravataInternalUserIdIsSet(boolean value) {
    if (!value) {
      this.airavataInternalUserId = null;
    }
  }

  public String getUserId() {
    return this.userId;
  }

  public void setUserId(String userId) {
    this.userId = userId;
  }

  public void unsetUserId() {
    this.userId = null;
  }

  /** Returns true if field userId is set (has been assigned a value) and false otherwise */
  public boolean isSetUserId() {
    return this.userId != null;
  }

  public void setUserIdIsSet(boolean value) {
    if (!value) {
      this.userId = null;
    }
  }

  public String getGatewayId() {
    return this.gatewayId;
  }

  public void setGatewayId(String gatewayId) {
    this.gatewayId = gatewayId;
  }

  public void unsetGatewayId() {
    this.gatewayId = null;
  }

  /** Returns true if field gatewayId is set (has been assigned a value) and false otherwise */
  public boolean isSetGatewayId() {
    return this.gatewayId != null;
  }

  public void setGatewayIdIsSet(boolean value) {
    if (!value) {
      this.gatewayId = null;
    }
  }

  public int getEmailsSize() {
    return (this.emails == null) ? 0 : this.emails.size();
  }

  public java.util.Iterator<String> getEmailsIterator() {
    return (this.emails == null) ? null : this.emails.iterator();
  }

  public void addToEmails(String elem) {
    if (this.emails == null) {
      this.emails = new ArrayList<String>();
    }
    this.emails.add(elem);
  }

  public List<String> getEmails() {
    return this.emails;
  }

  public void setEmails(List<String> emails) {
    this.emails = emails;
  }

  public void unsetEmails() {
    this.emails = null;
  }

  /** Returns true if field emails is set (has been assigned a value) and false otherwise */
  public boolean isSetEmails() {
    return this.emails != null;
  }

  public void setEmailsIsSet(boolean value) {
    if (!value) {
      this.emails = null;
    }
  }

  public String getFirstName() {
    return this.firstName;
  }

  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }

  public void unsetFirstName() {
    this.firstName = null;
  }

  /** Returns true if field firstName is set (has been assigned a value) and false otherwise */
  public boolean isSetFirstName() {
    return this.firstName != null;
  }

  public void setFirstNameIsSet(boolean value) {
    if (!value) {
      this.firstName = null;
    }
  }

  public String getLastName() {
    return this.lastName;
  }

  public void setLastName(String lastName) {
    this.lastName = lastName;
  }

  public void unsetLastName() {
    this.lastName = null;
  }

  /** Returns true if field lastName is set (has been assigned a value) and false otherwise */
  public boolean isSetLastName() {
    return this.lastName != null;
  }

  public void setLastNameIsSet(boolean value) {
    if (!value) {
      this.lastName = null;
    }
  }

  public String getMiddleName() {
    return this.middleName;
  }

  public void setMiddleName(String middleName) {
    this.middleName = middleName;
  }

  public void unsetMiddleName() {
    this.middleName = null;
  }

  /** Returns true if field middleName is set (has been assigned a value) and false otherwise */
  public boolean isSetMiddleName() {
    return this.middleName != null;
  }

  public void setMiddleNameIsSet(boolean value) {
    if (!value) {
      this.middleName = null;
    }
  }

  public String getNamePrefix() {
    return this.namePrefix;
  }

  public void setNamePrefix(String namePrefix) {
    this.namePrefix = namePrefix;
  }

  public void unsetNamePrefix() {
    this.namePrefix = null;
  }

  /** Returns true if field namePrefix is set (has been assigned a value) and false otherwise */
  public boolean isSetNamePrefix() {
    return this.namePrefix != null;
  }

  public void setNamePrefixIsSet(boolean value) {
    if (!value) {
      this.namePrefix = null;
    }
  }

  public String getNameSuffix() {
    return this.nameSuffix;
  }

  public void setNameSuffix(String nameSuffix) {
    this.nameSuffix = nameSuffix;
  }

  public void unsetNameSuffix() {
    this.nameSuffix = null;
  }

  /** Returns true if field nameSuffix is set (has been assigned a value) and false otherwise */
  public boolean isSetNameSuffix() {
    return this.nameSuffix != null;
  }

  public void setNameSuffixIsSet(boolean value) {
    if (!value) {
      this.nameSuffix = null;
    }
  }

  public String getOrcidId() {
    return this.orcidId;
  }

  public void setOrcidId(String orcidId) {
    this.orcidId = orcidId;
  }

  public void unsetOrcidId() {
    this.orcidId = null;
  }

  /** Returns true if field orcidId is set (has been assigned a value) and false otherwise */
  public boolean isSetOrcidId() {
    return this.orcidId != null;
  }

  public void setOrcidIdIsSet(boolean value) {
    if (!value) {
      this.orcidId = null;
    }
  }

  public int getPhonesSize() {
    return (this.phones == null) ? 0 : this.phones.size();
  }

  public java.util.Iterator<String> getPhonesIterator() {
    return (this.phones == null) ? null : this.phones.iterator();
  }

  public void addToPhones(String elem) {
    if (this.phones == null) {
      this.phones = new ArrayList<String>();
    }
    this.phones.add(elem);
  }

  public List<String> getPhones() {
    return this.phones;
  }

  public void setPhones(List<String> phones) {
    this.phones = phones;
  }

  public void unsetPhones() {
    this.phones = null;
  }

  /** Returns true if field phones is set (has been assigned a value) and false otherwise */
  public boolean isSetPhones() {
    return this.phones != null;
  }

  public void setPhonesIsSet(boolean value) {
    if (!value) {
      this.phones = null;
    }
  }

  public String getCountry() {
    return this.country;
  }

  public void setCountry(String country) {
    this.country = country;
  }

  public void unsetCountry() {
    this.country = null;
  }

  /** Returns true if field country is set (has been assigned a value) and false otherwise */
  public boolean isSetCountry() {
    return this.country != null;
  }

  public void setCountryIsSet(boolean value) {
    if (!value) {
      this.country = null;
    }
  }

  public int getNationalitySize() {
    return (this.nationality == null) ? 0 : this.nationality.size();
  }

  public java.util.Iterator<String> getNationalityIterator() {
    return (this.nationality == null) ? null : this.nationality.iterator();
  }

  public void addToNationality(String elem) {
    if (this.nationality == null) {
      this.nationality = new ArrayList<String>();
    }
    this.nationality.add(elem);
  }

  public List<String> getNationality() {
    return this.nationality;
  }

  public void setNationality(List<String> nationality) {
    this.nationality = nationality;
  }

  public void unsetNationality() {
    this.nationality = null;
  }

  /** Returns true if field nationality is set (has been assigned a value) and false otherwise */
  public boolean isSetNationality() {
    return this.nationality != null;
  }

  public void setNationalityIsSet(boolean value) {
    if (!value) {
      this.nationality = null;
    }
  }

  public String getHomeOrganization() {
    return this.homeOrganization;
  }

  public void setHomeOrganization(String homeOrganization) {
    this.homeOrganization = homeOrganization;
  }

  public void unsetHomeOrganization() {
    this.homeOrganization = null;
  }

  /** Returns true if field homeOrganization is set (has been assigned a value) and false otherwise */
  public boolean isSetHomeOrganization() {
    return this.homeOrganization != null;
  }

  public void setHomeOrganizationIsSet(boolean value) {
    if (!value) {
      this.homeOrganization = null;
    }
  }

  public String getOrginationAffiliation() {
    return this.orginationAffiliation;
  }

  public void setOrginationAffiliation(String orginationAffiliation) {
    this.orginationAffiliation = orginationAffiliation;
  }

  public void unsetOrginationAffiliation() {
    this.orginationAffiliation = null;
  }

  /** Returns true if field orginationAffiliation is set (has been assigned a value) and false otherwise */
  public boolean isSetOrginationAffiliation() {
    return this.orginationAffiliation != null;
  }

  public void setOrginationAffiliationIsSet(boolean value) {
    if (!value) {
      this.orginationAffiliation = null;
    }
  }

  public long getCreationTime() {
    return this.creationTime;
  }

  public void setCreationTime(long creationTime) {
    this.creationTime = creationTime;
    setCreationTimeIsSet(true);
  }

  public void unsetCreationTime() {
    __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __CREATIONTIME_ISSET_ID);
  }

  /** Returns true if field creationTime is set (has been assigned a value) and false otherwise */
  public boolean isSetCreationTime() {
    return EncodingUtils.testBit(__isset_bitfield, __CREATIONTIME_ISSET_ID);
  }

  public void setCreationTimeIsSet(boolean value) {
    __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __CREATIONTIME_ISSET_ID, value);
  }

  public long getLastAccessTime() {
    return this.lastAccessTime;
  }

  public void setLastAccessTime(long lastAccessTime) {
    this.lastAccessTime = lastAccessTime;
    setLastAccessTimeIsSet(true);
  }

  public void unsetLastAccessTime() {
    __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __LASTACCESSTIME_ISSET_ID);
  }

  /** Returns true if field lastAccessTime is set (has been assigned a value) and false otherwise */
  public boolean isSetLastAccessTime() {
    return EncodingUtils.testBit(__isset_bitfield, __LASTACCESSTIME_ISSET_ID);
  }

  public void setLastAccessTimeIsSet(boolean value) {
    __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __LASTACCESSTIME_ISSET_ID, value);
  }

  public long getValidUntil() {
    return this.validUntil;
  }

  public void setValidUntil(long validUntil) {
    this.validUntil = validUntil;
    setValidUntilIsSet(true);
  }

  public void unsetValidUntil() {
    __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __VALIDUNTIL_ISSET_ID);
  }

  /** Returns true if field validUntil is set (has been assigned a value) and false otherwise */
  public boolean isSetValidUntil() {
    return EncodingUtils.testBit(__isset_bitfield, __VALIDUNTIL_ISSET_ID);
  }

  public void setValidUntilIsSet(boolean value) {
    __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __VALIDUNTIL_ISSET_ID, value);
  }

  /**
   * 
   * @see Status
   */
  public Status getState() {
    return this.State;
  }

  /**
   * 
   * @see Status
   */
  public void setState(Status State) {
    this.State = State;
  }

  public void unsetState() {
    this.State = null;
  }

  /** Returns true if field State is set (has been assigned a value) and false otherwise */
  public boolean isSetState() {
    return this.State != null;
  }

  public void setStateIsSet(boolean value) {
    if (!value) {
      this.State = null;
    }
  }

  public String getComments() {
    return this.comments;
  }

  public void setComments(String comments) {
    this.comments = comments;
  }

  public void unsetComments() {
    this.comments = null;
  }

  /** Returns true if field comments is set (has been assigned a value) and false otherwise */
  public boolean isSetComments() {
    return this.comments != null;
  }

  public void setCommentsIsSet(boolean value) {
    if (!value) {
      this.comments = null;
    }
  }

  public int getLabeledURISize() {
    return (this.labeledURI == null) ? 0 : this.labeledURI.size();
  }

  public java.util.Iterator<String> getLabeledURIIterator() {
    return (this.labeledURI == null) ? null : this.labeledURI.iterator();
  }

  public void addToLabeledURI(String elem) {
    if (this.labeledURI == null) {
      this.labeledURI = new ArrayList<String>();
    }
    this.labeledURI.add(elem);
  }

  public List<String> getLabeledURI() {
    return this.labeledURI;
  }

  public void setLabeledURI(List<String> labeledURI) {
    this.labeledURI = labeledURI;
  }

  public void unsetLabeledURI() {
    this.labeledURI = null;
  }

  /** Returns true if field labeledURI is set (has been assigned a value) and false otherwise */
  public boolean isSetLabeledURI() {
    return this.labeledURI != null;
  }

  public void setLabeledURIIsSet(boolean value) {
    if (!value) {
      this.labeledURI = null;
    }
  }

  public String getGpgKey() {
    return this.gpgKey;
  }

  public void setGpgKey(String gpgKey) {
    this.gpgKey = gpgKey;
  }

  public void unsetGpgKey() {
    this.gpgKey = null;
  }

  /** Returns true if field gpgKey is set (has been assigned a value) and false otherwise */
  public boolean isSetGpgKey() {
    return this.gpgKey != null;
  }

  public void setGpgKeyIsSet(boolean value) {
    if (!value) {
      this.gpgKey = null;
    }
  }

  public String getTimeZone() {
    return this.timeZone;
  }

  public void setTimeZone(String timeZone) {
    this.timeZone = timeZone;
  }

  public void unsetTimeZone() {
    this.timeZone = null;
  }

  /** Returns true if field timeZone is set (has been assigned a value) and false otherwise */
  public boolean isSetTimeZone() {
    return this.timeZone != null;
  }

  public void setTimeZoneIsSet(boolean value) {
    if (!value) {
      this.timeZone = null;
    }
  }

  public NSFDemographics getNsfDemographics() {
    return this.nsfDemographics;
  }

  public void setNsfDemographics(NSFDemographics nsfDemographics) {
    this.nsfDemographics = nsfDemographics;
  }

  public void unsetNsfDemographics() {
    this.nsfDemographics = null;
  }

  /** Returns true if field nsfDemographics is set (has been assigned a value) and false otherwise */
  public boolean isSetNsfDemographics() {
    return this.nsfDemographics != null;
  }

  public void setNsfDemographicsIsSet(boolean value) {
    if (!value) {
      this.nsfDemographics = null;
    }
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case USER_MODEL_VERSION:
      if (value == null) {
        unsetUserModelVersion();
      } else {
        setUserModelVersion((String)value);
      }
      break;

    case AIRAVATA_INTERNAL_USER_ID:
      if (value == null) {
        unsetAiravataInternalUserId();
      } else {
        setAiravataInternalUserId((String)value);
      }
      break;

    case USER_ID:
      if (value == null) {
        unsetUserId();
      } else {
        setUserId((String)value);
      }
      break;

    case GATEWAY_ID:
      if (value == null) {
        unsetGatewayId();
      } else {
        setGatewayId((String)value);
      }
      break;

    case EMAILS:
      if (value == null) {
        unsetEmails();
      } else {
        setEmails((List<String>)value);
      }
      break;

    case FIRST_NAME:
      if (value == null) {
        unsetFirstName();
      } else {
        setFirstName((String)value);
      }
      break;

    case LAST_NAME:
      if (value == null) {
        unsetLastName();
      } else {
        setLastName((String)value);
      }
      break;

    case MIDDLE_NAME:
      if (value == null) {
        unsetMiddleName();
      } else {
        setMiddleName((String)value);
      }
      break;

    case NAME_PREFIX:
      if (value == null) {
        unsetNamePrefix();
      } else {
        setNamePrefix((String)value);
      }
      break;

    case NAME_SUFFIX:
      if (value == null) {
        unsetNameSuffix();
      } else {
        setNameSuffix((String)value);
      }
      break;

    case ORCID_ID:
      if (value == null) {
        unsetOrcidId();
      } else {
        setOrcidId((String)value);
      }
      break;

    case PHONES:
      if (value == null) {
        unsetPhones();
      } else {
        setPhones((List<String>)value);
      }
      break;

    case COUNTRY:
      if (value == null) {
        unsetCountry();
      } else {
        setCountry((String)value);
      }
      break;

    case NATIONALITY:
      if (value == null) {
        unsetNationality();
      } else {
        setNationality((List<String>)value);
      }
      break;

    case HOME_ORGANIZATION:
      if (value == null) {
        unsetHomeOrganization();
      } else {
        setHomeOrganization((String)value);
      }
      break;

    case ORGINATION_AFFILIATION:
      if (value == null) {
        unsetOrginationAffiliation();
      } else {
        setOrginationAffiliation((String)value);
      }
      break;

    case CREATION_TIME:
      if (value == null) {
        unsetCreationTime();
      } else {
        setCreationTime((Long)value);
      }
      break;

    case LAST_ACCESS_TIME:
      if (value == null) {
        unsetLastAccessTime();
      } else {
        setLastAccessTime((Long)value);
      }
      break;

    case VALID_UNTIL:
      if (value == null) {
        unsetValidUntil();
      } else {
        setValidUntil((Long)value);
      }
      break;

    case STATE:
      if (value == null) {
        unsetState();
      } else {
        setState((Status)value);
      }
      break;

    case COMMENTS:
      if (value == null) {
        unsetComments();
      } else {
        setComments((String)value);
      }
      break;

    case LABELED_URI:
      if (value == null) {
        unsetLabeledURI();
      } else {
        setLabeledURI((List<String>)value);
      }
      break;

    case GPG_KEY:
      if (value == null) {
        unsetGpgKey();
      } else {
        setGpgKey((String)value);
      }
      break;

    case TIME_ZONE:
      if (value == null) {
        unsetTimeZone();
      } else {
        setTimeZone((String)value);
      }
      break;

    case NSF_DEMOGRAPHICS:
      if (value == null) {
        unsetNsfDemographics();
      } else {
        setNsfDemographics((NSFDemographics)value);
      }
      break;

    }
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case USER_MODEL_VERSION:
      return getUserModelVersion();

    case AIRAVATA_INTERNAL_USER_ID:
      return getAiravataInternalUserId();

    case USER_ID:
      return getUserId();

    case GATEWAY_ID:
      return getGatewayId();

    case EMAILS:
      return getEmails();

    case FIRST_NAME:
      return getFirstName();

    case LAST_NAME:
      return getLastName();

    case MIDDLE_NAME:
      return getMiddleName();

    case NAME_PREFIX:
      return getNamePrefix();

    case NAME_SUFFIX:
      return getNameSuffix();

    case ORCID_ID:
      return getOrcidId();

    case PHONES:
      return getPhones();

    case COUNTRY:
      return getCountry();

    case NATIONALITY:
      return getNationality();

    case HOME_ORGANIZATION:
      return getHomeOrganization();

    case ORGINATION_AFFILIATION:
      return getOrginationAffiliation();

    case CREATION_TIME:
      return getCreationTime();

    case LAST_ACCESS_TIME:
      return getLastAccessTime();

    case VALID_UNTIL:
      return getValidUntil();

    case STATE:
      return getState();

    case COMMENTS:
      return getComments();

    case LABELED_URI:
      return getLabeledURI();

    case GPG_KEY:
      return getGpgKey();

    case TIME_ZONE:
      return getTimeZone();

    case NSF_DEMOGRAPHICS:
      return getNsfDemographics();

    }
    throw new IllegalStateException();
  }

  /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    switch (field) {
    case USER_MODEL_VERSION:
      return isSetUserModelVersion();
    case AIRAVATA_INTERNAL_USER_ID:
      return isSetAiravataInternalUserId();
    case USER_ID:
      return isSetUserId();
    case GATEWAY_ID:
      return isSetGatewayId();
    case EMAILS:
      return isSetEmails();
    case FIRST_NAME:
      return isSetFirstName();
    case LAST_NAME:
      return isSetLastName();
    case MIDDLE_NAME:
      return isSetMiddleName();
    case NAME_PREFIX:
      return isSetNamePrefix();
    case NAME_SUFFIX:
      return isSetNameSuffix();
    case ORCID_ID:
      return isSetOrcidId();
    case PHONES:
      return isSetPhones();
    case COUNTRY:
      return isSetCountry();
    case NATIONALITY:
      return isSetNationality();
    case HOME_ORGANIZATION:
      return isSetHomeOrganization();
    case ORGINATION_AFFILIATION:
      return isSetOrginationAffiliation();
    case CREATION_TIME:
      return isSetCreationTime();
    case LAST_ACCESS_TIME:
      return isSetLastAccessTime();
    case VALID_UNTIL:
      return isSetValidUntil();
    case STATE:
      return isSetState();
    case COMMENTS:
      return isSetComments();
    case LABELED_URI:
      return isSetLabeledURI();
    case GPG_KEY:
      return isSetGpgKey();
    case TIME_ZONE:
      return isSetTimeZone();
    case NSF_DEMOGRAPHICS:
      return isSetNsfDemographics();
    }
    throw new IllegalStateException();
  }

  @Override
  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof UserProfile)
      return this.equals((UserProfile)that);
    return false;
  }

  public boolean equals(UserProfile that) {
    if (that == null)
      return false;

    boolean this_present_userModelVersion = true && this.isSetUserModelVersion();
    boolean that_present_userModelVersion = true && that.isSetUserModelVersion();
    if (this_present_userModelVersion || that_present_userModelVersion) {
      if (!(this_present_userModelVersion && that_present_userModelVersion))
        return false;
      if (!this.userModelVersion.equals(that.userModelVersion))
        return false;
    }

    boolean this_present_airavataInternalUserId = true && this.isSetAiravataInternalUserId();
    boolean that_present_airavataInternalUserId = true && that.isSetAiravataInternalUserId();
    if (this_present_airavataInternalUserId || that_present_airavataInternalUserId) {
      if (!(this_present_airavataInternalUserId && that_present_airavataInternalUserId))
        return false;
      if (!this.airavataInternalUserId.equals(that.airavataInternalUserId))
        return false;
    }

    boolean this_present_userId = true && this.isSetUserId();
    boolean that_present_userId = true && that.isSetUserId();
    if (this_present_userId || that_present_userId) {
      if (!(this_present_userId && that_present_userId))
        return false;
      if (!this.userId.equals(that.userId))
        return false;
    }

    boolean this_present_gatewayId = true && this.isSetGatewayId();
    boolean that_present_gatewayId = true && that.isSetGatewayId();
    if (this_present_gatewayId || that_present_gatewayId) {
      if (!(this_present_gatewayId && that_present_gatewayId))
        return false;
      if (!this.gatewayId.equals(that.gatewayId))
        return false;
    }

    boolean this_present_emails = true && this.isSetEmails();
    boolean that_present_emails = true && that.isSetEmails();
    if (this_present_emails || that_present_emails) {
      if (!(this_present_emails && that_present_emails))
        return false;
      if (!this.emails.equals(that.emails))
        return false;
    }

    boolean this_present_firstName = true && this.isSetFirstName();
    boolean that_present_firstName = true && that.isSetFirstName();
    if (this_present_firstName || that_present_firstName) {
      if (!(this_present_firstName && that_present_firstName))
        return false;
      if (!this.firstName.equals(that.firstName))
        return false;
    }

    boolean this_present_lastName = true && this.isSetLastName();
    boolean that_present_lastName = true && that.isSetLastName();
    if (this_present_lastName || that_present_lastName) {
      if (!(this_present_lastName && that_present_lastName))
        return false;
      if (!this.lastName.equals(that.lastName))
        return false;
    }

    boolean this_present_middleName = true && this.isSetMiddleName();
    boolean that_present_middleName = true && that.isSetMiddleName();
    if (this_present_middleName || that_present_middleName) {
      if (!(this_present_middleName && that_present_middleName))
        return false;
      if (!this.middleName.equals(that.middleName))
        return false;
    }

    boolean this_present_namePrefix = true && this.isSetNamePrefix();
    boolean that_present_namePrefix = true && that.isSetNamePrefix();
    if (this_present_namePrefix || that_present_namePrefix) {
      if (!(this_present_namePrefix && that_present_namePrefix))
        return false;
      if (!this.namePrefix.equals(that.namePrefix))
        return false;
    }

    boolean this_present_nameSuffix = true && this.isSetNameSuffix();
    boolean that_present_nameSuffix = true && that.isSetNameSuffix();
    if (this_present_nameSuffix || that_present_nameSuffix) {
      if (!(this_present_nameSuffix && that_present_nameSuffix))
        return false;
      if (!this.nameSuffix.equals(that.nameSuffix))
        return false;
    }

    boolean this_present_orcidId = true && this.isSetOrcidId();
    boolean that_present_orcidId = true && that.isSetOrcidId();
    if (this_present_orcidId || that_present_orcidId) {
      if (!(this_present_orcidId && that_present_orcidId))
        return false;
      if (!this.orcidId.equals(that.orcidId))
        return false;
    }

    boolean this_present_phones = true && this.isSetPhones();
    boolean that_present_phones = true && that.isSetPhones();
    if (this_present_phones || that_present_phones) {
      if (!(this_present_phones && that_present_phones))
        return false;
      if (!this.phones.equals(that.phones))
        return false;
    }

    boolean this_present_country = true && this.isSetCountry();
    boolean that_present_country = true && that.isSetCountry();
    if (this_present_country || that_present_country) {
      if (!(this_present_country && that_present_country))
        return false;
      if (!this.country.equals(that.country))
        return false;
    }

    boolean this_present_nationality = true && this.isSetNationality();
    boolean that_present_nationality = true && that.isSetNationality();
    if (this_present_nationality || that_present_nationality) {
      if (!(this_present_nationality && that_present_nationality))
        return false;
      if (!this.nationality.equals(that.nationality))
        return false;
    }

    boolean this_present_homeOrganization = true && this.isSetHomeOrganization();
    boolean that_present_homeOrganization = true && that.isSetHomeOrganization();
    if (this_present_homeOrganization || that_present_homeOrganization) {
      if (!(this_present_homeOrganization && that_present_homeOrganization))
        return false;
      if (!this.homeOrganization.equals(that.homeOrganization))
        return false;
    }

    boolean this_present_orginationAffiliation = true && this.isSetOrginationAffiliation();
    boolean that_present_orginationAffiliation = true && that.isSetOrginationAffiliation();
    if (this_present_orginationAffiliation || that_present_orginationAffiliation) {
      if (!(this_present_orginationAffiliation && that_present_orginationAffiliation))
        return false;
      if (!this.orginationAffiliation.equals(that.orginationAffiliation))
        return false;
    }

    boolean this_present_creationTime = true;
    boolean that_present_creationTime = true;
    if (this_present_creationTime || that_present_creationTime) {
      if (!(this_present_creationTime && that_present_creationTime))
        return false;
      if (this.creationTime != that.creationTime)
        return false;
    }

    boolean this_present_lastAccessTime = true;
    boolean that_present_lastAccessTime = true;
    if (this_present_lastAccessTime || that_present_lastAccessTime) {
      if (!(this_present_lastAccessTime && that_present_lastAccessTime))
        return false;
      if (this.lastAccessTime != that.lastAccessTime)
        return false;
    }

    boolean this_present_validUntil = true;
    boolean that_present_validUntil = true;
    if (this_present_validUntil || that_present_validUntil) {
      if (!(this_present_validUntil && that_present_validUntil))
        return false;
      if (this.validUntil != that.validUntil)
        return false;
    }

    boolean this_present_State = true && this.isSetState();
    boolean that_present_State = true && that.isSetState();
    if (this_present_State || that_present_State) {
      if (!(this_present_State && that_present_State))
        return false;
      if (!this.State.equals(that.State))
        return false;
    }

    boolean this_present_comments = true && this.isSetComments();
    boolean that_present_comments = true && that.isSetComments();
    if (this_present_comments || that_present_comments) {
      if (!(this_present_comments && that_present_comments))
        return false;
      if (!this.comments.equals(that.comments))
        return false;
    }

    boolean this_present_labeledURI = true && this.isSetLabeledURI();
    boolean that_present_labeledURI = true && that.isSetLabeledURI();
    if (this_present_labeledURI || that_present_labeledURI) {
      if (!(this_present_labeledURI && that_present_labeledURI))
        return false;
      if (!this.labeledURI.equals(that.labeledURI))
        return false;
    }

    boolean this_present_gpgKey = true && this.isSetGpgKey();
    boolean that_present_gpgKey = true && that.isSetGpgKey();
    if (this_present_gpgKey || that_present_gpgKey) {
      if (!(this_present_gpgKey && that_present_gpgKey))
        return false;
      if (!this.gpgKey.equals(that.gpgKey))
        return false;
    }

    boolean this_present_timeZone = true && this.isSetTimeZone();
    boolean that_present_timeZone = true && that.isSetTimeZone();
    if (this_present_timeZone || that_present_timeZone) {
      if (!(this_present_timeZone && that_present_timeZone))
        return false;
      if (!this.timeZone.equals(that.timeZone))
        return false;
    }

    boolean this_present_nsfDemographics = true && this.isSetNsfDemographics();
    boolean that_present_nsfDemographics = true && that.isSetNsfDemographics();
    if (this_present_nsfDemographics || that_present_nsfDemographics) {
      if (!(this_present_nsfDemographics && that_present_nsfDemographics))
        return false;
      if (!this.nsfDemographics.equals(that.nsfDemographics))
        return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    List<Object> list = new ArrayList<Object>();

    boolean present_userModelVersion = true && (isSetUserModelVersion());
    list.add(present_userModelVersion);
    if (present_userModelVersion)
      list.add(userModelVersion);

    boolean present_airavataInternalUserId = true && (isSetAiravataInternalUserId());
    list.add(present_airavataInternalUserId);
    if (present_airavataInternalUserId)
      list.add(airavataInternalUserId);

    boolean present_userId = true && (isSetUserId());
    list.add(present_userId);
    if (present_userId)
      list.add(userId);

    boolean present_gatewayId = true && (isSetGatewayId());
    list.add(present_gatewayId);
    if (present_gatewayId)
      list.add(gatewayId);

    boolean present_emails = true && (isSetEmails());
    list.add(present_emails);
    if (present_emails)
      list.add(emails);

    boolean present_firstName = true && (isSetFirstName());
    list.add(present_firstName);
    if (present_firstName)
      list.add(firstName);

    boolean present_lastName = true && (isSetLastName());
    list.add(present_lastName);
    if (present_lastName)
      list.add(lastName);

    boolean present_middleName = true && (isSetMiddleName());
    list.add(present_middleName);
    if (present_middleName)
      list.add(middleName);

    boolean present_namePrefix = true && (isSetNamePrefix());
    list.add(present_namePrefix);
    if (present_namePrefix)
      list.add(namePrefix);

    boolean present_nameSuffix = true && (isSetNameSuffix());
    list.add(present_nameSuffix);
    if (present_nameSuffix)
      list.add(nameSuffix);

    boolean present_orcidId = true && (isSetOrcidId());
    list.add(present_orcidId);
    if (present_orcidId)
      list.add(orcidId);

    boolean present_phones = true && (isSetPhones());
    list.add(present_phones);
    if (present_phones)
      list.add(phones);

    boolean present_country = true && (isSetCountry());
    list.add(present_country);
    if (present_country)
      list.add(country);

    boolean present_nationality = true && (isSetNationality());
    list.add(present_nationality);
    if (present_nationality)
      list.add(nationality);

    boolean present_homeOrganization = true && (isSetHomeOrganization());
    list.add(present_homeOrganization);
    if (present_homeOrganization)
      list.add(homeOrganization);

    boolean present_orginationAffiliation = true && (isSetOrginationAffiliation());
    list.add(present_orginationAffiliation);
    if (present_orginationAffiliation)
      list.add(orginationAffiliation);

    boolean present_creationTime = true;
    list.add(present_creationTime);
    if (present_creationTime)
      list.add(creationTime);

    boolean present_lastAccessTime = true;
    list.add(present_lastAccessTime);
    if (present_lastAccessTime)
      list.add(lastAccessTime);

    boolean present_validUntil = true;
    list.add(present_validUntil);
    if (present_validUntil)
      list.add(validUntil);

    boolean present_State = true && (isSetState());
    list.add(present_State);
    if (present_State)
      list.add(State.getValue());

    boolean present_comments = true && (isSetComments());
    list.add(present_comments);
    if (present_comments)
      list.add(comments);

    boolean present_labeledURI = true && (isSetLabeledURI());
    list.add(present_labeledURI);
    if (present_labeledURI)
      list.add(labeledURI);

    boolean present_gpgKey = true && (isSetGpgKey());
    list.add(present_gpgKey);
    if (present_gpgKey)
      list.add(gpgKey);

    boolean present_timeZone = true && (isSetTimeZone());
    list.add(present_timeZone);
    if (present_timeZone)
      list.add(timeZone);

    boolean present_nsfDemographics = true && (isSetNsfDemographics());
    list.add(present_nsfDemographics);
    if (present_nsfDemographics)
      list.add(nsfDemographics);

    return list.hashCode();
  }

  @Override
  public int compareTo(UserProfile other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;

    lastComparison = Boolean.valueOf(isSetUserModelVersion()).compareTo(other.isSetUserModelVersion());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetUserModelVersion()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.userModelVersion, other.userModelVersion);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetAiravataInternalUserId()).compareTo(other.isSetAiravataInternalUserId());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetAiravataInternalUserId()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.airavataInternalUserId, other.airavataInternalUserId);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetUserId()).compareTo(other.isSetUserId());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetUserId()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.userId, other.userId);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetGatewayId()).compareTo(other.isSetGatewayId());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetGatewayId()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.gatewayId, other.gatewayId);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetEmails()).compareTo(other.isSetEmails());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetEmails()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.emails, other.emails);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetFirstName()).compareTo(other.isSetFirstName());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetFirstName()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.firstName, other.firstName);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetLastName()).compareTo(other.isSetLastName());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetLastName()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.lastName, other.lastName);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetMiddleName()).compareTo(other.isSetMiddleName());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetMiddleName()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.middleName, other.middleName);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetNamePrefix()).compareTo(other.isSetNamePrefix());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetNamePrefix()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.namePrefix, other.namePrefix);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetNameSuffix()).compareTo(other.isSetNameSuffix());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetNameSuffix()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.nameSuffix, other.nameSuffix);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetOrcidId()).compareTo(other.isSetOrcidId());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetOrcidId()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.orcidId, other.orcidId);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetPhones()).compareTo(other.isSetPhones());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetPhones()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.phones, other.phones);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetCountry()).compareTo(other.isSetCountry());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetCountry()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.country, other.country);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetNationality()).compareTo(other.isSetNationality());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetNationality()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.nationality, other.nationality);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetHomeOrganization()).compareTo(other.isSetHomeOrganization());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetHomeOrganization()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.homeOrganization, other.homeOrganization);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetOrginationAffiliation()).compareTo(other.isSetOrginationAffiliation());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetOrginationAffiliation()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.orginationAffiliation, other.orginationAffiliation);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetCreationTime()).compareTo(other.isSetCreationTime());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetCreationTime()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.creationTime, other.creationTime);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetLastAccessTime()).compareTo(other.isSetLastAccessTime());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetLastAccessTime()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.lastAccessTime, other.lastAccessTime);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetValidUntil()).compareTo(other.isSetValidUntil());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetValidUntil()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.validUntil, other.validUntil);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetState()).compareTo(other.isSetState());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetState()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.State, other.State);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetComments()).compareTo(other.isSetComments());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetComments()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.comments, other.comments);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetLabeledURI()).compareTo(other.isSetLabeledURI());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetLabeledURI()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.labeledURI, other.labeledURI);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetGpgKey()).compareTo(other.isSetGpgKey());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetGpgKey()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.gpgKey, other.gpgKey);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetTimeZone()).compareTo(other.isSetTimeZone());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetTimeZone()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.timeZone, other.timeZone);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetNsfDemographics()).compareTo(other.isSetNsfDemographics());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetNsfDemographics()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.nsfDemographics, other.nsfDemographics);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    return 0;
  }

  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }

  public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
    schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
  }

  public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
    schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("UserProfile(");
    boolean first = true;

    sb.append("userModelVersion:");
    if (this.userModelVersion == null) {
      sb.append("null");
    } else {
      sb.append(this.userModelVersion);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("airavataInternalUserId:");
    if (this.airavataInternalUserId == null) {
      sb.append("null");
    } else {
      sb.append(this.airavataInternalUserId);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("userId:");
    if (this.userId == null) {
      sb.append("null");
    } else {
      sb.append(this.userId);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("gatewayId:");
    if (this.gatewayId == null) {
      sb.append("null");
    } else {
      sb.append(this.gatewayId);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("emails:");
    if (this.emails == null) {
      sb.append("null");
    } else {
      sb.append(this.emails);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("firstName:");
    if (this.firstName == null) {
      sb.append("null");
    } else {
      sb.append(this.firstName);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("lastName:");
    if (this.lastName == null) {
      sb.append("null");
    } else {
      sb.append(this.lastName);
    }
    first = false;
    if (isSetMiddleName()) {
      if (!first) sb.append(", ");
      sb.append("middleName:");
      if (this.middleName == null) {
        sb.append("null");
      } else {
        sb.append(this.middleName);
      }
      first = false;
    }
    if (isSetNamePrefix()) {
      if (!first) sb.append(", ");
      sb.append("namePrefix:");
      if (this.namePrefix == null) {
        sb.append("null");
      } else {
        sb.append(this.namePrefix);
      }
      first = false;
    }
    if (isSetNameSuffix()) {
      if (!first) sb.append(", ");
      sb.append("nameSuffix:");
      if (this.nameSuffix == null) {
        sb.append("null");
      } else {
        sb.append(this.nameSuffix);
      }
      first = false;
    }
    if (isSetOrcidId()) {
      if (!first) sb.append(", ");
      sb.append("orcidId:");
      if (this.orcidId == null) {
        sb.append("null");
      } else {
        sb.append(this.orcidId);
      }
      first = false;
    }
    if (isSetPhones()) {
      if (!first) sb.append(", ");
      sb.append("phones:");
      if (this.phones == null) {
        sb.append("null");
      } else {
        sb.append(this.phones);
      }
      first = false;
    }
    if (isSetCountry()) {
      if (!first) sb.append(", ");
      sb.append("country:");
      if (this.country == null) {
        sb.append("null");
      } else {
        sb.append(this.country);
      }
      first = false;
    }
    if (isSetNationality()) {
      if (!first) sb.append(", ");
      sb.append("nationality:");
      if (this.nationality == null) {
        sb.append("null");
      } else {
        sb.append(this.nationality);
      }
      first = false;
    }
    if (isSetHomeOrganization()) {
      if (!first) sb.append(", ");
      sb.append("homeOrganization:");
      if (this.homeOrganization == null) {
        sb.append("null");
      } else {
        sb.append(this.homeOrganization);
      }
      first = false;
    }
    if (isSetOrginationAffiliation()) {
      if (!first) sb.append(", ");
      sb.append("orginationAffiliation:");
      if (this.orginationAffiliation == null) {
        sb.append("null");
      } else {
        sb.append(this.orginationAffiliation);
      }
      first = false;
    }
    if (!first) sb.append(", ");
    sb.append("creationTime:");
    sb.append(this.creationTime);
    first = false;
    if (!first) sb.append(", ");
    sb.append("lastAccessTime:");
    sb.append(this.lastAccessTime);
    first = false;
    if (!first) sb.append(", ");
    sb.append("validUntil:");
    sb.append(this.validUntil);
    first = false;
    if (!first) sb.append(", ");
    sb.append("State:");
    if (this.State == null) {
      sb.append("null");
    } else {
      sb.append(this.State);
    }
    first = false;
    if (isSetComments()) {
      if (!first) sb.append(", ");
      sb.append("comments:");
      if (this.comments == null) {
        sb.append("null");
      } else {
        sb.append(this.comments);
      }
      first = false;
    }
    if (isSetLabeledURI()) {
      if (!first) sb.append(", ");
      sb.append("labeledURI:");
      if (this.labeledURI == null) {
        sb.append("null");
      } else {
        sb.append(this.labeledURI);
      }
      first = false;
    }
    if (isSetGpgKey()) {
      if (!first) sb.append(", ");
      sb.append("gpgKey:");
      if (this.gpgKey == null) {
        sb.append("null");
      } else {
        sb.append(this.gpgKey);
      }
      first = false;
    }
    if (isSetTimeZone()) {
      if (!first) sb.append(", ");
      sb.append("timeZone:");
      if (this.timeZone == null) {
        sb.append("null");
      } else {
        sb.append(this.timeZone);
      }
      first = false;
    }
    if (isSetNsfDemographics()) {
      if (!first) sb.append(", ");
      sb.append("nsfDemographics:");
      if (this.nsfDemographics == null) {
        sb.append("null");
      } else {
        sb.append(this.nsfDemographics);
      }
      first = false;
    }
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws org.apache.thrift.TException {
    // check for required fields
    if (!isSetUserModelVersion()) {
      throw new org.apache.thrift.protocol.TProtocolException("Required field 'userModelVersion' is unset! Struct:" + toString());
    }

    if (!isSetAiravataInternalUserId()) {
      throw new org.apache.thrift.protocol.TProtocolException("Required field 'airavataInternalUserId' is unset! Struct:" + toString());
    }

    if (!isSetUserId()) {
      throw new org.apache.thrift.protocol.TProtocolException("Required field 'userId' is unset! Struct:" + toString());
    }

    if (!isSetGatewayId()) {
      throw new org.apache.thrift.protocol.TProtocolException("Required field 'gatewayId' is unset! Struct:" + toString());
    }

    if (!isSetEmails()) {
      throw new org.apache.thrift.protocol.TProtocolException("Required field 'emails' is unset! Struct:" + toString());
    }

    if (!isSetFirstName()) {
      throw new org.apache.thrift.protocol.TProtocolException("Required field 'firstName' is unset! Struct:" + toString());
    }

    if (!isSetLastName()) {
      throw new org.apache.thrift.protocol.TProtocolException("Required field 'lastName' is unset! Struct:" + toString());
    }

    if (!isSetCreationTime()) {
      throw new org.apache.thrift.protocol.TProtocolException("Required field 'creationTime' is unset! Struct:" + toString());
    }

    if (!isSetLastAccessTime()) {
      throw new org.apache.thrift.protocol.TProtocolException("Required field 'lastAccessTime' is unset! Struct:" + toString());
    }

    if (!isSetValidUntil()) {
      throw new org.apache.thrift.protocol.TProtocolException("Required field 'validUntil' is unset! Struct:" + toString());
    }

    if (!isSetState()) {
      throw new org.apache.thrift.protocol.TProtocolException("Required field 'State' is unset! Struct:" + toString());
    }

    // check for sub-struct validity
    if (nsfDemographics != null) {
      nsfDemographics.validate();
    }
  }

  private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
    try {
      write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
    } catch (org.apache.thrift.TException te) {
      throw new java.io.IOException(te);
    }
  }

  private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
    try {
      // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
      __isset_bitfield = 0;
      read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
    } catch (org.apache.thrift.TException te) {
      throw new java.io.IOException(te);
    }
  }

  private static class UserProfileStandardSchemeFactory implements SchemeFactory {
    public UserProfileStandardScheme getScheme() {
      return new UserProfileStandardScheme();
    }
  }

  private static class UserProfileStandardScheme extends StandardScheme<UserProfile> {

    public void read(org.apache.thrift.protocol.TProtocol iprot, UserProfile struct) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField schemeField;
      iprot.readStructBegin();
      while (true)
      {
        schemeField = iprot.readFieldBegin();
        if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
          break;
        }
        switch (schemeField.id) {
          case 1: // USER_MODEL_VERSION
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.userModelVersion = iprot.readString();
              struct.setUserModelVersionIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 2: // AIRAVATA_INTERNAL_USER_ID
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.airavataInternalUserId = iprot.readString();
              struct.setAiravataInternalUserIdIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 3: // USER_ID
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.userId = iprot.readString();
              struct.setUserIdIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 4: // GATEWAY_ID
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.gatewayId = iprot.readString();
              struct.setGatewayIdIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 5: // EMAILS
            if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
              {
                org.apache.thrift.protocol.TList _list24 = iprot.readListBegin();
                struct.emails = new ArrayList<String>(_list24.size);
                String _elem25;
                for (int _i26 = 0; _i26 < _list24.size; ++_i26)
                {
                  _elem25 = iprot.readString();
                  struct.emails.add(_elem25);
                }
                iprot.readListEnd();
              }
              struct.setEmailsIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 6: // FIRST_NAME
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.firstName = iprot.readString();
              struct.setFirstNameIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 7: // LAST_NAME
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.lastName = iprot.readString();
              struct.setLastNameIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 8: // MIDDLE_NAME
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.middleName = iprot.readString();
              struct.setMiddleNameIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 9: // NAME_PREFIX
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.namePrefix = iprot.readString();
              struct.setNamePrefixIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 10: // NAME_SUFFIX
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.nameSuffix = iprot.readString();
              struct.setNameSuffixIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 11: // ORCID_ID
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.orcidId = iprot.readString();
              struct.setOrcidIdIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 12: // PHONES
            if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
              {
                org.apache.thrift.protocol.TList _list27 = iprot.readListBegin();
                struct.phones = new ArrayList<String>(_list27.size);
                String _elem28;
                for (int _i29 = 0; _i29 < _list27.size; ++_i29)
                {
                  _elem28 = iprot.readString();
                  struct.phones.add(_elem28);
                }
                iprot.readListEnd();
              }
              struct.setPhonesIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 13: // COUNTRY
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.country = iprot.readString();
              struct.setCountryIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 14: // NATIONALITY
            if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
              {
                org.apache.thrift.protocol.TList _list30 = iprot.readListBegin();
                struct.nationality = new ArrayList<String>(_list30.size);
                String _elem31;
                for (int _i32 = 0; _i32 < _list30.size; ++_i32)
                {
                  _elem31 = iprot.readString();
                  struct.nationality.add(_elem31);
                }
                iprot.readListEnd();
              }
              struct.setNationalityIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 15: // HOME_ORGANIZATION
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.homeOrganization = iprot.readString();
              struct.setHomeOrganizationIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 16: // ORGINATION_AFFILIATION
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.orginationAffiliation = iprot.readString();
              struct.setOrginationAffiliationIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 17: // CREATION_TIME
            if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
              struct.creationTime = iprot.readI64();
              struct.setCreationTimeIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 18: // LAST_ACCESS_TIME
            if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
              struct.lastAccessTime = iprot.readI64();
              struct.setLastAccessTimeIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 19: // VALID_UNTIL
            if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
              struct.validUntil = iprot.readI64();
              struct.setValidUntilIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 20: // STATE
            if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
              struct.State = org.apache.airavata.model.user.Status.findByValue(iprot.readI32());
              struct.setStateIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 21: // COMMENTS
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.comments = iprot.readString();
              struct.setCommentsIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 22: // LABELED_URI
            if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
              {
                org.apache.thrift.protocol.TList _list33 = iprot.readListBegin();
                struct.labeledURI = new ArrayList<String>(_list33.size);
                String _elem34;
                for (int _i35 = 0; _i35 < _list33.size; ++_i35)
                {
                  _elem34 = iprot.readString();
                  struct.labeledURI.add(_elem34);
                }
                iprot.readListEnd();
              }
              struct.setLabeledURIIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 23: // GPG_KEY
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.gpgKey = iprot.readString();
              struct.setGpgKeyIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 24: // TIME_ZONE
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.timeZone = iprot.readString();
              struct.setTimeZoneIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 25: // NSF_DEMOGRAPHICS
            if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
              struct.nsfDemographics = new NSFDemographics();
              struct.nsfDemographics.read(iprot);
              struct.setNsfDemographicsIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
      struct.validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot, UserProfile struct) throws org.apache.thrift.TException {
      struct.validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (struct.userModelVersion != null) {
        oprot.writeFieldBegin(USER_MODEL_VERSION_FIELD_DESC);
        oprot.writeString(struct.userModelVersion);
        oprot.writeFieldEnd();
      }
      if (struct.airavataInternalUserId != null) {
        oprot.writeFieldBegin(AIRAVATA_INTERNAL_USER_ID_FIELD_DESC);
        oprot.writeString(struct.airavataInternalUserId);
        oprot.writeFieldEnd();
      }
      if (struct.userId != null) {
        oprot.writeFieldBegin(USER_ID_FIELD_DESC);
        oprot.writeString(struct.userId);
        oprot.writeFieldEnd();
      }
      if (struct.gatewayId != null) {
        oprot.writeFieldBegin(GATEWAY_ID_FIELD_DESC);
        oprot.writeString(struct.gatewayId);
        oprot.writeFieldEnd();
      }
      if (struct.emails != null) {
        oprot.writeFieldBegin(EMAILS_FIELD_DESC);
        {
          oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.emails.size()));
          for (String _iter36 : struct.emails)
          {
            oprot.writeString(_iter36);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      }
      if (struct.firstName != null) {
        oprot.writeFieldBegin(FIRST_NAME_FIELD_DESC);
        oprot.writeString(struct.firstName);
        oprot.writeFieldEnd();
      }
      if (struct.lastName != null) {
        oprot.writeFieldBegin(LAST_NAME_FIELD_DESC);
        oprot.writeString(struct.lastName);
        oprot.writeFieldEnd();
      }
      if (struct.middleName != null) {
        if (struct.isSetMiddleName()) {
          oprot.writeFieldBegin(MIDDLE_NAME_FIELD_DESC);
          oprot.writeString(struct.middleName);
          oprot.writeFieldEnd();
        }
      }
      if (struct.namePrefix != null) {
        if (struct.isSetNamePrefix()) {
          oprot.writeFieldBegin(NAME_PREFIX_FIELD_DESC);
          oprot.writeString(struct.namePrefix);
          oprot.writeFieldEnd();
        }
      }
      if (struct.nameSuffix != null) {
        if (struct.isSetNameSuffix()) {
          oprot.writeFieldBegin(NAME_SUFFIX_FIELD_DESC);
          oprot.writeString(struct.nameSuffix);
          oprot.writeFieldEnd();
        }
      }
      if (struct.orcidId != null) {
        if (struct.isSetOrcidId()) {
          oprot.writeFieldBegin(ORCID_ID_FIELD_DESC);
          oprot.writeString(struct.orcidId);
          oprot.writeFieldEnd();
        }
      }
      if (struct.phones != null) {
        if (struct.isSetPhones()) {
          oprot.writeFieldBegin(PHONES_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.phones.size()));
            for (String _iter37 : struct.phones)
            {
              oprot.writeString(_iter37);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
      }
      if (struct.country != null) {
        if (struct.isSetCountry()) {
          oprot.writeFieldBegin(COUNTRY_FIELD_DESC);
          oprot.writeString(struct.country);
          oprot.writeFieldEnd();
        }
      }
      if (struct.nationality != null) {
        if (struct.isSetNationality()) {
          oprot.writeFieldBegin(NATIONALITY_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.nationality.size()));
            for (String _iter38 : struct.nationality)
            {
              oprot.writeString(_iter38);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
      }
      if (struct.homeOrganization != null) {
        if (struct.isSetHomeOrganization()) {
          oprot.writeFieldBegin(HOME_ORGANIZATION_FIELD_DESC);
          oprot.writeString(struct.homeOrganization);
          oprot.writeFieldEnd();
        }
      }
      if (struct.orginationAffiliation != null) {
        if (struct.isSetOrginationAffiliation()) {
          oprot.writeFieldBegin(ORGINATION_AFFILIATION_FIELD_DESC);
          oprot.writeString(struct.orginationAffiliation);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldBegin(CREATION_TIME_FIELD_DESC);
      oprot.writeI64(struct.creationTime);
      oprot.writeFieldEnd();
      oprot.writeFieldBegin(LAST_ACCESS_TIME_FIELD_DESC);
      oprot.writeI64(struct.lastAccessTime);
      oprot.writeFieldEnd();
      oprot.writeFieldBegin(VALID_UNTIL_FIELD_DESC);
      oprot.writeI64(struct.validUntil);
      oprot.writeFieldEnd();
      if (struct.State != null) {
        oprot.writeFieldBegin(STATE_FIELD_DESC);
        oprot.writeI32(struct.State.getValue());
        oprot.writeFieldEnd();
      }
      if (struct.comments != null) {
        if (struct.isSetComments()) {
          oprot.writeFieldBegin(COMMENTS_FIELD_DESC);
          oprot.writeString(struct.comments);
          oprot.writeFieldEnd();
        }
      }
      if (struct.labeledURI != null) {
        if (struct.isSetLabeledURI()) {
          oprot.writeFieldBegin(LABELED_URI_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.labeledURI.size()));
            for (String _iter39 : struct.labeledURI)
            {
              oprot.writeString(_iter39);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
      }
      if (struct.gpgKey != null) {
        if (struct.isSetGpgKey()) {
          oprot.writeFieldBegin(GPG_KEY_FIELD_DESC);
          oprot.writeString(struct.gpgKey);
          oprot.writeFieldEnd();
        }
      }
      if (struct.timeZone != null) {
        if (struct.isSetTimeZone()) {
          oprot.writeFieldBegin(TIME_ZONE_FIELD_DESC);
          oprot.writeString(struct.timeZone);
          oprot.writeFieldEnd();
        }
      }
      if (struct.nsfDemographics != null) {
        if (struct.isSetNsfDemographics()) {
          oprot.writeFieldBegin(NSF_DEMOGRAPHICS_FIELD_DESC);
          struct.nsfDemographics.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

  }

  private static class UserProfileTupleSchemeFactory implements SchemeFactory {
    public UserProfileTupleScheme getScheme() {
      return new UserProfileTupleScheme();
    }
  }

  private static class UserProfileTupleScheme extends TupleScheme<UserProfile> {

    @Override
    public void write(org.apache.thrift.protocol.TProtocol prot, UserProfile struct) throws org.apache.thrift.TException {
      TTupleProtocol oprot = (TTupleProtocol) prot;
      oprot.writeString(struct.userModelVersion);
      oprot.writeString(struct.airavataInternalUserId);
      oprot.writeString(struct.userId);
      oprot.writeString(struct.gatewayId);
      {
        oprot.writeI32(struct.emails.size());
        for (String _iter40 : struct.emails)
        {
          oprot.writeString(_iter40);
        }
      }
      oprot.writeString(struct.firstName);
      oprot.writeString(struct.lastName);
      oprot.writeI64(struct.creationTime);
      oprot.writeI64(struct.lastAccessTime);
      oprot.writeI64(struct.validUntil);
      oprot.writeI32(struct.State.getValue());
      BitSet optionals = new BitSet();
      if (struct.isSetMiddleName()) {
        optionals.set(0);
      }
      if (struct.isSetNamePrefix()) {
        optionals.set(1);
      }
      if (struct.isSetNameSuffix()) {
        optionals.set(2);
      }
      if (struct.isSetOrcidId()) {
        optionals.set(3);
      }
      if (struct.isSetPhones()) {
        optionals.set(4);
      }
      if (struct.isSetCountry()) {
        optionals.set(5);
      }
      if (struct.isSetNationality()) {
        optionals.set(6);
      }
      if (struct.isSetHomeOrganization()) {
        optionals.set(7);
      }
      if (struct.isSetOrginationAffiliation()) {
        optionals.set(8);
      }
      if (struct.isSetComments()) {
        optionals.set(9);
      }
      if (struct.isSetLabeledURI()) {
        optionals.set(10);
      }
      if (struct.isSetGpgKey()) {
        optionals.set(11);
      }
      if (struct.isSetTimeZone()) {
        optionals.set(12);
      }
      if (struct.isSetNsfDemographics()) {
        optionals.set(13);
      }
      oprot.writeBitSet(optionals, 14);
      if (struct.isSetMiddleName()) {
        oprot.writeString(struct.middleName);
      }
      if (struct.isSetNamePrefix()) {
        oprot.writeString(struct.namePrefix);
      }
      if (struct.isSetNameSuffix()) {
        oprot.writeString(struct.nameSuffix);
      }
      if (struct.isSetOrcidId()) {
        oprot.writeString(struct.orcidId);
      }
      if (struct.isSetPhones()) {
        {
          oprot.writeI32(struct.phones.size());
          for (String _iter41 : struct.phones)
          {
            oprot.writeString(_iter41);
          }
        }
      }
      if (struct.isSetCountry()) {
        oprot.writeString(struct.country);
      }
      if (struct.isSetNationality()) {
        {
          oprot.writeI32(struct.nationality.size());
          for (String _iter42 : struct.nationality)
          {
            oprot.writeString(_iter42);
          }
        }
      }
      if (struct.isSetHomeOrganization()) {
        oprot.writeString(struct.homeOrganization);
      }
      if (struct.isSetOrginationAffiliation()) {
        oprot.writeString(struct.orginationAffiliation);
      }
      if (struct.isSetComments()) {
        oprot.writeString(struct.comments);
      }
      if (struct.isSetLabeledURI()) {
        {
          oprot.writeI32(struct.labeledURI.size());
          for (String _iter43 : struct.labeledURI)
          {
            oprot.writeString(_iter43);
          }
        }
      }
      if (struct.isSetGpgKey()) {
        oprot.writeString(struct.gpgKey);
      }
      if (struct.isSetTimeZone()) {
        oprot.writeString(struct.timeZone);
      }
      if (struct.isSetNsfDemographics()) {
        struct.nsfDemographics.write(oprot);
      }
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol prot, UserProfile struct) throws org.apache.thrift.TException {
      TTupleProtocol iprot = (TTupleProtocol) prot;
      struct.userModelVersion = iprot.readString();
      struct.setUserModelVersionIsSet(true);
      struct.airavataInternalUserId = iprot.readString();
      struct.setAiravataInternalUserIdIsSet(true);
      struct.userId = iprot.readString();
      struct.setUserIdIsSet(true);
      struct.gatewayId = iprot.readString();
      struct.setGatewayIdIsSet(true);
      {
        org.apache.thrift.protocol.TList _list44 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
        struct.emails = new ArrayList<String>(_list44.size);
        String _elem45;
        for (int _i46 = 0; _i46 < _list44.size; ++_i46)
        {
          _elem45 = iprot.readString();
          struct.emails.add(_elem45);
        }
      }
      struct.setEmailsIsSet(true);
      struct.firstName = iprot.readString();
      struct.setFirstNameIsSet(true);
      struct.lastName = iprot.readString();
      struct.setLastNameIsSet(true);
      struct.creationTime = iprot.readI64();
      struct.setCreationTimeIsSet(true);
      struct.lastAccessTime = iprot.readI64();
      struct.setLastAccessTimeIsSet(true);
      struct.validUntil = iprot.readI64();
      struct.setValidUntilIsSet(true);
      struct.State = org.apache.airavata.model.user.Status.findByValue(iprot.readI32());
      struct.setStateIsSet(true);
      BitSet incoming = iprot.readBitSet(14);
      if (incoming.get(0)) {
        struct.middleName = iprot.readString();
        struct.setMiddleNameIsSet(true);
      }
      if (incoming.get(1)) {
        struct.namePrefix = iprot.readString();
        struct.setNamePrefixIsSet(true);
      }
      if (incoming.get(2)) {
        struct.nameSuffix = iprot.readString();
        struct.setNameSuffixIsSet(true);
      }
      if (incoming.get(3)) {
        struct.orcidId = iprot.readString();
        struct.setOrcidIdIsSet(true);
      }
      if (incoming.get(4)) {
        {
          org.apache.thrift.protocol.TList _list47 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
          struct.phones = new ArrayList<String>(_list47.size);
          String _elem48;
          for (int _i49 = 0; _i49 < _list47.size; ++_i49)
          {
            _elem48 = iprot.readString();
            struct.phones.add(_elem48);
          }
        }
        struct.setPhonesIsSet(true);
      }
      if (incoming.get(5)) {
        struct.country = iprot.readString();
        struct.setCountryIsSet(true);
      }
      if (incoming.get(6)) {
        {
          org.apache.thrift.protocol.TList _list50 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
          struct.nationality = new ArrayList<String>(_list50.size);
          String _elem51;
          for (int _i52 = 0; _i52 < _list50.size; ++_i52)
          {
            _elem51 = iprot.readString();
            struct.nationality.add(_elem51);
          }
        }
        struct.setNationalityIsSet(true);
      }
      if (incoming.get(7)) {
        struct.homeOrganization = iprot.readString();
        struct.setHomeOrganizationIsSet(true);
      }
      if (incoming.get(8)) {
        struct.orginationAffiliation = iprot.readString();
        struct.setOrginationAffiliationIsSet(true);
      }
      if (incoming.get(9)) {
        struct.comments = iprot.readString();
        struct.setCommentsIsSet(true);
      }
      if (incoming.get(10)) {
        {
          org.apache.thrift.protocol.TList _list53 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
          struct.labeledURI = new ArrayList<String>(_list53.size);
          String _elem54;
          for (int _i55 = 0; _i55 < _list53.size; ++_i55)
          {
            _elem54 = iprot.readString();
            struct.labeledURI.add(_elem54);
          }
        }
        struct.setLabeledURIIsSet(true);
      }
      if (incoming.get(11)) {
        struct.gpgKey = iprot.readString();
        struct.setGpgKeyIsSet(true);
      }
      if (incoming.get(12)) {
        struct.timeZone = iprot.readString();
        struct.setTimeZoneIsSet(true);
      }
      if (incoming.get(13)) {
        struct.nsfDemographics = new NSFDemographics();
        struct.nsfDemographics.read(iprot);
        struct.setNsfDemographicsIsSet(true);
      }
    }
  }

}

