/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
#ifndef data_movement_models_TYPES_H
#define data_movement_models_TYPES_H

#include <iosfwd>

#include <thrift/Thrift.h>
#include <thrift/TApplicationException.h>
#include <thrift/protocol/TProtocol.h>
#include <thrift/transport/TTransport.h>

#include <thrift/cxxfunctional.h>
#include "airavata_commons_types.h"


namespace apache { namespace airavata { namespace model { namespace data { namespace movement {

struct DMType {
  enum type {
    COMPUTE_RESOURCE = 0,
    STORAGE_RESOURCE = 1
  };
};

extern const std::map<int, const char*> _DMType_VALUES_TO_NAMES;

struct SecurityProtocol {
  enum type {
    USERNAME_PASSWORD = 0,
    SSH_KEYS = 1,
    GSI = 2,
    KERBEROS = 3,
    OAUTH = 4,
    LOCAL = 5
  };
};

extern const std::map<int, const char*> _SecurityProtocol_VALUES_TO_NAMES;

struct DataMovementProtocol {
  enum type {
    LOCAL = 0,
    SCP = 1,
    SFTP = 2,
    GridFTP = 3,
    UNICORE_STORAGE_SERVICE = 4
  };
};

extern const std::map<int, const char*> _DataMovementProtocol_VALUES_TO_NAMES;

class SCPDataMovement;

class GridFTPDataMovement;

class UnicoreDataMovement;

class LOCALDataMovement;

class DataMovementInterface;

typedef struct _SCPDataMovement__isset {
  _SCPDataMovement__isset() : alternativeSCPHostName(false), sshPort(true) {}
  bool alternativeSCPHostName :1;
  bool sshPort :1;
} _SCPDataMovement__isset;

class SCPDataMovement {
 public:

  SCPDataMovement(const SCPDataMovement&);
  SCPDataMovement& operator=(const SCPDataMovement&);
  SCPDataMovement() : dataMovementInterfaceId("DO_NOT_SET_AT_CLIENTS"), securityProtocol((SecurityProtocol::type)0), alternativeSCPHostName(), sshPort(22) {
  }

  virtual ~SCPDataMovement() throw();
  std::string dataMovementInterfaceId;
  SecurityProtocol::type securityProtocol;
  std::string alternativeSCPHostName;
  int32_t sshPort;

  _SCPDataMovement__isset __isset;

  void __set_dataMovementInterfaceId(const std::string& val);

  void __set_securityProtocol(const SecurityProtocol::type val);

  void __set_alternativeSCPHostName(const std::string& val);

  void __set_sshPort(const int32_t val);

  bool operator == (const SCPDataMovement & rhs) const
  {
    if (!(dataMovementInterfaceId == rhs.dataMovementInterfaceId))
      return false;
    if (!(securityProtocol == rhs.securityProtocol))
      return false;
    if (__isset.alternativeSCPHostName != rhs.__isset.alternativeSCPHostName)
      return false;
    else if (__isset.alternativeSCPHostName && !(alternativeSCPHostName == rhs.alternativeSCPHostName))
      return false;
    if (__isset.sshPort != rhs.__isset.sshPort)
      return false;
    else if (__isset.sshPort && !(sshPort == rhs.sshPort))
      return false;
    return true;
  }
  bool operator != (const SCPDataMovement &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const SCPDataMovement & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

  virtual void printTo(std::ostream& out) const;
};

void swap(SCPDataMovement &a, SCPDataMovement &b);

inline std::ostream& operator<<(std::ostream& out, const SCPDataMovement& obj)
{
  obj.printTo(out);
  return out;
}


class GridFTPDataMovement {
 public:

  GridFTPDataMovement(const GridFTPDataMovement&);
  GridFTPDataMovement& operator=(const GridFTPDataMovement&);
  GridFTPDataMovement() : dataMovementInterfaceId("DO_NOT_SET_AT_CLIENTS"), securityProtocol((SecurityProtocol::type)0) {
  }

  virtual ~GridFTPDataMovement() throw();
  std::string dataMovementInterfaceId;
  SecurityProtocol::type securityProtocol;
  std::vector<std::string>  gridFTPEndPoints;

  void __set_dataMovementInterfaceId(const std::string& val);

  void __set_securityProtocol(const SecurityProtocol::type val);

  void __set_gridFTPEndPoints(const std::vector<std::string> & val);

  bool operator == (const GridFTPDataMovement & rhs) const
  {
    if (!(dataMovementInterfaceId == rhs.dataMovementInterfaceId))
      return false;
    if (!(securityProtocol == rhs.securityProtocol))
      return false;
    if (!(gridFTPEndPoints == rhs.gridFTPEndPoints))
      return false;
    return true;
  }
  bool operator != (const GridFTPDataMovement &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const GridFTPDataMovement & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

  virtual void printTo(std::ostream& out) const;
};

void swap(GridFTPDataMovement &a, GridFTPDataMovement &b);

inline std::ostream& operator<<(std::ostream& out, const GridFTPDataMovement& obj)
{
  obj.printTo(out);
  return out;
}


class UnicoreDataMovement {
 public:

  UnicoreDataMovement(const UnicoreDataMovement&);
  UnicoreDataMovement& operator=(const UnicoreDataMovement&);
  UnicoreDataMovement() : dataMovementInterfaceId("DO_NOT_SET_AT_CLIENTS"), securityProtocol((SecurityProtocol::type)0), unicoreEndPointURL() {
  }

  virtual ~UnicoreDataMovement() throw();
  std::string dataMovementInterfaceId;
  SecurityProtocol::type securityProtocol;
  std::string unicoreEndPointURL;

  void __set_dataMovementInterfaceId(const std::string& val);

  void __set_securityProtocol(const SecurityProtocol::type val);

  void __set_unicoreEndPointURL(const std::string& val);

  bool operator == (const UnicoreDataMovement & rhs) const
  {
    if (!(dataMovementInterfaceId == rhs.dataMovementInterfaceId))
      return false;
    if (!(securityProtocol == rhs.securityProtocol))
      return false;
    if (!(unicoreEndPointURL == rhs.unicoreEndPointURL))
      return false;
    return true;
  }
  bool operator != (const UnicoreDataMovement &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const UnicoreDataMovement & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

  virtual void printTo(std::ostream& out) const;
};

void swap(UnicoreDataMovement &a, UnicoreDataMovement &b);

inline std::ostream& operator<<(std::ostream& out, const UnicoreDataMovement& obj)
{
  obj.printTo(out);
  return out;
}


class LOCALDataMovement {
 public:

  LOCALDataMovement(const LOCALDataMovement&);
  LOCALDataMovement& operator=(const LOCALDataMovement&);
  LOCALDataMovement() : dataMovementInterfaceId("DO_NOT_SET_AT_CLIENTS") {
  }

  virtual ~LOCALDataMovement() throw();
  std::string dataMovementInterfaceId;

  void __set_dataMovementInterfaceId(const std::string& val);

  bool operator == (const LOCALDataMovement & rhs) const
  {
    if (!(dataMovementInterfaceId == rhs.dataMovementInterfaceId))
      return false;
    return true;
  }
  bool operator != (const LOCALDataMovement &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const LOCALDataMovement & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

  virtual void printTo(std::ostream& out) const;
};

void swap(LOCALDataMovement &a, LOCALDataMovement &b);

inline std::ostream& operator<<(std::ostream& out, const LOCALDataMovement& obj)
{
  obj.printTo(out);
  return out;
}


class DataMovementInterface {
 public:

  DataMovementInterface(const DataMovementInterface&);
  DataMovementInterface& operator=(const DataMovementInterface&);
  DataMovementInterface() : dataMovementInterfaceId(), dataMovementProtocol((DataMovementProtocol::type)0), priorityOrder(0) {
  }

  virtual ~DataMovementInterface() throw();
  std::string dataMovementInterfaceId;
  DataMovementProtocol::type dataMovementProtocol;
  int32_t priorityOrder;

  void __set_dataMovementInterfaceId(const std::string& val);

  void __set_dataMovementProtocol(const DataMovementProtocol::type val);

  void __set_priorityOrder(const int32_t val);

  bool operator == (const DataMovementInterface & rhs) const
  {
    if (!(dataMovementInterfaceId == rhs.dataMovementInterfaceId))
      return false;
    if (!(dataMovementProtocol == rhs.dataMovementProtocol))
      return false;
    if (!(priorityOrder == rhs.priorityOrder))
      return false;
    return true;
  }
  bool operator != (const DataMovementInterface &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const DataMovementInterface & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

  virtual void printTo(std::ostream& out) const;
};

void swap(DataMovementInterface &a, DataMovementInterface &b);

inline std::ostream& operator<<(std::ostream& out, const DataMovementInterface& obj)
{
  obj.printTo(out);
  return out;
}

}}}}} // namespace

#endif
