/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Autogenerated by Thrift Compiler (0.9.1)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
#include "computeResourceModel_types.h"

#include <algorithm>

namespace apache { namespace airavata { namespace model { namespace appcatalog { namespace computeresource {

int _kResourceJobManagerTypeValues[] = {
  ResourceJobManagerType::FORK,
  ResourceJobManagerType::PBS,
  ResourceJobManagerType::SLURM,
  ResourceJobManagerType::LSF,
  ResourceJobManagerType::UGE
};
const char* _kResourceJobManagerTypeNames[] = {
  "FORK",
  "PBS",
  "SLURM",
  "LSF",
  "UGE"
};
const std::map<int, const char*> _ResourceJobManagerType_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(5, _kResourceJobManagerTypeValues, _kResourceJobManagerTypeNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kJobManagerCommandValues[] = {
  JobManagerCommand::SUBMISSION,
  JobManagerCommand::JOB_MONITORING,
  JobManagerCommand::DELETION,
  JobManagerCommand::CHECK_JOB,
  JobManagerCommand::SHOW_QUEUE,
  JobManagerCommand::SHOW_RESERVATION,
  JobManagerCommand::SHOW_START
};
const char* _kJobManagerCommandNames[] = {
  "SUBMISSION",
  "JOB_MONITORING",
  "DELETION",
  "CHECK_JOB",
  "SHOW_QUEUE",
  "SHOW_RESERVATION",
  "SHOW_START"
};
const std::map<int, const char*> _JobManagerCommand_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(7, _kJobManagerCommandValues, _kJobManagerCommandNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kFileSystemsValues[] = {
  FileSystems::HOME,
  FileSystems::WORK,
  FileSystems::LOCALTMP,
  FileSystems::SCRATCH,
  FileSystems::ARCHIVE
};
const char* _kFileSystemsNames[] = {
  "HOME",
  "WORK",
  "LOCALTMP",
  "SCRATCH",
  "ARCHIVE"
};
const std::map<int, const char*> _FileSystems_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(5, _kFileSystemsValues, _kFileSystemsNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kSecurityProtocolValues[] = {
  SecurityProtocol::USERNAME_PASSWORD,
  SecurityProtocol::SSH_KEYS,
  SecurityProtocol::GSI,
  SecurityProtocol::KERBEROS,
  SecurityProtocol::OAUTH
};
const char* _kSecurityProtocolNames[] = {
  "USERNAME_PASSWORD",
  "SSH_KEYS",
  "GSI",
  "KERBEROS",
  "OAUTH"
};
const std::map<int, const char*> _SecurityProtocol_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(5, _kSecurityProtocolValues, _kSecurityProtocolNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kJobSubmissionProtocolValues[] = {
  JobSubmissionProtocol::LOCAL,
  JobSubmissionProtocol::SSH,
  JobSubmissionProtocol::GLOBUS,
  JobSubmissionProtocol::UNICORE,
  JobSubmissionProtocol::CLOUD
};
const char* _kJobSubmissionProtocolNames[] = {
  "LOCAL",
  "SSH",
  "GLOBUS",
  "UNICORE",
  "CLOUD"
};
const std::map<int, const char*> _JobSubmissionProtocol_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(5, _kJobSubmissionProtocolValues, _kJobSubmissionProtocolNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kMonitorModeValues[] = {
  MonitorMode::POLL_JOB_MANAGER,
  MonitorMode::JOB_EMAIL_NOTIFICATION_MONITOR,
  MonitorMode::XSEDE_AMQP_SUBSCRIBE
};
const char* _kMonitorModeNames[] = {
  "POLL_JOB_MANAGER",
  "JOB_EMAIL_NOTIFICATION_MONITOR",
  "XSEDE_AMQP_SUBSCRIBE"
};
const std::map<int, const char*> _MonitorMode_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(3, _kMonitorModeValues, _kMonitorModeNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kDataMovementProtocolValues[] = {
  DataMovementProtocol::LOCAL,
  DataMovementProtocol::SCP,
  DataMovementProtocol::SFTP,
  DataMovementProtocol::GridFTP,
  DataMovementProtocol::UNICORE_STORAGE_SERVICE
};
const char* _kDataMovementProtocolNames[] = {
  "LOCAL",
  "SCP",
  "SFTP",
  "GridFTP",
  "UNICORE_STORAGE_SERVICE"
};
const std::map<int, const char*> _DataMovementProtocol_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(5, _kDataMovementProtocolValues, _kDataMovementProtocolNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kProviderNameValues[] = {
  ProviderName::EC2,
  ProviderName::AWSEC2,
  ProviderName::RACKSPACE
};
const char* _kProviderNameNames[] = {
  "EC2",
  "AWSEC2",
  "RACKSPACE"
};
const std::map<int, const char*> _ProviderName_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(3, _kProviderNameValues, _kProviderNameNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

const char* ResourceJobManager::ascii_fingerprint = "F61CAF80247D0E44C8D52504F3A43BED";
const uint8_t ResourceJobManager::binary_fingerprint[16] = {0xF6,0x1C,0xAF,0x80,0x24,0x7D,0x0E,0x44,0xC8,0xD5,0x25,0x04,0xF3,0xA4,0x3B,0xED};

uint32_t ResourceJobManager::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_resourceJobManagerId = false;
  bool isset_resourceJobManagerType = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->resourceJobManagerId);
          isset_resourceJobManagerId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast0;
          xfer += iprot->readI32(ecast0);
          this->resourceJobManagerType = (ResourceJobManagerType::type)ecast0;
          isset_resourceJobManagerType = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->pushMonitoringEndpoint);
          this->__isset.pushMonitoringEndpoint = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->jobManagerBinPath);
          this->__isset.jobManagerBinPath = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_MAP) {
          {
            this->jobManagerCommands.clear();
            uint32_t _size1;
            ::apache::thrift::protocol::TType _ktype2;
            ::apache::thrift::protocol::TType _vtype3;
            xfer += iprot->readMapBegin(_ktype2, _vtype3, _size1);
            uint32_t _i5;
            for (_i5 = 0; _i5 < _size1; ++_i5)
            {
              JobManagerCommand::type _key6;
              int32_t ecast8;
              xfer += iprot->readI32(ecast8);
              _key6 = (JobManagerCommand::type)ecast8;
              std::string& _val7 = this->jobManagerCommands[_key6];
              xfer += iprot->readString(_val7);
            }
            xfer += iprot->readMapEnd();
          }
          this->__isset.jobManagerCommands = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_resourceJobManagerId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_resourceJobManagerType)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t ResourceJobManager::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("ResourceJobManager");

  xfer += oprot->writeFieldBegin("resourceJobManagerId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->resourceJobManagerId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("resourceJobManagerType", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32((int32_t)this->resourceJobManagerType);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.pushMonitoringEndpoint) {
    xfer += oprot->writeFieldBegin("pushMonitoringEndpoint", ::apache::thrift::protocol::T_STRING, 3);
    xfer += oprot->writeString(this->pushMonitoringEndpoint);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.jobManagerBinPath) {
    xfer += oprot->writeFieldBegin("jobManagerBinPath", ::apache::thrift::protocol::T_STRING, 4);
    xfer += oprot->writeString(this->jobManagerBinPath);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.jobManagerCommands) {
    xfer += oprot->writeFieldBegin("jobManagerCommands", ::apache::thrift::protocol::T_MAP, 5);
    {
      xfer += oprot->writeMapBegin(::apache::thrift::protocol::T_I32, ::apache::thrift::protocol::T_STRING, static_cast<uint32_t>(this->jobManagerCommands.size()));
      std::map<JobManagerCommand::type, std::string> ::const_iterator _iter9;
      for (_iter9 = this->jobManagerCommands.begin(); _iter9 != this->jobManagerCommands.end(); ++_iter9)
      {
        xfer += oprot->writeI32((int32_t)_iter9->first);
        xfer += oprot->writeString(_iter9->second);
      }
      xfer += oprot->writeMapEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(ResourceJobManager &a, ResourceJobManager &b) {
  using ::std::swap;
  swap(a.resourceJobManagerId, b.resourceJobManagerId);
  swap(a.resourceJobManagerType, b.resourceJobManagerType);
  swap(a.pushMonitoringEndpoint, b.pushMonitoringEndpoint);
  swap(a.jobManagerBinPath, b.jobManagerBinPath);
  swap(a.jobManagerCommands, b.jobManagerCommands);
  swap(a.__isset, b.__isset);
}

const char* BatchQueue::ascii_fingerprint = "ED0A78585E8BA402743AC1D5D510EF9E";
const uint8_t BatchQueue::binary_fingerprint[16] = {0xED,0x0A,0x78,0x58,0x5E,0x8B,0xA4,0x02,0x74,0x3A,0xC1,0xD5,0xD5,0x10,0xEF,0x9E};

uint32_t BatchQueue::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_queueName = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->queueName);
          isset_queueName = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->queueDescription);
          this->__isset.queueDescription = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->maxRunTime);
          this->__isset.maxRunTime = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->maxNodes);
          this->__isset.maxNodes = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->maxProcessors);
          this->__isset.maxProcessors = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->maxJobsInQueue);
          this->__isset.maxJobsInQueue = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->maxMemory);
          this->__isset.maxMemory = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_queueName)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t BatchQueue::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("BatchQueue");

  xfer += oprot->writeFieldBegin("queueName", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->queueName);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.queueDescription) {
    xfer += oprot->writeFieldBegin("queueDescription", ::apache::thrift::protocol::T_STRING, 2);
    xfer += oprot->writeString(this->queueDescription);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.maxRunTime) {
    xfer += oprot->writeFieldBegin("maxRunTime", ::apache::thrift::protocol::T_I32, 3);
    xfer += oprot->writeI32(this->maxRunTime);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.maxNodes) {
    xfer += oprot->writeFieldBegin("maxNodes", ::apache::thrift::protocol::T_I32, 4);
    xfer += oprot->writeI32(this->maxNodes);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.maxProcessors) {
    xfer += oprot->writeFieldBegin("maxProcessors", ::apache::thrift::protocol::T_I32, 5);
    xfer += oprot->writeI32(this->maxProcessors);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.maxJobsInQueue) {
    xfer += oprot->writeFieldBegin("maxJobsInQueue", ::apache::thrift::protocol::T_I32, 6);
    xfer += oprot->writeI32(this->maxJobsInQueue);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.maxMemory) {
    xfer += oprot->writeFieldBegin("maxMemory", ::apache::thrift::protocol::T_I32, 7);
    xfer += oprot->writeI32(this->maxMemory);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(BatchQueue &a, BatchQueue &b) {
  using ::std::swap;
  swap(a.queueName, b.queueName);
  swap(a.queueDescription, b.queueDescription);
  swap(a.maxRunTime, b.maxRunTime);
  swap(a.maxNodes, b.maxNodes);
  swap(a.maxProcessors, b.maxProcessors);
  swap(a.maxJobsInQueue, b.maxJobsInQueue);
  swap(a.maxMemory, b.maxMemory);
  swap(a.__isset, b.__isset);
}

const char* SCPDataMovement::ascii_fingerprint = "63CAE6EE336A7DBD91CCCD6E22628F4A";
const uint8_t SCPDataMovement::binary_fingerprint[16] = {0x63,0xCA,0xE6,0xEE,0x33,0x6A,0x7D,0xBD,0x91,0xCC,0xCD,0x6E,0x22,0x62,0x8F,0x4A};

uint32_t SCPDataMovement::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_dataMovementInterfaceId = false;
  bool isset_securityProtocol = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->dataMovementInterfaceId);
          isset_dataMovementInterfaceId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast10;
          xfer += iprot->readI32(ecast10);
          this->securityProtocol = (SecurityProtocol::type)ecast10;
          isset_securityProtocol = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->alternativeSCPHostName);
          this->__isset.alternativeSCPHostName = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->sshPort);
          this->__isset.sshPort = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_dataMovementInterfaceId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_securityProtocol)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t SCPDataMovement::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("SCPDataMovement");

  xfer += oprot->writeFieldBegin("dataMovementInterfaceId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->dataMovementInterfaceId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("securityProtocol", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32((int32_t)this->securityProtocol);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.alternativeSCPHostName) {
    xfer += oprot->writeFieldBegin("alternativeSCPHostName", ::apache::thrift::protocol::T_STRING, 3);
    xfer += oprot->writeString(this->alternativeSCPHostName);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.sshPort) {
    xfer += oprot->writeFieldBegin("sshPort", ::apache::thrift::protocol::T_I32, 4);
    xfer += oprot->writeI32(this->sshPort);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(SCPDataMovement &a, SCPDataMovement &b) {
  using ::std::swap;
  swap(a.dataMovementInterfaceId, b.dataMovementInterfaceId);
  swap(a.securityProtocol, b.securityProtocol);
  swap(a.alternativeSCPHostName, b.alternativeSCPHostName);
  swap(a.sshPort, b.sshPort);
  swap(a.__isset, b.__isset);
}

const char* GridFTPDataMovement::ascii_fingerprint = "790EE8B1D56A3B9B76C41DD063726E75";
const uint8_t GridFTPDataMovement::binary_fingerprint[16] = {0x79,0x0E,0xE8,0xB1,0xD5,0x6A,0x3B,0x9B,0x76,0xC4,0x1D,0xD0,0x63,0x72,0x6E,0x75};

uint32_t GridFTPDataMovement::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_dataMovementInterfaceId = false;
  bool isset_securityProtocol = false;
  bool isset_gridFTPEndPoints = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->dataMovementInterfaceId);
          isset_dataMovementInterfaceId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast11;
          xfer += iprot->readI32(ecast11);
          this->securityProtocol = (SecurityProtocol::type)ecast11;
          isset_securityProtocol = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->gridFTPEndPoints.clear();
            uint32_t _size12;
            ::apache::thrift::protocol::TType _etype15;
            xfer += iprot->readListBegin(_etype15, _size12);
            this->gridFTPEndPoints.resize(_size12);
            uint32_t _i16;
            for (_i16 = 0; _i16 < _size12; ++_i16)
            {
              xfer += iprot->readString(this->gridFTPEndPoints[_i16]);
            }
            xfer += iprot->readListEnd();
          }
          isset_gridFTPEndPoints = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_dataMovementInterfaceId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_securityProtocol)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_gridFTPEndPoints)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t GridFTPDataMovement::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("GridFTPDataMovement");

  xfer += oprot->writeFieldBegin("dataMovementInterfaceId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->dataMovementInterfaceId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("securityProtocol", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32((int32_t)this->securityProtocol);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("gridFTPEndPoints", ::apache::thrift::protocol::T_LIST, 3);
  {
    xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRING, static_cast<uint32_t>(this->gridFTPEndPoints.size()));
    std::vector<std::string> ::const_iterator _iter17;
    for (_iter17 = this->gridFTPEndPoints.begin(); _iter17 != this->gridFTPEndPoints.end(); ++_iter17)
    {
      xfer += oprot->writeString((*_iter17));
    }
    xfer += oprot->writeListEnd();
  }
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(GridFTPDataMovement &a, GridFTPDataMovement &b) {
  using ::std::swap;
  swap(a.dataMovementInterfaceId, b.dataMovementInterfaceId);
  swap(a.securityProtocol, b.securityProtocol);
  swap(a.gridFTPEndPoints, b.gridFTPEndPoints);
}

const char* UnicoreDataMovement::ascii_fingerprint = "D9F4CFE2F293A8B1052FD3031DD2C847";
const uint8_t UnicoreDataMovement::binary_fingerprint[16] = {0xD9,0xF4,0xCF,0xE2,0xF2,0x93,0xA8,0xB1,0x05,0x2F,0xD3,0x03,0x1D,0xD2,0xC8,0x47};

uint32_t UnicoreDataMovement::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_dataMovementInterfaceId = false;
  bool isset_securityProtocol = false;
  bool isset_unicoreEndPointURL = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->dataMovementInterfaceId);
          isset_dataMovementInterfaceId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast18;
          xfer += iprot->readI32(ecast18);
          this->securityProtocol = (SecurityProtocol::type)ecast18;
          isset_securityProtocol = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->unicoreEndPointURL);
          isset_unicoreEndPointURL = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_dataMovementInterfaceId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_securityProtocol)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_unicoreEndPointURL)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t UnicoreDataMovement::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("UnicoreDataMovement");

  xfer += oprot->writeFieldBegin("dataMovementInterfaceId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->dataMovementInterfaceId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("securityProtocol", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32((int32_t)this->securityProtocol);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("unicoreEndPointURL", ::apache::thrift::protocol::T_STRING, 3);
  xfer += oprot->writeString(this->unicoreEndPointURL);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(UnicoreDataMovement &a, UnicoreDataMovement &b) {
  using ::std::swap;
  swap(a.dataMovementInterfaceId, b.dataMovementInterfaceId);
  swap(a.securityProtocol, b.securityProtocol);
  swap(a.unicoreEndPointURL, b.unicoreEndPointURL);
}

const char* LOCALSubmission::ascii_fingerprint = "A5A35C842CBE1CA9D6A13C5974C6FB8F";
const uint8_t LOCALSubmission::binary_fingerprint[16] = {0xA5,0xA3,0x5C,0x84,0x2C,0xBE,0x1C,0xA9,0xD6,0xA1,0x3C,0x59,0x74,0xC6,0xFB,0x8F};

uint32_t LOCALSubmission::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_jobSubmissionInterfaceId = false;
  bool isset_resourceJobManager = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->jobSubmissionInterfaceId);
          isset_jobSubmissionInterfaceId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->resourceJobManager.read(iprot);
          isset_resourceJobManager = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_jobSubmissionInterfaceId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_resourceJobManager)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t LOCALSubmission::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("LOCALSubmission");

  xfer += oprot->writeFieldBegin("jobSubmissionInterfaceId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->jobSubmissionInterfaceId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("resourceJobManager", ::apache::thrift::protocol::T_STRUCT, 2);
  xfer += this->resourceJobManager.write(oprot);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(LOCALSubmission &a, LOCALSubmission &b) {
  using ::std::swap;
  swap(a.jobSubmissionInterfaceId, b.jobSubmissionInterfaceId);
  swap(a.resourceJobManager, b.resourceJobManager);
}

const char* LOCALDataMovement::ascii_fingerprint = "EFB929595D312AC8F305D5A794CFEDA1";
const uint8_t LOCALDataMovement::binary_fingerprint[16] = {0xEF,0xB9,0x29,0x59,0x5D,0x31,0x2A,0xC8,0xF3,0x05,0xD5,0xA7,0x94,0xCF,0xED,0xA1};

uint32_t LOCALDataMovement::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_dataMovementInterfaceId = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->dataMovementInterfaceId);
          isset_dataMovementInterfaceId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_dataMovementInterfaceId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t LOCALDataMovement::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("LOCALDataMovement");

  xfer += oprot->writeFieldBegin("dataMovementInterfaceId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->dataMovementInterfaceId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(LOCALDataMovement &a, LOCALDataMovement &b) {
  using ::std::swap;
  swap(a.dataMovementInterfaceId, b.dataMovementInterfaceId);
}

const char* SSHJobSubmission::ascii_fingerprint = "A62183DAA7AFF027173705420A9D99D0";
const uint8_t SSHJobSubmission::binary_fingerprint[16] = {0xA6,0x21,0x83,0xDA,0xA7,0xAF,0xF0,0x27,0x17,0x37,0x05,0x42,0x0A,0x9D,0x99,0xD0};

uint32_t SSHJobSubmission::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_jobSubmissionInterfaceId = false;
  bool isset_securityProtocol = false;
  bool isset_resourceJobManager = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->jobSubmissionInterfaceId);
          isset_jobSubmissionInterfaceId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast19;
          xfer += iprot->readI32(ecast19);
          this->securityProtocol = (SecurityProtocol::type)ecast19;
          isset_securityProtocol = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->resourceJobManager.read(iprot);
          isset_resourceJobManager = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->alternativeSSHHostName);
          this->__isset.alternativeSSHHostName = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->sshPort);
          this->__isset.sshPort = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast20;
          xfer += iprot->readI32(ecast20);
          this->monitorMode = (MonitorMode::type)ecast20;
          this->__isset.monitorMode = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_jobSubmissionInterfaceId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_securityProtocol)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_resourceJobManager)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t SSHJobSubmission::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("SSHJobSubmission");

  xfer += oprot->writeFieldBegin("jobSubmissionInterfaceId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->jobSubmissionInterfaceId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("securityProtocol", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32((int32_t)this->securityProtocol);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("resourceJobManager", ::apache::thrift::protocol::T_STRUCT, 3);
  xfer += this->resourceJobManager.write(oprot);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.alternativeSSHHostName) {
    xfer += oprot->writeFieldBegin("alternativeSSHHostName", ::apache::thrift::protocol::T_STRING, 4);
    xfer += oprot->writeString(this->alternativeSSHHostName);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.sshPort) {
    xfer += oprot->writeFieldBegin("sshPort", ::apache::thrift::protocol::T_I32, 5);
    xfer += oprot->writeI32(this->sshPort);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.monitorMode) {
    xfer += oprot->writeFieldBegin("monitorMode", ::apache::thrift::protocol::T_I32, 6);
    xfer += oprot->writeI32((int32_t)this->monitorMode);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(SSHJobSubmission &a, SSHJobSubmission &b) {
  using ::std::swap;
  swap(a.jobSubmissionInterfaceId, b.jobSubmissionInterfaceId);
  swap(a.securityProtocol, b.securityProtocol);
  swap(a.resourceJobManager, b.resourceJobManager);
  swap(a.alternativeSSHHostName, b.alternativeSSHHostName);
  swap(a.sshPort, b.sshPort);
  swap(a.monitorMode, b.monitorMode);
  swap(a.__isset, b.__isset);
}

const char* GlobusJobSubmission::ascii_fingerprint = "AF422FFD77BB68BA57079B8B33BC8CF7";
const uint8_t GlobusJobSubmission::binary_fingerprint[16] = {0xAF,0x42,0x2F,0xFD,0x77,0xBB,0x68,0xBA,0x57,0x07,0x9B,0x8B,0x33,0xBC,0x8C,0xF7};

uint32_t GlobusJobSubmission::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_jobSubmissionInterfaceId = false;
  bool isset_securityProtocol = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->jobSubmissionInterfaceId);
          isset_jobSubmissionInterfaceId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast21;
          xfer += iprot->readI32(ecast21);
          this->securityProtocol = (SecurityProtocol::type)ecast21;
          isset_securityProtocol = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->globusGateKeeperEndPoint.clear();
            uint32_t _size22;
            ::apache::thrift::protocol::TType _etype25;
            xfer += iprot->readListBegin(_etype25, _size22);
            this->globusGateKeeperEndPoint.resize(_size22);
            uint32_t _i26;
            for (_i26 = 0; _i26 < _size22; ++_i26)
            {
              xfer += iprot->readString(this->globusGateKeeperEndPoint[_i26]);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.globusGateKeeperEndPoint = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_jobSubmissionInterfaceId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_securityProtocol)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t GlobusJobSubmission::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("GlobusJobSubmission");

  xfer += oprot->writeFieldBegin("jobSubmissionInterfaceId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->jobSubmissionInterfaceId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("securityProtocol", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32((int32_t)this->securityProtocol);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.globusGateKeeperEndPoint) {
    xfer += oprot->writeFieldBegin("globusGateKeeperEndPoint", ::apache::thrift::protocol::T_LIST, 3);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRING, static_cast<uint32_t>(this->globusGateKeeperEndPoint.size()));
      std::vector<std::string> ::const_iterator _iter27;
      for (_iter27 = this->globusGateKeeperEndPoint.begin(); _iter27 != this->globusGateKeeperEndPoint.end(); ++_iter27)
      {
        xfer += oprot->writeString((*_iter27));
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(GlobusJobSubmission &a, GlobusJobSubmission &b) {
  using ::std::swap;
  swap(a.jobSubmissionInterfaceId, b.jobSubmissionInterfaceId);
  swap(a.securityProtocol, b.securityProtocol);
  swap(a.globusGateKeeperEndPoint, b.globusGateKeeperEndPoint);
  swap(a.__isset, b.__isset);
}

const char* UnicoreJobSubmission::ascii_fingerprint = "D9F4CFE2F293A8B1052FD3031DD2C847";
const uint8_t UnicoreJobSubmission::binary_fingerprint[16] = {0xD9,0xF4,0xCF,0xE2,0xF2,0x93,0xA8,0xB1,0x05,0x2F,0xD3,0x03,0x1D,0xD2,0xC8,0x47};

uint32_t UnicoreJobSubmission::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_jobSubmissionInterfaceId = false;
  bool isset_securityProtocol = false;
  bool isset_unicoreEndPointURL = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->jobSubmissionInterfaceId);
          isset_jobSubmissionInterfaceId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast28;
          xfer += iprot->readI32(ecast28);
          this->securityProtocol = (SecurityProtocol::type)ecast28;
          isset_securityProtocol = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->unicoreEndPointURL);
          isset_unicoreEndPointURL = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_jobSubmissionInterfaceId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_securityProtocol)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_unicoreEndPointURL)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t UnicoreJobSubmission::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("UnicoreJobSubmission");

  xfer += oprot->writeFieldBegin("jobSubmissionInterfaceId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->jobSubmissionInterfaceId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("securityProtocol", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32((int32_t)this->securityProtocol);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("unicoreEndPointURL", ::apache::thrift::protocol::T_STRING, 3);
  xfer += oprot->writeString(this->unicoreEndPointURL);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(UnicoreJobSubmission &a, UnicoreJobSubmission &b) {
  using ::std::swap;
  swap(a.jobSubmissionInterfaceId, b.jobSubmissionInterfaceId);
  swap(a.securityProtocol, b.securityProtocol);
  swap(a.unicoreEndPointURL, b.unicoreEndPointURL);
}

const char* CloudJobSubmission::ascii_fingerprint = "F98AE2E6E51F2426504F2566EB71B5CC";
const uint8_t CloudJobSubmission::binary_fingerprint[16] = {0xF9,0x8A,0xE2,0xE6,0xE5,0x1F,0x24,0x26,0x50,0x4F,0x25,0x66,0xEB,0x71,0xB5,0xCC};

uint32_t CloudJobSubmission::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_jobSubmissionInterfaceId = false;
  bool isset_securityProtocol = false;
  bool isset_nodeId = false;
  bool isset_executableType = false;
  bool isset_providerName = false;
  bool isset_userAccountName = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->jobSubmissionInterfaceId);
          isset_jobSubmissionInterfaceId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast29;
          xfer += iprot->readI32(ecast29);
          this->securityProtocol = (SecurityProtocol::type)ecast29;
          isset_securityProtocol = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->nodeId);
          isset_nodeId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->executableType);
          isset_executableType = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast30;
          xfer += iprot->readI32(ecast30);
          this->providerName = (ProviderName::type)ecast30;
          isset_providerName = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->userAccountName);
          isset_userAccountName = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_jobSubmissionInterfaceId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_securityProtocol)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_nodeId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_executableType)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_providerName)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_userAccountName)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t CloudJobSubmission::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("CloudJobSubmission");

  xfer += oprot->writeFieldBegin("jobSubmissionInterfaceId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->jobSubmissionInterfaceId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("securityProtocol", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32((int32_t)this->securityProtocol);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("nodeId", ::apache::thrift::protocol::T_STRING, 3);
  xfer += oprot->writeString(this->nodeId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("executableType", ::apache::thrift::protocol::T_STRING, 4);
  xfer += oprot->writeString(this->executableType);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("providerName", ::apache::thrift::protocol::T_I32, 5);
  xfer += oprot->writeI32((int32_t)this->providerName);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("userAccountName", ::apache::thrift::protocol::T_STRING, 6);
  xfer += oprot->writeString(this->userAccountName);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(CloudJobSubmission &a, CloudJobSubmission &b) {
  using ::std::swap;
  swap(a.jobSubmissionInterfaceId, b.jobSubmissionInterfaceId);
  swap(a.securityProtocol, b.securityProtocol);
  swap(a.nodeId, b.nodeId);
  swap(a.executableType, b.executableType);
  swap(a.providerName, b.providerName);
  swap(a.userAccountName, b.userAccountName);
}

const char* JobSubmissionInterface::ascii_fingerprint = "A0A4DD7B8243FB842E64EAC6E5DA6C7B";
const uint8_t JobSubmissionInterface::binary_fingerprint[16] = {0xA0,0xA4,0xDD,0x7B,0x82,0x43,0xFB,0x84,0x2E,0x64,0xEA,0xC6,0xE5,0xDA,0x6C,0x7B};

uint32_t JobSubmissionInterface::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_jobSubmissionInterfaceId = false;
  bool isset_jobSubmissionProtocol = false;
  bool isset_priorityOrder = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->jobSubmissionInterfaceId);
          isset_jobSubmissionInterfaceId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast31;
          xfer += iprot->readI32(ecast31);
          this->jobSubmissionProtocol = (JobSubmissionProtocol::type)ecast31;
          isset_jobSubmissionProtocol = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->priorityOrder);
          isset_priorityOrder = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_jobSubmissionInterfaceId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_jobSubmissionProtocol)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_priorityOrder)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t JobSubmissionInterface::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("JobSubmissionInterface");

  xfer += oprot->writeFieldBegin("jobSubmissionInterfaceId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->jobSubmissionInterfaceId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("jobSubmissionProtocol", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32((int32_t)this->jobSubmissionProtocol);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("priorityOrder", ::apache::thrift::protocol::T_I32, 3);
  xfer += oprot->writeI32(this->priorityOrder);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(JobSubmissionInterface &a, JobSubmissionInterface &b) {
  using ::std::swap;
  swap(a.jobSubmissionInterfaceId, b.jobSubmissionInterfaceId);
  swap(a.jobSubmissionProtocol, b.jobSubmissionProtocol);
  swap(a.priorityOrder, b.priorityOrder);
}

const char* DataMovementInterface::ascii_fingerprint = "A0A4DD7B8243FB842E64EAC6E5DA6C7B";
const uint8_t DataMovementInterface::binary_fingerprint[16] = {0xA0,0xA4,0xDD,0x7B,0x82,0x43,0xFB,0x84,0x2E,0x64,0xEA,0xC6,0xE5,0xDA,0x6C,0x7B};

uint32_t DataMovementInterface::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_dataMovementInterfaceId = false;
  bool isset_dataMovementProtocol = false;
  bool isset_priorityOrder = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->dataMovementInterfaceId);
          isset_dataMovementInterfaceId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast32;
          xfer += iprot->readI32(ecast32);
          this->dataMovementProtocol = (DataMovementProtocol::type)ecast32;
          isset_dataMovementProtocol = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->priorityOrder);
          isset_priorityOrder = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_dataMovementInterfaceId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_dataMovementProtocol)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_priorityOrder)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t DataMovementInterface::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("DataMovementInterface");

  xfer += oprot->writeFieldBegin("dataMovementInterfaceId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->dataMovementInterfaceId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("dataMovementProtocol", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32((int32_t)this->dataMovementProtocol);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("priorityOrder", ::apache::thrift::protocol::T_I32, 3);
  xfer += oprot->writeI32(this->priorityOrder);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(DataMovementInterface &a, DataMovementInterface &b) {
  using ::std::swap;
  swap(a.dataMovementInterfaceId, b.dataMovementInterfaceId);
  swap(a.dataMovementProtocol, b.dataMovementProtocol);
  swap(a.priorityOrder, b.priorityOrder);
}

const char* ComputeResourceDescription::ascii_fingerprint = "3CD4212965217787DCD6081F1744069F";
const uint8_t ComputeResourceDescription::binary_fingerprint[16] = {0x3C,0xD4,0x21,0x29,0x65,0x21,0x77,0x87,0xDC,0xD6,0x08,0x1F,0x17,0x44,0x06,0x9F};

uint32_t ComputeResourceDescription::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_computeResourceId = false;
  bool isset_hostName = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->computeResourceId);
          isset_computeResourceId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->hostName);
          isset_hostName = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->hostAliases.clear();
            uint32_t _size33;
            ::apache::thrift::protocol::TType _etype36;
            xfer += iprot->readListBegin(_etype36, _size33);
            this->hostAliases.resize(_size33);
            uint32_t _i37;
            for (_i37 = 0; _i37 < _size33; ++_i37)
            {
              xfer += iprot->readString(this->hostAliases[_i37]);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.hostAliases = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->ipAddresses.clear();
            uint32_t _size38;
            ::apache::thrift::protocol::TType _etype41;
            xfer += iprot->readListBegin(_etype41, _size38);
            this->ipAddresses.resize(_size38);
            uint32_t _i42;
            for (_i42 = 0; _i42 < _size38; ++_i42)
            {
              xfer += iprot->readString(this->ipAddresses[_i42]);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.ipAddresses = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->resourceDescription);
          this->__isset.resourceDescription = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->batchQueues.clear();
            uint32_t _size43;
            ::apache::thrift::protocol::TType _etype46;
            xfer += iprot->readListBegin(_etype46, _size43);
            this->batchQueues.resize(_size43);
            uint32_t _i47;
            for (_i47 = 0; _i47 < _size43; ++_i47)
            {
              xfer += this->batchQueues[_i47].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.batchQueues = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_MAP) {
          {
            this->fileSystems.clear();
            uint32_t _size48;
            ::apache::thrift::protocol::TType _ktype49;
            ::apache::thrift::protocol::TType _vtype50;
            xfer += iprot->readMapBegin(_ktype49, _vtype50, _size48);
            uint32_t _i52;
            for (_i52 = 0; _i52 < _size48; ++_i52)
            {
              FileSystems::type _key53;
              int32_t ecast55;
              xfer += iprot->readI32(ecast55);
              _key53 = (FileSystems::type)ecast55;
              std::string& _val54 = this->fileSystems[_key53];
              xfer += iprot->readString(_val54);
            }
            xfer += iprot->readMapEnd();
          }
          this->__isset.fileSystems = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 8:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->jobSubmissionInterfaces.clear();
            uint32_t _size56;
            ::apache::thrift::protocol::TType _etype59;
            xfer += iprot->readListBegin(_etype59, _size56);
            this->jobSubmissionInterfaces.resize(_size56);
            uint32_t _i60;
            for (_i60 = 0; _i60 < _size56; ++_i60)
            {
              xfer += this->jobSubmissionInterfaces[_i60].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.jobSubmissionInterfaces = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 9:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->dataMovementInterfaces.clear();
            uint32_t _size61;
            ::apache::thrift::protocol::TType _etype64;
            xfer += iprot->readListBegin(_etype64, _size61);
            this->dataMovementInterfaces.resize(_size61);
            uint32_t _i65;
            for (_i65 = 0; _i65 < _size61; ++_i65)
            {
              xfer += this->dataMovementInterfaces[_i65].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.dataMovementInterfaces = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 10:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->maxMemoryPerNode);
          this->__isset.maxMemoryPerNode = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_computeResourceId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_hostName)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t ComputeResourceDescription::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("ComputeResourceDescription");

  xfer += oprot->writeFieldBegin("computeResourceId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->computeResourceId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("hostName", ::apache::thrift::protocol::T_STRING, 2);
  xfer += oprot->writeString(this->hostName);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.hostAliases) {
    xfer += oprot->writeFieldBegin("hostAliases", ::apache::thrift::protocol::T_LIST, 3);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRING, static_cast<uint32_t>(this->hostAliases.size()));
      std::vector<std::string> ::const_iterator _iter66;
      for (_iter66 = this->hostAliases.begin(); _iter66 != this->hostAliases.end(); ++_iter66)
      {
        xfer += oprot->writeString((*_iter66));
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.ipAddresses) {
    xfer += oprot->writeFieldBegin("ipAddresses", ::apache::thrift::protocol::T_LIST, 4);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRING, static_cast<uint32_t>(this->ipAddresses.size()));
      std::vector<std::string> ::const_iterator _iter67;
      for (_iter67 = this->ipAddresses.begin(); _iter67 != this->ipAddresses.end(); ++_iter67)
      {
        xfer += oprot->writeString((*_iter67));
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.resourceDescription) {
    xfer += oprot->writeFieldBegin("resourceDescription", ::apache::thrift::protocol::T_STRING, 5);
    xfer += oprot->writeString(this->resourceDescription);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.batchQueues) {
    xfer += oprot->writeFieldBegin("batchQueues", ::apache::thrift::protocol::T_LIST, 6);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->batchQueues.size()));
      std::vector<BatchQueue> ::const_iterator _iter68;
      for (_iter68 = this->batchQueues.begin(); _iter68 != this->batchQueues.end(); ++_iter68)
      {
        xfer += (*_iter68).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.fileSystems) {
    xfer += oprot->writeFieldBegin("fileSystems", ::apache::thrift::protocol::T_MAP, 7);
    {
      xfer += oprot->writeMapBegin(::apache::thrift::protocol::T_I32, ::apache::thrift::protocol::T_STRING, static_cast<uint32_t>(this->fileSystems.size()));
      std::map<FileSystems::type, std::string> ::const_iterator _iter69;
      for (_iter69 = this->fileSystems.begin(); _iter69 != this->fileSystems.end(); ++_iter69)
      {
        xfer += oprot->writeI32((int32_t)_iter69->first);
        xfer += oprot->writeString(_iter69->second);
      }
      xfer += oprot->writeMapEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.jobSubmissionInterfaces) {
    xfer += oprot->writeFieldBegin("jobSubmissionInterfaces", ::apache::thrift::protocol::T_LIST, 8);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->jobSubmissionInterfaces.size()));
      std::vector<JobSubmissionInterface> ::const_iterator _iter70;
      for (_iter70 = this->jobSubmissionInterfaces.begin(); _iter70 != this->jobSubmissionInterfaces.end(); ++_iter70)
      {
        xfer += (*_iter70).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.dataMovementInterfaces) {
    xfer += oprot->writeFieldBegin("dataMovementInterfaces", ::apache::thrift::protocol::T_LIST, 9);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->dataMovementInterfaces.size()));
      std::vector<DataMovementInterface> ::const_iterator _iter71;
      for (_iter71 = this->dataMovementInterfaces.begin(); _iter71 != this->dataMovementInterfaces.end(); ++_iter71)
      {
        xfer += (*_iter71).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.maxMemoryPerNode) {
    xfer += oprot->writeFieldBegin("maxMemoryPerNode", ::apache::thrift::protocol::T_I32, 10);
    xfer += oprot->writeI32(this->maxMemoryPerNode);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(ComputeResourceDescription &a, ComputeResourceDescription &b) {
  using ::std::swap;
  swap(a.computeResourceId, b.computeResourceId);
  swap(a.hostName, b.hostName);
  swap(a.hostAliases, b.hostAliases);
  swap(a.ipAddresses, b.ipAddresses);
  swap(a.resourceDescription, b.resourceDescription);
  swap(a.batchQueues, b.batchQueues);
  swap(a.fileSystems, b.fileSystems);
  swap(a.jobSubmissionInterfaces, b.jobSubmissionInterfaces);
  swap(a.dataMovementInterfaces, b.dataMovementInterfaces);
  swap(a.maxMemoryPerNode, b.maxMemoryPerNode);
  swap(a.__isset, b.__isset);
}

}}}}} // namespace
