/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.activemq.broker.SslContext;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportServer;
import org.apache.activemq.transport.nio.NIOSSLTransportServer;
import org.apache.activemq.transport.stomp.StompNIOSSLTransport;
import org.apache.activemq.transport.stomp.StompNIOTransportFactory;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.apache.activemq.transport.tcp.TcpTransportServer;
import org.apache.activemq.wireformat.WireFormat;

public class StompNIOSSLTransportFactory
extends StompNIOTransportFactory {
    protected SSLContext context;

    @Override
    protected TcpTransportServer createTcpTransportServer(URI location, ServerSocketFactory serverSocketFactory) throws IOException, URISyntaxException {
        return new NIOSSLTransportServer(this.context, this, location, serverSocketFactory){

            @Override
            protected Transport createTransport(Socket socket, WireFormat format) throws IOException {
                StompNIOSSLTransport transport = new StompNIOSSLTransport(format, socket);
                if (StompNIOSSLTransportFactory.this.context != null) {
                    transport.setSslContext(StompNIOSSLTransportFactory.this.context);
                }
                transport.setNeedClientAuth(this.isNeedClientAuth());
                transport.setWantClientAuth(this.isWantClientAuth());
                return transport;
            }
        };
    }

    @Override
    protected TcpTransport createTcpTransport(WireFormat wf, SocketFactory socketFactory, URI location, URI localLocation) throws UnknownHostException, IOException {
        return new StompNIOSSLTransport(wf, socketFactory, location, localLocation);
    }

    @Override
    public TcpTransport createTransport(WireFormat wireFormat, Socket socket, SSLEngine engine, TcpTransport.InitBuffer initBuffer, ByteBuffer inputBuffer) throws IOException {
        return new StompNIOSSLTransport(wireFormat, socket, engine, initBuffer, inputBuffer);
    }

    @Override
    public TransportServer doBind(URI location) throws IOException {
        if (SslContext.getCurrentSslContext() != null) {
            try {
                this.context = SslContext.getCurrentSslContext().getSSLContext();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return super.doBind(location);
    }
}

