/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.cloud;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.cloud.ServiceDiscovery;
import org.apache.camel.cloud.ServiceDiscoveryFactory;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.cloud.ServiceCallConfiguration;
import org.apache.camel.model.cloud.ServiceCallDefinition;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="routing,cloud,service-discovery")
@XmlRootElement(name="serviceDiscoveryConfiguration")
@XmlAccessorType(value=XmlAccessType.FIELD)
@Configurer(extended=true)
@Deprecated(since="3.19.0")
public class ServiceCallServiceDiscoveryConfiguration
extends ServiceCallConfiguration
implements ServiceDiscoveryFactory {
    @XmlTransient
    private final ServiceCallDefinition parent;
    @XmlTransient
    private final String factoryKey;

    public ServiceCallServiceDiscoveryConfiguration() {
        this(null, null);
    }

    public ServiceCallServiceDiscoveryConfiguration(ServiceCallDefinition parent, String factoryKey) {
        this.parent = parent;
        this.factoryKey = factoryKey;
    }

    public ServiceCallDefinition end() {
        return Optional.ofNullable(this.parent).orElseThrow(() -> new IllegalStateException("Parent definition is not set"));
    }

    public ProcessorDefinition<?> endParent() {
        return Optional.ofNullable(this.parent).map(ProcessorDefinition::end).orElseThrow(() -> new IllegalStateException("Parent definition is not set"));
    }

    @Override
    public ServiceCallServiceDiscoveryConfiguration property(String key, String value) {
        return (ServiceCallServiceDiscoveryConfiguration)super.property(key, value);
    }

    public ServiceDiscovery newInstance(CamelContext camelContext) throws Exception {
        ServiceDiscovery answer;
        ObjectHelper.notNull((Object)this.factoryKey, (String)"ServiceDiscovery factoryKey");
        ServiceDiscoveryFactory factory = (ServiceDiscoveryFactory)CamelContextHelper.lookup((CamelContext)camelContext, (String)this.factoryKey, ServiceDiscoveryFactory.class);
        if (factory != null) {
            answer = (ServiceDiscovery)factory.newInstance(camelContext);
        } else {
            Class type;
            try {
                type = camelContext.getCamelContextExtension().getFactoryFinder("META-INF/services/org/apache/camel/cloud/").findClass(this.factoryKey).orElse(null);
            }
            catch (Exception e) {
                throw new NoFactoryAvailableException("META-INF/services/org/apache/camel/cloud/" + this.factoryKey, (Throwable)e);
            }
            if (type != null) {
                if (ServiceDiscoveryFactory.class.isAssignableFrom(type)) {
                    factory = (ServiceDiscoveryFactory)camelContext.getInjector().newInstance(type, false);
                } else {
                    throw new IllegalArgumentException("Resolving ServiceDiscovery: " + this.factoryKey + " detected type conflict: Not a ServiceDiscoveryFactory implementation. Found: " + type.getName());
                }
            }
            try {
                Map<String, Object> parameters = this.getConfiguredOptions(camelContext, this);
                parameters.replaceAll((k, v) -> {
                    if (v instanceof String) {
                        String str = (String)v;
                        try {
                            v = camelContext.resolvePropertyPlaceholders(str);
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException(String.format("Exception while resolving %s (%s)", k, v), e);
                        }
                    }
                    return v;
                });
                if (factory != null) {
                    Map<String, String> map = this.getPropertiesAsMap(camelContext);
                    if (map != null && !map.isEmpty()) {
                        parameters.put("properties", map);
                    }
                } else {
                    throw new IllegalStateException("factory is null");
                }
                this.postProcessFactoryParameters(camelContext, parameters);
                PropertyBindingSupport.build().bind(camelContext, (Object)factory, parameters);
                answer = (ServiceDiscovery)factory.newInstance(camelContext);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return answer;
    }
}

