/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.transformer;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Transformer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorTransformer
extends Transformer {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessorTransformer.class);
    private Processor processor;
    private String transformerString;

    public ProcessorTransformer(CamelContext context) {
        this.setCamelContext(context);
    }

    @Override
    public void transform(Message message, DataType from, DataType to) throws Exception {
        Message answer;
        Exchange exchange = message.getExchange();
        CamelContext context = exchange.getContext();
        if (from.isJavaType()) {
            Object input = message.getBody();
            Class<?> fromClass = context.getClassResolver().resolveClass(from.getName());
            if (!fromClass.isAssignableFrom(input.getClass())) {
                LOG.debug("Converting to '{}'", (Object)fromClass.getName());
                input = context.getTypeConverter().mandatoryConvertTo(fromClass, input);
                message.setBody(input);
            }
        }
        LOG.debug("Sending to transform processor '{}'", (Object)this.processor);
        DefaultExchange transformExchange = new DefaultExchange(exchange);
        transformExchange.setIn(message);
        transformExchange.setProperties(exchange.getProperties());
        this.processor.process(transformExchange);
        Message message2 = answer = transformExchange.hasOut() ? transformExchange.getOut() : transformExchange.getIn();
        if (to.isJavaType()) {
            Object answerBody = answer.getBody();
            Class<?> toClass = context.getClassResolver().resolveClass(to.getName());
            if (!toClass.isAssignableFrom(answerBody.getClass())) {
                LOG.debug("Converting to '{}'", (Object)toClass.getName());
                answerBody = context.getTypeConverter().mandatoryConvertTo(toClass, answerBody);
                answer.setBody(answerBody);
            }
        }
        message.copyFrom(answer);
    }

    public ProcessorTransformer setProcessor(Processor processor) {
        this.processor = processor;
        this.transformerString = null;
        return this;
    }

    @Override
    public String toString() {
        if (this.transformerString == null) {
            this.transformerString = String.format("ProcessorTransformer[scheme='%s', from='%s', to='%s', processor='%s']", this.getModel(), this.getFrom(), this.getTo(), this.processor);
        }
        return this.transformerString;
    }

    @Override
    protected void doStart() throws Exception {
        ObjectHelper.notNull(this.processor, "processor", this);
        ServiceHelper.startService(this.processor);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.processor);
    }
}

