/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.coordinator;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.Sets;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.Uninterruptibles;
import java.lang.reflect.InvocationTargetException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.accumulo.coordinator.CompactionFinalizer;
import org.apache.accumulo.coordinator.CoordinatorLockWatcher;
import org.apache.accumulo.coordinator.DeadCompactionDetector;
import org.apache.accumulo.coordinator.QueueSummaries;
import org.apache.accumulo.core.cli.ConfigOpts;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.clientImpl.thrift.TInfo;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.clientImpl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.compaction.thrift.CompactionCoordinatorService;
import org.apache.accumulo.core.compaction.thrift.TCompactionState;
import org.apache.accumulo.core.compaction.thrift.TCompactionStatusUpdate;
import org.apache.accumulo.core.compaction.thrift.TExternalCompaction;
import org.apache.accumulo.core.compaction.thrift.TExternalCompactionList;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.TKeyExtent;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.lock.ServiceLock;
import org.apache.accumulo.core.lock.ServiceLockData;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionId;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metrics.MetricsProducer;
import org.apache.accumulo.core.metrics.MetricsUtil;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.tabletserver.thrift.TCompactionStats;
import org.apache.accumulo.core.tabletserver.thrift.TExternalCompactionJob;
import org.apache.accumulo.core.tabletserver.thrift.TabletServerClientService;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.util.compaction.ExternalCompactionUtil;
import org.apache.accumulo.core.util.compaction.RunningCompaction;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.server.AbstractServer;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.manager.LiveTServerSet;
import org.apache.accumulo.server.rpc.ServerAddress;
import org.apache.accumulo.server.rpc.TServerUtils;
import org.apache.accumulo.server.rpc.ThriftProcessorTypes;
import org.apache.accumulo.server.security.SecurityOperation;
import org.apache.thrift.TException;
import org.apache.thrift.TMultiplexedProcessor;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionCoordinator
extends AbstractServer
implements CompactionCoordinatorService.Iface,
LiveTServerSet.Listener {
    private static final Logger LOG = LoggerFactory.getLogger(CompactionCoordinator.class);
    private static final long FIFTEEN_MINUTES = TimeUnit.MINUTES.toMillis(15L);
    protected static final QueueSummaries QUEUE_SUMMARIES = new QueueSummaries();
    protected static final Map<ExternalCompactionId, RunningCompaction> RUNNING_CACHE = new ConcurrentHashMap<ExternalCompactionId, RunningCompaction>();
    private static final Cache<ExternalCompactionId, RunningCompaction> COMPLETED = Caffeine.newBuilder().maximumSize(200L).expireAfterWrite(10L, TimeUnit.MINUTES).build();
    private static final Map<String, Long> TIME_COMPACTOR_LAST_CHECKED = new ConcurrentHashMap<String, Long>();
    protected SecurityOperation security;
    protected final AccumuloConfiguration aconf;
    protected CompactionFinalizer compactionFinalizer;
    protected LiveTServerSet tserverSet;
    private ServiceLock coordinatorLock;
    protected volatile Boolean shutdown = false;
    private final ScheduledThreadPoolExecutor schedExecutor;
    private final ExecutorService summariesExecutor;

    protected CompactionCoordinator(ConfigOpts opts, String[] args) {
        this(opts, args, null);
    }

    protected CompactionCoordinator(ConfigOpts opts, String[] args, AccumuloConfiguration conf) {
        super("compaction-coordinator", opts, args);
        this.aconf = conf == null ? super.getConfiguration() : conf;
        this.schedExecutor = ThreadPools.getServerThreadPools().createGeneralScheduledExecutorService(this.aconf);
        this.summariesExecutor = ThreadPools.getServerThreadPools().createFixedThreadPool(10, "Compaction Summary Gatherer", false);
        this.compactionFinalizer = this.createCompactionFinalizer(this.schedExecutor);
        this.tserverSet = this.createLiveTServerSet();
        this.setupSecurity();
        this.printStartupMsg();
        this.startCompactionCleaner(this.schedExecutor);
        this.startRunningCleaner(this.schedExecutor);
    }

    public AccumuloConfiguration getConfiguration() {
        return this.aconf;
    }

    protected CompactionFinalizer createCompactionFinalizer(ScheduledThreadPoolExecutor schedExecutor) {
        return new CompactionFinalizer(this.getContext(), schedExecutor);
    }

    protected LiveTServerSet createLiveTServerSet() {
        return new LiveTServerSet(this.getContext(), (LiveTServerSet.Listener)this);
    }

    protected void setupSecurity() {
        this.security = this.getContext().getSecurityOperation();
    }

    protected void startCompactionCleaner(ScheduledThreadPoolExecutor schedExecutor) {
        ScheduledFuture<?> future = schedExecutor.scheduleWithFixedDelay(this::cleanUpCompactors, 0L, 5L, TimeUnit.MINUTES);
        ThreadPools.watchNonCriticalScheduledTask(future);
    }

    protected void startRunningCleaner(ScheduledThreadPoolExecutor schedExecutor) {
        ScheduledFuture<?> future = schedExecutor.scheduleWithFixedDelay(this::cleanUpRunning, 0L, 5L, TimeUnit.MINUTES);
        ThreadPools.watchNonCriticalScheduledTask(future);
    }

    protected void printStartupMsg() {
        LOG.info("Version 3.0.0");
        LOG.info("Instance " + this.getContext().getInstanceID());
    }

    protected void getCoordinatorLock(HostAndPort clientAddress) throws KeeperException, InterruptedException {
        LOG.info("trying to get coordinator lock");
        String coordinatorClientAddress = ExternalCompactionUtil.getHostPortString((HostAndPort)clientAddress);
        String lockPath = this.getContext().getZooKeeperRoot() + "/coordinators/lock";
        UUID zooLockUUID = UUID.randomUUID();
        while (true) {
            CoordinatorLockWatcher coordinatorLockWatcher = new CoordinatorLockWatcher();
            this.coordinatorLock = new ServiceLock(this.getContext().getZooReaderWriter().getZooKeeper(), ServiceLock.path((String)lockPath), zooLockUUID);
            this.coordinatorLock.lock((ServiceLock.AccumuloLockWatcher)coordinatorLockWatcher, new ServiceLockData(zooLockUUID, coordinatorClientAddress, ServiceLockData.ThriftService.COORDINATOR));
            coordinatorLockWatcher.waitForChange();
            if (coordinatorLockWatcher.isAcquiredLock()) break;
            if (!coordinatorLockWatcher.isFailedToAcquireLock()) {
                throw new IllegalStateException("manager lock in unknown state");
            }
            this.coordinatorLock.tryToCancelAsyncLockOrUnlock();
            Uninterruptibles.sleepUninterruptibly((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    protected ServerAddress startCoordinatorClientService() throws UnknownHostException {
        TMultiplexedProcessor processor = ThriftProcessorTypes.getCoordinatorTProcessor((CompactionCoordinatorService.Iface)this, (ServerContext)this.getContext());
        Property maxMessageSizeProperty = this.getConfiguration().get(Property.COMPACTION_COORDINATOR_MAX_MESSAGE_SIZE) != null ? Property.COMPACTION_COORDINATOR_MAX_MESSAGE_SIZE : Property.GENERAL_MAX_MESSAGE_SIZE;
        ServerAddress sp = TServerUtils.startServer((ServerContext)this.getContext(), (String)this.getHostname(), (Property)Property.COMPACTION_COORDINATOR_CLIENTPORT, (TProcessor)processor, (String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Thrift Client Server", (Property)Property.COMPACTION_COORDINATOR_THRIFTCLIENT_PORTSEARCH, (Property)Property.COMPACTION_COORDINATOR_MINTHREADS, (Property)Property.COMPACTION_COORDINATOR_MINTHREADS_TIMEOUT, (Property)Property.COMPACTION_COORDINATOR_THREADCHECK, (Property)maxMessageSizeProperty);
        LOG.info("address = {}", (Object)sp.address);
        return sp;
    }

    public void run() {
        ServerAddress coordinatorAddress = null;
        try {
            coordinatorAddress = this.startCoordinatorClientService();
        }
        catch (UnknownHostException e1) {
            throw new IllegalStateException("Failed to start the coordinator service", e1);
        }
        HostAndPort clientAddress = coordinatorAddress.address;
        try {
            this.getCoordinatorLock(clientAddress);
        }
        catch (InterruptedException | KeeperException e) {
            throw new IllegalStateException("Exception getting Coordinator lock", e);
        }
        try {
            MetricsUtil.initializeMetrics((AccumuloConfiguration)this.getContext().getConfiguration(), (String)this.applicationName, (HostAndPort)clientAddress);
            MetricsUtil.initializeProducers((MetricsProducer[])new MetricsProducer[]{this});
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
            LOG.error("Error initializing metrics, metrics will not be emitted.", (Throwable)e1);
        }
        LOG.info("Checking for running external compactions");
        List running = ExternalCompactionUtil.getCompactionsRunningOnCompactors((ClientContext)this.getContext());
        if (running.isEmpty()) {
            LOG.info("No running external compactions found");
        } else {
            LOG.info("Found {} running external compactions", (Object)running.size());
            running.forEach(rc -> {
                TCompactionStatusUpdate update = new TCompactionStatusUpdate();
                update.setState(TCompactionState.IN_PROGRESS);
                update.setMessage("Coordinator restarted, compaction found in progress");
                rc.addUpdate(Long.valueOf(System.currentTimeMillis()), update);
                RUNNING_CACHE.put(ExternalCompactionId.of((String)rc.getJob().getExternalCompactionId()), (RunningCompaction)rc);
            });
        }
        this.tserverSet.startListeningForTabletServerChanges();
        this.startDeadCompactionDetector();
        LOG.info("Starting loop to check tservers for compaction summaries");
        while (!this.shutdown.booleanValue()) {
            long duration;
            long start = System.currentTimeMillis();
            this.updateSummaries();
            long now = System.currentTimeMillis();
            TIME_COMPACTOR_LAST_CHECKED.forEach((k, v) -> {
                if (now - v > this.getMissingCompactorWarningTime()) {
                    LOG.warn("No compactors have checked in with coordinator for queue {} in {}ms", k, (Object)this.getMissingCompactorWarningTime());
                }
            });
            long checkInterval = this.getTServerCheckInterval();
            if (checkInterval - (duration = System.currentTimeMillis() - start) <= 0L) continue;
            LOG.debug("Waiting {}ms for next tserver check", (Object)(checkInterval - duration));
            UtilWaitThread.sleep((long)(checkInterval - duration));
        }
        this.summariesExecutor.shutdownNow();
        LOG.info("Shutting down");
    }

    private void updateSummaries() {
        ArrayList tasks = new ArrayList();
        ConcurrentSkipListSet queuesSeen = new ConcurrentSkipListSet();
        this.tserverSet.getCurrentServers().forEach(tsi -> tasks.add(this.summariesExecutor.submit(() -> this.updateSummaries((TServerInstance)tsi, queuesSeen))));
        while (!tasks.isEmpty()) {
            Iterator iter = tasks.iterator();
            while (iter.hasNext()) {
                Future f = (Future)iter.next();
                if (!f.isDone()) continue;
                iter.remove();
            }
            Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        TIME_COMPACTOR_LAST_CHECKED.keySet().retainAll(queuesSeen);
        queuesSeen.forEach(q -> TIME_COMPACTOR_LAST_CHECKED.computeIfAbsent((String)q, k -> System.currentTimeMillis()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSummaries(TServerInstance tsi, Set<String> queuesSeen) {
        try {
            TabletServerClientService.Client client = null;
            try {
                LOG.debug("Contacting tablet server {} to get external compaction summaries", (Object)tsi.getHostPort());
                client = this.getTabletServerConnection(tsi);
                List summaries = client.getCompactionQueueInfo(TraceUtil.traceInfo(), this.getContext().rpcCreds());
                QUEUE_SUMMARIES.update(tsi, summaries);
                summaries.forEach(summary -> queuesSeen.add(summary.getQueue()));
            }
            catch (Throwable throwable) {
                ThriftUtil.returnClient(client, (ClientContext)this.getContext());
                throw throwable;
            }
            ThriftUtil.returnClient((TServiceClient)client, (ClientContext)this.getContext());
        }
        catch (TException e) {
            LOG.warn("Error getting external compaction summaries from tablet server: {}", (Object)tsi.getHostAndPort(), (Object)e);
            QUEUE_SUMMARIES.remove(Set.of(tsi));
        }
    }

    protected void startDeadCompactionDetector() {
        new DeadCompactionDetector(this.getContext(), this, this.schedExecutor).start();
    }

    protected long getMissingCompactorWarningTime() {
        return FIFTEEN_MINUTES;
    }

    protected long getTServerCheckInterval() {
        return this.getConfiguration().getTimeInMillis(Property.COMPACTION_COORDINATOR_TSERVER_COMPACTION_CHECK_INTERVAL);
    }

    public void update(LiveTServerSet current, Set<TServerInstance> deleted, Set<TServerInstance> added) {
        QUEUE_SUMMARIES.remove(deleted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TExternalCompactionJob getCompactionJob(TInfo tinfo, TCredentials credentials, String queueName, String compactorAddress, String externalCompactionId) throws ThriftSecurityException {
        if (!this.security.canPerformSystemActions(credentials)) {
            throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED).asThriftException();
        }
        String queue = queueName.intern();
        LOG.trace("getCompactionJob called for queue {} by compactor {}", (Object)queue, (Object)compactorAddress);
        TIME_COMPACTOR_LAST_CHECKED.put(queue, System.currentTimeMillis());
        TExternalCompactionJob result = null;
        QueueSummaries.PrioTserver prioTserver = QUEUE_SUMMARIES.getNextTserver(queue);
        while (prioTserver != null) {
            TServerInstance tserver = prioTserver.tserver;
            LOG.trace("Getting compaction for queue {} from tserver {}", (Object)queue, (Object)tserver.getHostAndPort());
            TabletServerClientService.Client client = null;
            try {
                client = this.getTabletServerConnection(tserver);
                TExternalCompactionJob job = client.reserveCompactionJob(TraceUtil.traceInfo(), this.getContext().rpcCreds(), queue, (long)prioTserver.prio, compactorAddress, externalCompactionId);
                if (null == job.getExternalCompactionId()) {
                    LOG.trace("No compactions found for queue {} on tserver {}, trying next tserver", (Object)queue, (Object)tserver.getHostAndPort());
                    QUEUE_SUMMARIES.removeSummary(tserver, queue, prioTserver.prio);
                    prioTserver = QUEUE_SUMMARIES.getNextTserver(queue);
                    continue;
                }
                RUNNING_CACHE.put(ExternalCompactionId.of((String)job.getExternalCompactionId()), new RunningCompaction(job, compactorAddress, queue));
                LOG.debug("Returning external job {} to {}", (Object)job.externalCompactionId, (Object)compactorAddress);
                result = job;
                break;
            }
            catch (TException e) {
                LOG.warn("Error from tserver {} while trying to reserve compaction, trying next tserver", (Object)ExternalCompactionUtil.getHostPortString((HostAndPort)tserver.getHostAndPort()), (Object)e);
                QUEUE_SUMMARIES.removeSummary(tserver, queue, prioTserver.prio);
                prioTserver = QUEUE_SUMMARIES.getNextTserver(queue);
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)client, (ClientContext)this.getContext());
            }
        }
        if (result == null) {
            LOG.trace("No tservers found for queue {}, returning empty job to compactor {}", (Object)queue, (Object)compactorAddress);
            result = new TExternalCompactionJob();
        }
        return result;
    }

    protected TabletServerClientService.Client getTabletServerConnection(TServerInstance tserver) throws TTransportException {
        LiveTServerSet.TServerConnection connection = this.tserverSet.getConnection(tserver);
        ServerContext serverContext = this.getContext();
        TTransport transport = serverContext.getTransportPool().getTransport(connection.getAddress(), 0L, (ClientContext)serverContext);
        return (TabletServerClientService.Client)ThriftUtil.createClient((ThriftClientTypes)ThriftClientTypes.TABLET_SERVER, (TTransport)transport);
    }

    public void compactionCompleted(TInfo tinfo, TCredentials credentials, String externalCompactionId, TKeyExtent textent, TCompactionStats stats) throws ThriftSecurityException {
        if (!this.security.canPerformSystemActions(credentials)) {
            throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED).asThriftException();
        }
        KeyExtent extent = KeyExtent.fromThrift((TKeyExtent)textent);
        LOG.info("Compaction completed, id: {}, stats: {}, extent: {}", new Object[]{externalCompactionId, stats, extent});
        ExternalCompactionId ecid = ExternalCompactionId.of((String)externalCompactionId);
        this.compactionFinalizer.commitCompaction(ecid, extent, stats.fileSize, stats.entriesWritten);
        this.recordCompletion(ecid);
    }

    public void compactionFailed(TInfo tinfo, TCredentials credentials, String externalCompactionId, TKeyExtent extent) throws ThriftSecurityException {
        if (!this.security.canPerformSystemActions(credentials)) {
            throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED).asThriftException();
        }
        LOG.info("Compaction failed, id: {}", (Object)externalCompactionId);
        ExternalCompactionId ecid = ExternalCompactionId.of((String)externalCompactionId);
        this.compactionFailed(Map.of(ecid, KeyExtent.fromThrift((TKeyExtent)extent)));
    }

    void compactionFailed(Map<ExternalCompactionId, KeyExtent> compactions) {
        this.compactionFinalizer.failCompactions(compactions);
        compactions.forEach((k, v) -> this.recordCompletion((ExternalCompactionId)k));
    }

    public void updateCompactionStatus(TInfo tinfo, TCredentials credentials, String externalCompactionId, TCompactionStatusUpdate update, long timestamp) throws ThriftSecurityException {
        if (!this.security.canPerformSystemActions(credentials)) {
            throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED).asThriftException();
        }
        LOG.debug("Compaction status update, id: {}, timestamp: {}, update: {}", new Object[]{externalCompactionId, timestamp, update});
        RunningCompaction rc = RUNNING_CACHE.get(ExternalCompactionId.of((String)externalCompactionId));
        if (null != rc) {
            rc.addUpdate(Long.valueOf(timestamp), update);
        }
    }

    private void recordCompletion(ExternalCompactionId ecid) {
        RunningCompaction rc = RUNNING_CACHE.remove(ecid);
        if (rc != null) {
            COMPLETED.put((Object)ecid, (Object)rc);
        }
    }

    protected Set<ExternalCompactionId> readExternalCompactionIds() {
        return this.getContext().getAmple().readTablets().forLevel(Ample.DataLevel.USER).fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.ECOMP}).build().stream().flatMap(tm -> tm.getExternalCompactions().keySet().stream()).collect(Collectors.toSet());
    }

    protected void cleanUpRunning() {
        Set<ExternalCompactionId> idsSnapshot = Set.copyOf(RUNNING_CACHE.keySet());
        Set<ExternalCompactionId> idsInMetadata = this.readExternalCompactionIds();
        Sets.SetView idsToRemove = Sets.difference(idsSnapshot, idsInMetadata);
        idsToRemove.forEach(ecid -> this.recordCompletion((ExternalCompactionId)ecid));
        if (idsToRemove.size() > 0) {
            LOG.debug("Removed stale entries from RUNNING_CACHE : {}", (Object)idsToRemove);
        }
    }

    public TExternalCompactionList getRunningCompactions(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException {
        if (!this.security.canPerformSystemActions(credentials)) {
            throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED).asThriftException();
        }
        TExternalCompactionList result = new TExternalCompactionList();
        RUNNING_CACHE.forEach((ecid, rc) -> {
            TExternalCompaction trc = new TExternalCompaction();
            trc.setQueueName(rc.getQueueName());
            trc.setCompactor(rc.getCompactorAddress());
            trc.setUpdates(rc.getUpdates());
            trc.setJob(rc.getJob());
            result.putToCompactions(ecid.canonical(), trc);
        });
        return result;
    }

    public TExternalCompactionList getCompletedCompactions(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException {
        if (!this.security.canPerformSystemActions(credentials)) {
            throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED).asThriftException();
        }
        TExternalCompactionList result = new TExternalCompactionList();
        COMPLETED.asMap().forEach((ecid, rc) -> {
            TExternalCompaction trc = new TExternalCompaction();
            trc.setQueueName(rc.getQueueName());
            trc.setCompactor(rc.getCompactorAddress());
            trc.setJob(rc.getJob());
            trc.setUpdates(rc.getUpdates());
            result.putToCompactions(ecid.canonical(), trc);
        });
        return result;
    }

    public void cancel(TInfo tinfo, TCredentials credentials, String externalCompactionId) throws TException {
        RunningCompaction runningCompaction = RUNNING_CACHE.get(ExternalCompactionId.of((String)externalCompactionId));
        KeyExtent extent = KeyExtent.fromThrift((TKeyExtent)runningCompaction.getJob().getExtent());
        try {
            NamespaceId nsId = this.getContext().getNamespaceId(extent.tableId());
            if (!this.security.canCompact(credentials, extent.tableId(), nsId)) {
                throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED).asThriftException();
            }
        }
        catch (TableNotFoundException e) {
            throw new ThriftTableOperationException(extent.tableId().canonical(), null, TableOperation.COMPACT_CANCEL, TableOperationExceptionType.NOTFOUND, e.getMessage());
        }
        HostAndPort address = HostAndPort.fromString((String)runningCompaction.getCompactorAddress());
        ExternalCompactionUtil.cancelCompaction((ClientContext)this.getContext(), (HostAndPort)address, (String)externalCompactionId);
    }

    private void deleteEmpty(ZooReaderWriter zoorw, String path) throws KeeperException, InterruptedException {
        try {
            LOG.debug("Deleting empty ZK node {}", (Object)path);
            zoorw.delete(path);
        }
        catch (KeeperException.NotEmptyException e) {
            LOG.debug("Failed to delete {} its not empty, likely an expected race condition.", (Object)path);
        }
    }

    private void cleanUpCompactors() {
        String compactorQueuesPath = this.getContext().getZooKeeperRoot() + "/compactors";
        ZooReaderWriter zoorw = this.getContext().getZooReaderWriter();
        try {
            List queues = zoorw.getChildren(compactorQueuesPath);
            for (String queue : queues) {
                String qpath = compactorQueuesPath + "/" + queue;
                List compactors = zoorw.getChildren(qpath);
                if (compactors.isEmpty()) {
                    this.deleteEmpty(zoorw, qpath);
                }
                for (String compactor : compactors) {
                    String cpath = compactorQueuesPath + "/" + queue + "/" + compactor;
                    List lockNodes = zoorw.getChildren(compactorQueuesPath + "/" + queue + "/" + compactor);
                    if (!lockNodes.isEmpty()) continue;
                    this.deleteEmpty(zoorw, cpath);
                }
            }
        }
        catch (RuntimeException | KeeperException e) {
            LOG.warn("Failed to clean up compactors", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        try (CompactionCoordinator compactor = new CompactionCoordinator(new ConfigOpts(), args);){
            compactor.runServer();
        }
    }
}

