/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.rest.tservers;

import com.google.common.net.HostAndPort;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.TKeyExtent;
import org.apache.accumulo.core.manager.thrift.ManagerMonitorInfo;
import org.apache.accumulo.core.manager.thrift.RecoveryStatus;
import org.apache.accumulo.core.manager.thrift.TabletServerStatus;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.tabletserver.thrift.ActionStats;
import org.apache.accumulo.core.tabletserver.thrift.TabletServerClientService;
import org.apache.accumulo.core.tabletserver.thrift.TabletStats;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.AddressUtil;
import org.apache.accumulo.monitor.Monitor;
import org.apache.accumulo.monitor.rest.manager.ManagerResource;
import org.apache.accumulo.monitor.rest.tservers.AllTimeTabletResults;
import org.apache.accumulo.monitor.rest.tservers.CurrentOperations;
import org.apache.accumulo.monitor.rest.tservers.CurrentTabletResults;
import org.apache.accumulo.monitor.rest.tservers.ServerStat;
import org.apache.accumulo.monitor.rest.tservers.ServerStats;
import org.apache.accumulo.monitor.rest.tservers.TabletServer;
import org.apache.accumulo.monitor.rest.tservers.TabletServerDetailInformation;
import org.apache.accumulo.monitor.rest.tservers.TabletServerRecoveryInformation;
import org.apache.accumulo.monitor.rest.tservers.TabletServerSummary;
import org.apache.accumulo.monitor.rest.tservers.TabletServers;
import org.apache.accumulo.monitor.rest.tservers.TabletServersRecovery;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.manager.state.DeadServerList;
import org.apache.accumulo.server.util.ActionStatsUpdator;
import org.apache.thrift.TServiceClient;

@Path(value="/tservers")
@Produces(value={"application/json", "application/xml"})
public class TabletServerResource {
    @Inject
    private Monitor monitor;
    private TabletStats total;
    private TabletStats historical;

    @GET
    public TabletServers getTserverSummary() {
        ManagerMonitorInfo mmi = this.monitor.getMmi();
        if (mmi == null) {
            return new TabletServers();
        }
        TabletServers tserverInfo = new TabletServers(mmi.tServerInfo.size());
        for (TabletServerStatus status : mmi.tServerInfo) {
            tserverInfo.addTablet(new TabletServer(this.monitor, status));
        }
        tserverInfo.addBadTabletServer(ManagerResource.getTables(this.monitor));
        return tserverInfo;
    }

    @POST
    @Consumes(value={"text/plain"})
    public void clearDeadServer(@QueryParam(value="server") @NotNull @Pattern(regexp="[a-zA-Z0-9.-]+:[0-9]{2,5}") @NotNull @Pattern(regexp="[a-zA-Z0-9.-]+:[0-9]{2,5}") String server) {
        DeadServerList obit = new DeadServerList(this.monitor.getContext());
        obit.delete(server);
    }

    @Path(value="recovery")
    @GET
    public TabletServersRecovery getTserverRecovery() {
        TabletServersRecovery recoveryList = new TabletServersRecovery();
        ManagerMonitorInfo mmi = this.monitor.getMmi();
        if (mmi == null) {
            return new TabletServersRecovery();
        }
        for (TabletServerStatus server : mmi.tServerInfo) {
            if (server.logSorts == null) continue;
            for (RecoveryStatus recovery : server.logSorts) {
                String serv = AddressUtil.parseAddress((String)server.name, (boolean)false).getHost();
                String log = recovery.name;
                int time = recovery.runtime;
                double progress = recovery.progress;
                recoveryList.addRecovery(new TabletServerRecoveryInformation(serv, log, time, progress));
            }
        }
        return recoveryList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="{address}")
    @GET
    public TabletServerSummary getTserverDetails(@PathParam(value="address") @NotNull @Pattern(regexp="[a-zA-Z0-9.-]+:[0-9]{2,5}") @NotNull @Pattern(regexp="[a-zA-Z0-9.-]+:[0-9]{2,5}") String tserverAddress) throws Exception {
        ManagerMonitorInfo mmi = this.monitor.getMmi();
        if (mmi == null) {
            return new TabletServerSummary();
        }
        boolean tserverExists = false;
        for (TabletServerStatus ts : mmi.getTServerInfo()) {
            if (!tserverAddress.equals(ts.getName())) continue;
            tserverExists = true;
            break;
        }
        if (!tserverExists) {
            return null;
        }
        double splitStdDev = 0.0;
        double minorStdDev = 0.0;
        double minorQueueStdDev = 0.0;
        double majorStdDev = 0.0;
        double majorQueueStdDev = 0.0;
        double currentMinorAvg = 0.0;
        double currentMajorAvg = 0.0;
        double currentMinorStdDev = 0.0;
        double currentMajorStdDev = 0.0;
        this.total = new TabletStats(null, new ActionStats(), new ActionStats(), new ActionStats(), 0L, 0.0, 0.0, 0L);
        HostAndPort address = HostAndPort.fromString((String)tserverAddress);
        this.historical = new TabletStats(null, new ActionStats(), new ActionStats(), new ActionStats(), 0L, 0.0, 0.0, 0L);
        ArrayList<TabletStats> tsStats = new ArrayList<TabletStats>();
        try {
            ServerContext context = this.monitor.getContext();
            TabletServerClientService.Client client = (TabletServerClientService.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.TABLET_SERVER, (HostAndPort)address, (ClientContext)context);
            try {
                for (String tableId : mmi.tableMap.keySet()) {
                    tsStats.addAll(client.getTabletStats(TraceUtil.traceInfo(), context.rpcCreds(), tableId));
                }
                this.historical = client.getHistoricalStats(TraceUtil.traceInfo(), context.rpcCreds());
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)client, (ClientContext)context);
            }
        }
        catch (Exception e) {
            return null;
        }
        List<CurrentOperations> currentOps = this.doCurrentOperations(tsStats);
        if (this.total.minors.num != 0) {
            currentMinorAvg = (long)(this.total.minors.elapsed / (double)this.total.minors.num);
        }
        if (this.total.minors.elapsed != 0.0 && this.total.minors.num != 0) {
            currentMinorStdDev = TabletServerResource.stddev(this.total.minors.elapsed, this.total.minors.num, this.total.minors.sumDev);
        }
        if (this.total.majors.num != 0) {
            currentMajorAvg = this.total.majors.elapsed / (double)this.total.majors.num;
        }
        if (this.total.majors.elapsed != 0.0 && this.total.majors.num != 0 && this.total.majors.elapsed > (double)this.total.majors.num) {
            currentMajorStdDev = TabletServerResource.stddev(this.total.majors.elapsed, this.total.majors.num, this.total.majors.sumDev);
        }
        ActionStatsUpdator.update((ActionStats)this.total.minors, (ActionStats)this.historical.minors);
        ActionStatsUpdator.update((ActionStats)this.total.majors, (ActionStats)this.historical.majors);
        minorStdDev = TabletServerResource.stddev(this.total.minors.elapsed, this.total.minors.num, this.total.minors.sumDev);
        minorQueueStdDev = TabletServerResource.stddev(this.total.minors.queueTime, this.total.minors.num, this.total.minors.queueSumDev);
        majorStdDev = TabletServerResource.stddev(this.total.majors.elapsed, this.total.majors.num, this.total.majors.sumDev);
        majorQueueStdDev = TabletServerResource.stddev(this.total.majors.queueTime, this.total.majors.num, this.total.majors.queueSumDev);
        splitStdDev = TabletServerResource.stddev(this.historical.splits.elapsed, this.historical.splits.num, this.historical.splits.sumDev);
        TabletServerDetailInformation details = this.doDetails(tsStats.size());
        List<AllTimeTabletResults> allTime = this.doAllTimeResults(majorQueueStdDev, minorQueueStdDev, splitStdDev, majorStdDev, minorStdDev);
        CurrentTabletResults currentRes = this.doCurrentTabletResults(currentMinorAvg, currentMinorStdDev, currentMajorAvg, currentMajorStdDev);
        return new TabletServerSummary(details, allTime, currentRes, currentOps);
    }

    @Path(value="serverStats")
    @GET
    public ServerStats getServerStats() {
        int concurrentScans = this.monitor.getContext().getConfiguration().getScanExecutors(false).stream().mapToInt(sec -> sec.maxThreads).sum();
        ServerStats stats = new ServerStats();
        stats.addStats(new ServerStat(ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors(), true, 100.0f, "OS Load", "osload"));
        stats.addStats(new ServerStat(1000, true, 1.0f, "Ingest Entries", "ingest"));
        stats.addStats(new ServerStat(10000, true, 1.0f, "Scan Entries", "query"));
        stats.addStats(new ServerStat(10, true, 10.0f, "Ingest MB", "ingestMB"));
        stats.addStats(new ServerStat(5, true, 10.0f, "Scan MB", "queryMB"));
        stats.addStats(new ServerStat(concurrentScans * 2, false, 1.0f, "Running Scans", "scans"));
        stats.addStats(new ServerStat(50, true, 10.0f, "Scan Sessions", "scansessions"));
        stats.addStats(new ServerStat(60000, false, 1.0f, "Hold Time", "holdtime"));
        stats.addStats(new ServerStat(1, false, 100.0f, "Overall Avg", true, "allavg"));
        stats.addStats(new ServerStat(1, false, 100.0f, "Overall Max", true, "allmax"));
        return stats;
    }

    private TabletServerDetailInformation doDetails(int numTablets) {
        return new TabletServerDetailInformation(numTablets, this.total.numEntries, this.total.minors.status, this.total.majors.status, this.historical.splits.status);
    }

    private List<AllTimeTabletResults> doAllTimeResults(double majorQueueStdDev, double minorQueueStdDev, double splitStdDev, double majorStdDev, double minorStdDev) {
        ArrayList<AllTimeTabletResults> allTime = new ArrayList<AllTimeTabletResults>();
        allTime.add(new AllTimeTabletResults("Minor&nbsp;Compaction", this.total.minors.num, this.total.minors.fail, this.total.minors.num != 0 ? Double.valueOf(this.total.minors.queueTime / (double)this.total.minors.num) : null, minorQueueStdDev, this.total.minors.num != 0 ? Double.valueOf(this.total.minors.elapsed / (double)this.total.minors.num) : null, minorStdDev, this.total.minors.elapsed));
        allTime.add(new AllTimeTabletResults("Major&nbsp;Compaction", this.total.majors.num, this.total.majors.fail, this.total.majors.num != 0 ? Double.valueOf(this.total.majors.queueTime / (double)this.total.majors.num) : null, majorQueueStdDev, this.total.majors.num != 0 ? Double.valueOf(this.total.majors.elapsed / (double)this.total.majors.num) : null, majorStdDev, this.total.majors.elapsed));
        allTime.add(new AllTimeTabletResults("Split", this.historical.splits.num, this.historical.splits.fail, null, null, this.historical.splits.num != 0 ? Double.valueOf(this.historical.splits.elapsed / (double)this.historical.splits.num) : null, splitStdDev, this.historical.splits.elapsed));
        return allTime;
    }

    private CurrentTabletResults doCurrentTabletResults(double currentMinorAvg, double currentMinorStdDev, double currentMajorAvg, double currentMajorStdDev) {
        return new CurrentTabletResults(currentMinorAvg, currentMinorStdDev, currentMajorAvg, currentMajorStdDev);
    }

    private List<CurrentOperations> doCurrentOperations(List<TabletStats> tsStats) throws Exception {
        ArrayList<CurrentOperations> currentOperations = new ArrayList<CurrentOperations>();
        for (TabletStats info : tsStats) {
            if (info.extent == null) {
                this.historical = info;
                continue;
            }
            this.total.numEntries += info.numEntries;
            ActionStatsUpdator.update((ActionStats)this.total.minors, (ActionStats)info.minors);
            ActionStatsUpdator.update((ActionStats)this.total.majors, (ActionStats)info.majors);
            KeyExtent extent = KeyExtent.fromThrift((TKeyExtent)info.extent);
            TableId tableId = extent.tableId();
            String displayExtent = String.format("[%s]", extent.obscured());
            String tableName = this.monitor.getContext().getPrintableTableInfoFromId(tableId);
            currentOperations.add(new CurrentOperations(tableName, tableId, displayExtent, info.numEntries, info.ingestRate, info.queryRate, info.minors.num != 0 ? Double.valueOf(info.minors.elapsed / (double)info.minors.num) : null, TabletServerResource.stddev(info.minors.elapsed, info.minors.num, info.minors.sumDev), info.minors.elapsed != 0.0 ? Double.valueOf((double)info.minors.count / info.minors.elapsed) : null, info.majors.num != 0 ? Double.valueOf(info.majors.elapsed / (double)info.majors.num) : null, TabletServerResource.stddev(info.majors.elapsed, info.majors.num, info.majors.sumDev), info.majors.elapsed != 0.0 ? Double.valueOf((double)info.majors.count / info.majors.elapsed) : null));
        }
        return currentOperations;
    }

    private static double stddev(double elapsed, double num, double sumDev) {
        if (num != 0.0) {
            double average = elapsed / num;
            return Math.sqrt(sumDev / num - average * average);
        }
        return 0.0;
    }
}

