/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata.schema;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.net.HostAndPort;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.SortedMap;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;
import org.apache.accumulo.core.lock.ServiceLock;
import org.apache.accumulo.core.lock.ServiceLockData;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.SuspendingTServer;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.TabletLocationState;
import org.apache.accumulo.core.metadata.TabletState;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionId;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionMetadata;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.metadata.schema.MetadataTime;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabletMetadata {
    private static final Logger log = LoggerFactory.getLogger(TabletMetadata.class);
    private TableId tableId;
    private Text prevEndRow;
    private boolean sawPrevEndRow = false;
    private Text oldPrevEndRow;
    private boolean sawOldPrevEndRow = false;
    private Text endRow;
    private Location location;
    private Map<StoredTabletFile, DataFileValue> files;
    private List<StoredTabletFile> scans;
    private Map<StoredTabletFile, Long> loadedFiles;
    private EnumSet<ColumnType> fetchedCols;
    private KeyExtent extent;
    private Location last;
    private SuspendingTServer suspend;
    private String dirName;
    private MetadataTime time;
    private String cloned;
    private SortedMap<Key, Value> keyValues;
    private OptionalLong flush = OptionalLong.empty();
    private List<LogEntry> logs;
    private OptionalLong compact = OptionalLong.empty();
    private Double splitRatio = null;
    private Map<ExternalCompactionId, ExternalCompactionMetadata> extCompactions;
    private boolean chopped = false;

    public TableId getTableId() {
        return this.tableId;
    }

    public KeyExtent getExtent() {
        if (this.extent == null) {
            this.extent = new KeyExtent(this.getTableId(), this.getEndRow(), this.getPrevEndRow());
        }
        return this.extent;
    }

    private void ensureFetched(ColumnType col) {
        Preconditions.checkState((boolean)this.fetchedCols.contains((Object)col), (String)"%s was not fetched", (Object)((Object)col));
    }

    public Text getPrevEndRow() {
        this.ensureFetched(ColumnType.PREV_ROW);
        if (!this.sawPrevEndRow) {
            throw new IllegalStateException("No prev endrow seen.  tableId: " + this.tableId + " endrow: " + this.endRow);
        }
        return this.prevEndRow;
    }

    public boolean sawPrevEndRow() {
        this.ensureFetched(ColumnType.PREV_ROW);
        return this.sawPrevEndRow;
    }

    public Text getOldPrevEndRow() {
        this.ensureFetched(ColumnType.OLD_PREV_ROW);
        if (!this.sawOldPrevEndRow) {
            throw new IllegalStateException("No old prev endrow seen.  tableId: " + this.tableId + " endrow: " + this.endRow);
        }
        return this.oldPrevEndRow;
    }

    public boolean sawOldPrevEndRow() {
        this.ensureFetched(ColumnType.OLD_PREV_ROW);
        return this.sawOldPrevEndRow;
    }

    public Text getEndRow() {
        return this.endRow;
    }

    public Location getLocation() {
        this.ensureFetched(ColumnType.LOCATION);
        return this.location;
    }

    public boolean hasCurrent() {
        this.ensureFetched(ColumnType.LOCATION);
        return this.location != null && this.location.getType() == LocationType.CURRENT;
    }

    public Map<StoredTabletFile, Long> getLoaded() {
        this.ensureFetched(ColumnType.LOADED);
        return this.loadedFiles;
    }

    public Location getLast() {
        this.ensureFetched(ColumnType.LAST);
        return this.last;
    }

    public SuspendingTServer getSuspend() {
        this.ensureFetched(ColumnType.SUSPEND);
        return this.suspend;
    }

    public Collection<StoredTabletFile> getFiles() {
        this.ensureFetched(ColumnType.FILES);
        return this.files.keySet();
    }

    public Map<StoredTabletFile, DataFileValue> getFilesMap() {
        this.ensureFetched(ColumnType.FILES);
        return this.files;
    }

    public Collection<LogEntry> getLogs() {
        this.ensureFetched(ColumnType.LOGS);
        return this.logs;
    }

    public List<StoredTabletFile> getScans() {
        this.ensureFetched(ColumnType.SCANS);
        return this.scans;
    }

    public String getDirName() {
        this.ensureFetched(ColumnType.DIR);
        return this.dirName;
    }

    public MetadataTime getTime() {
        this.ensureFetched(ColumnType.TIME);
        return this.time;
    }

    public String getCloned() {
        this.ensureFetched(ColumnType.CLONED);
        return this.cloned;
    }

    public OptionalLong getFlushId() {
        this.ensureFetched(ColumnType.FLUSH_ID);
        return this.flush;
    }

    public OptionalLong getCompactId() {
        this.ensureFetched(ColumnType.COMPACT_ID);
        return this.compact;
    }

    public Double getSplitRatio() {
        this.ensureFetched(ColumnType.SPLIT_RATIO);
        return this.splitRatio;
    }

    public boolean hasChopped() {
        this.ensureFetched(ColumnType.CHOPPED);
        return this.chopped;
    }

    public SortedMap<Key, Value> getKeyValues() {
        Preconditions.checkState((this.keyValues != null ? 1 : 0) != 0, (Object)"Requested key values when it was not saved");
        return this.keyValues;
    }

    public TabletState getTabletState(Set<TServerInstance> liveTServers) {
        this.ensureFetched(ColumnType.LOCATION);
        this.ensureFetched(ColumnType.LAST);
        this.ensureFetched(ColumnType.SUSPEND);
        try {
            Location current = null;
            Location future = null;
            if (this.hasCurrent()) {
                current = this.location;
            } else {
                future = this.location;
            }
            TabletLocationState tls = new TabletLocationState(this.extent, future, current, this.last, this.suspend, null, false);
            return tls.getState(liveTServers);
        }
        catch (TabletLocationState.BadLocationStateException blse) {
            throw new IllegalArgumentException("Error creating TabletLocationState", blse);
        }
    }

    public Map<ExternalCompactionId, ExternalCompactionMetadata> getExternalCompactions() {
        this.ensureFetched(ColumnType.ECOMP);
        return this.extCompactions;
    }

    @VisibleForTesting
    public static <E extends Map.Entry<Key, Value>> TabletMetadata convertRow(Iterator<E> rowIter, EnumSet<ColumnType> fetchedColumns, boolean buildKeyValueMap) {
        Objects.requireNonNull(rowIter);
        TabletMetadata te = new TabletMetadata();
        ImmutableSortedMap.Builder kvBuilder = buildKeyValueMap ? ImmutableSortedMap.naturalOrder() : null;
        ImmutableMap.Builder filesBuilder = ImmutableMap.builder();
        ImmutableList.Builder scansBuilder = ImmutableList.builder();
        ImmutableList.Builder logsBuilder = ImmutableList.builder();
        ImmutableMap.Builder extCompBuilder = ImmutableMap.builder();
        ImmutableMap.Builder loadedFilesBuilder = ImmutableMap.builder();
        ByteSequence row = null;
        block52: while (rowIter.hasNext()) {
            Map.Entry kv = (Map.Entry)rowIter.next();
            Key key = (Key)kv.getKey();
            String val = ((Value)kv.getValue()).toString();
            String fam = key.getColumnFamilyData().toString();
            String qual = key.getColumnQualifierData().toString();
            if (buildKeyValueMap) {
                kvBuilder.put((Object)key, (Object)((Value)kv.getValue()));
            }
            if (row == null) {
                row = key.getRowData();
                KeyExtent ke = KeyExtent.fromMetaRow(key.getRow());
                te.endRow = ke.endRow();
                te.tableId = ke.tableId();
            } else if (!row.equals(key.getRowData())) {
                throw new IllegalArgumentException("Input contains more than one row : " + row + " " + key.getRowData());
            }
            switch (fam.toString()) {
                case "~tab": {
                    switch (qual) {
                        case "~pr": {
                            te.prevEndRow = MetadataSchema.TabletsSection.TabletColumnFamily.decodePrevEndRow((Value)kv.getValue());
                            te.sawPrevEndRow = true;
                            break;
                        }
                        case "oldprevrow": {
                            te.oldPrevEndRow = MetadataSchema.TabletsSection.TabletColumnFamily.decodePrevEndRow((Value)kv.getValue());
                            te.sawOldPrevEndRow = true;
                            break;
                        }
                        case "splitRatio": {
                            te.splitRatio = Double.parseDouble(val);
                        }
                    }
                    continue block52;
                }
                case "srv": {
                    switch (qual) {
                        case "dir": {
                            Preconditions.checkArgument((boolean)MetadataSchema.TabletsSection.ServerColumnFamily.isValidDirCol(val), (String)"Saw invalid dir name %s %s", (Object)key, (Object)val);
                            te.dirName = val;
                            break;
                        }
                        case "time": {
                            te.time = MetadataTime.parse(val);
                            break;
                        }
                        case "flush": {
                            te.flush = OptionalLong.of(Long.parseLong(val));
                            break;
                        }
                        case "compact": {
                            te.compact = OptionalLong.of(Long.parseLong(val));
                        }
                    }
                    continue block52;
                }
                case "file": {
                    filesBuilder.put((Object)new StoredTabletFile(qual), (Object)new DataFileValue(val));
                    continue block52;
                }
                case "loaded": {
                    loadedFilesBuilder.put((Object)new StoredTabletFile(qual), (Object)MetadataSchema.TabletsSection.BulkFileColumnFamily.getBulkLoadTid(val));
                    continue block52;
                }
                case "loc": {
                    te.setLocationOnce(val, qual, LocationType.CURRENT);
                    continue block52;
                }
                case "future": {
                    te.setLocationOnce(val, qual, LocationType.FUTURE);
                    continue block52;
                }
                case "last": {
                    te.last = Location.last(val, qual);
                    continue block52;
                }
                case "suspend": {
                    te.suspend = SuspendingTServer.fromValue((Value)kv.getValue());
                    continue block52;
                }
                case "scan": {
                    scansBuilder.add((Object)new StoredTabletFile(qual));
                    continue block52;
                }
                case "!cloned": {
                    te.cloned = val;
                    continue block52;
                }
                case "log": {
                    logsBuilder.add((Object)LogEntry.fromMetaWalEntry(kv));
                    continue block52;
                }
                case "ecomp": {
                    extCompBuilder.put((Object)ExternalCompactionId.of(qual), (Object)ExternalCompactionMetadata.fromJson(val));
                    continue block52;
                }
                case "chopped": {
                    te.chopped = true;
                    continue block52;
                }
            }
            throw new IllegalStateException("Unexpected family " + fam);
        }
        te.files = filesBuilder.build();
        te.loadedFiles = loadedFilesBuilder.build();
        te.fetchedCols = fetchedColumns;
        te.scans = scansBuilder.build();
        te.logs = logsBuilder.build();
        te.extCompactions = extCompBuilder.build();
        if (buildKeyValueMap) {
            te.keyValues = kvBuilder.build();
        }
        return te;
    }

    private void setLocationOnce(String val, String qual, LocationType lt) {
        if (this.location != null) {
            throw new IllegalStateException("Attempted to set second location for tableId: " + this.tableId + " endrow: " + this.endRow + " -- " + this.location + " " + qual + " " + val);
        }
        this.location = new Location(val, qual, lt);
    }

    @VisibleForTesting
    static TabletMetadata create(String id, String prevEndRow, String endRow) {
        TabletMetadata te = new TabletMetadata();
        te.tableId = TableId.of(id);
        te.sawPrevEndRow = true;
        te.prevEndRow = prevEndRow == null ? null : new Text(prevEndRow);
        te.endRow = endRow == null ? null : new Text(endRow);
        te.fetchedCols = EnumSet.of(ColumnType.PREV_ROW);
        return te;
    }

    public static synchronized Set<TServerInstance> getLiveTServers(ClientContext context) {
        HashSet<TServerInstance> liveServers = new HashSet<TServerInstance>();
        String path = context.getZooKeeperRoot() + "/tservers";
        for (String child : context.getZooCache().getChildren(path)) {
            TabletMetadata.checkServer(context, path, child).ifPresent(liveServers::add);
        }
        log.trace("Found {} live tservers at ZK path: {}", (Object)liveServers.size(), (Object)path);
        return liveServers;
    }

    private static Optional<TServerInstance> checkServer(ClientContext context, String path, String zPath) {
        Optional<TServerInstance> server = Optional.empty();
        ServiceLock.ServiceLockPath lockPath = ServiceLock.path(path + "/" + zPath);
        ZooCache.ZcStat stat = new ZooCache.ZcStat();
        Optional<ServiceLockData> sld = ServiceLock.getLockData(context.getZooCache(), lockPath, stat);
        if (sld.isPresent()) {
            log.trace("Checking server at ZK path = " + lockPath);
            HostAndPort client = sld.orElseThrow().getAddress(ServiceLockData.ThriftService.TSERV);
            if (client != null) {
                server = Optional.of(new TServerInstance(client, stat.getEphemeralOwner()));
            }
        }
        return server;
    }

    public static class Location {
        private final TServerInstance tServerInstance;
        private final LocationType lt;

        private Location(String server, String session, LocationType lt) {
            this(new TServerInstance(HostAndPort.fromString((String)server), session), lt);
        }

        private Location(TServerInstance tServerInstance, LocationType lt) {
            this.tServerInstance = Objects.requireNonNull(tServerInstance, "tServerInstance must not be null");
            this.lt = Objects.requireNonNull(lt, "locationType must not be null");
        }

        public LocationType getType() {
            return this.lt;
        }

        public TServerInstance getServerInstance() {
            return this.tServerInstance;
        }

        public String getHostPortSession() {
            return this.tServerInstance.getHostPortSession();
        }

        public String getHost() {
            return this.tServerInstance.getHost();
        }

        public String getHostPort() {
            return this.tServerInstance.getHostPort();
        }

        public HostAndPort getHostAndPort() {
            return this.tServerInstance.getHostAndPort();
        }

        public String getSession() {
            return this.tServerInstance.getSession();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Location location = (Location)o;
            return Objects.equals(this.tServerInstance, location.tServerInstance) && this.lt == location.lt;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.tServerInstance, this.lt});
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append("Location [");
            sb.append("server=").append(this.tServerInstance);
            sb.append(", type=").append((Object)this.lt);
            sb.append("]");
            return sb.toString();
        }

        public static Location last(TServerInstance instance) {
            return new Location(instance, LocationType.LAST);
        }

        public static Location last(String server, String session) {
            return Location.last(new TServerInstance(HostAndPort.fromString((String)server), session));
        }

        public static Location current(TServerInstance instance) {
            return new Location(instance, LocationType.CURRENT);
        }

        public static Location current(String server, String session) {
            return Location.current(new TServerInstance(HostAndPort.fromString((String)server), session));
        }

        public static Location future(TServerInstance instance) {
            return new Location(instance, LocationType.FUTURE);
        }

        public static Location future(String server, String session) {
            return Location.future(new TServerInstance(HostAndPort.fromString((String)server), session));
        }
    }

    public static enum ColumnType {
        LOCATION,
        PREV_ROW,
        OLD_PREV_ROW,
        FILES,
        LAST,
        LOADED,
        SCANS,
        DIR,
        TIME,
        CLONED,
        FLUSH_ID,
        LOGS,
        COMPACT_ID,
        SPLIT_RATIO,
        SUSPEND,
        CHOPPED,
        ECOMP;

    }

    public static enum LocationType {
        CURRENT,
        FUTURE,
        LAST;

    }
}

