/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.clientImpl.ClientConfConverter;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.ClientInfoImpl;
import org.apache.accumulo.core.clientImpl.ConnectorImpl;
import org.apache.accumulo.core.clientImpl.InstanceOperationsImpl;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;
import org.apache.accumulo.core.fate.zookeeper.ZooCacheFactory;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.singletons.SingletonManager;
import org.apache.accumulo.core.singletons.SingletonReservation;
import org.apache.accumulo.core.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="2.0.0")
public class ZooKeeperInstance
implements Instance {
    private static final Logger log = LoggerFactory.getLogger(ZooKeeperInstance.class);
    private String instanceId = null;
    private String instanceName = null;
    private final ZooCache zooCache;
    private final String zooKeepers;
    private final int zooKeepersSessionTimeOut;
    private ClientConfiguration clientConf;

    public ZooKeeperInstance(String instanceName, String zooKeepers) {
        this(ClientConfiguration.loadDefault().withInstance(instanceName).withZkHosts(zooKeepers));
    }

    ZooKeeperInstance(ClientConfiguration config, ZooCacheFactory zcf) {
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"config is null");
        SingletonManager.setMode(SingletonManager.Mode.CONNECTOR);
        this.clientConf = config;
        this.instanceId = this.clientConf.get(ClientConfiguration.ClientProperty.INSTANCE_ID);
        this.instanceName = this.clientConf.get(ClientConfiguration.ClientProperty.INSTANCE_NAME);
        if (this.instanceId == null == (this.instanceName == null)) {
            throw new IllegalArgumentException("Expected exactly one of instanceName and instanceId to be set; " + (this.instanceName == null ? "neither" : "both") + " were set");
        }
        this.zooKeepers = this.clientConf.get(ClientConfiguration.ClientProperty.INSTANCE_ZK_HOST);
        this.zooKeepersSessionTimeOut = (int)ConfigurationTypeHelper.getTimeInMillis(this.clientConf.get(ClientConfiguration.ClientProperty.INSTANCE_ZK_TIMEOUT));
        this.zooCache = zcf.getZooCache(this.zooKeepers, this.zooKeepersSessionTimeOut);
        if (this.instanceName != null) {
            this.getInstanceID();
        }
    }

    public ZooKeeperInstance(ClientConfiguration config) {
        this(config, new ZooCacheFactory());
    }

    @Override
    public String getInstanceID() {
        if (this.instanceId == null) {
            this.instanceId = ClientContext.getInstanceID(this.zooCache, this.instanceName).canonical();
        }
        ClientContext.verifyInstanceId(this.zooCache, this.instanceId, this.instanceName);
        return this.instanceId;
    }

    @Override
    public List<String> getMasterLocations() {
        return ClientContext.getManagerLocations(this.zooCache, this.getInstanceID());
    }

    @Override
    public String getRootTabletLocation() {
        Timer timer = null;
        if (log.isTraceEnabled()) {
            log.trace("tid={} Looking up root tablet location in zookeeper.", (Object)Thread.currentThread().getId());
            timer = Timer.startNew();
        }
        TabletMetadata.Location loc = TabletsMetadata.getRootMetadata("/accumulo/" + this.getInstanceID(), this.zooCache).getLocation();
        if (timer != null) {
            log.trace("tid={} Found root tablet at {} in {}", new Object[]{Thread.currentThread().getId(), loc, String.format("%.3f secs", (double)timer.elapsed(TimeUnit.MILLISECONDS) / 1000.0)});
        }
        if (loc == null || loc.getType() != TabletMetadata.LocationType.CURRENT) {
            return null;
        }
        return loc.getHostPort();
    }

    @Override
    public String getInstanceName() {
        if (this.instanceName == null) {
            this.instanceName = InstanceOperationsImpl.lookupInstanceName(this.zooCache, InstanceId.of(this.getInstanceID()));
        }
        return this.instanceName;
    }

    @Override
    public String getZooKeepers() {
        return this.zooKeepers;
    }

    @Override
    public int getZooKeepersSessionTimeOut() {
        return this.zooKeepersSessionTimeOut;
    }

    @Override
    public Connector getConnector(String principal, AuthenticationToken token) throws AccumuloException, AccumuloSecurityException {
        Properties properties = ClientConfConverter.toProperties(this.clientConf);
        properties.setProperty(ClientProperty.AUTH_PRINCIPAL.getKey(), principal);
        properties.setProperty(ClientProperty.INSTANCE_NAME.getKey(), this.getInstanceName());
        ClientInfoImpl info = new ClientInfoImpl(properties, token);
        AccumuloConfiguration serverConf = ClientConfConverter.toAccumuloConf(properties);
        return new ConnectorImpl(new ClientContext(SingletonReservation.noop(), info, serverConf, null));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("ZooKeeperInstance: ").append(this.getInstanceName()).append(" ").append(this.getZooKeepers());
        return sb.toString();
    }
}

