/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.iterators;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.file.rfile.bcfile.Compression;
import org.apache.accumulo.core.file.rfile.bcfile.CompressionAlgorithm;
import org.apache.accumulo.core.spi.file.rfile.compression.NoCompression;
import org.apache.hadoop.io.compress.Compressor;

public class ServerIteratorOptions {
    static final String COMPRESSION_ALGO = "__COMPRESSION_ALGO";
    private static final String NONE = new NoCompression().getName();

    public static void compressOption(AccumuloConfiguration config, IteratorSetting iteratorSetting, String option, String value) {
        String algo = config.get(Property.GENERAL_SERVER_ITERATOR_OPTIONS_COMPRESSION_ALGO);
        ServerIteratorOptions.setAlgo(iteratorSetting, algo);
        if (algo.equals(NONE)) {
            iteratorSetting.addOption(option, value);
        } else {
            ServerIteratorOptions.compressOption(config, iteratorSetting, option, (DataOutput dataOutput) -> {
                byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
                dataOutput.writeInt(bytes.length);
                dataOutput.write(bytes);
            });
        }
    }

    public static void compressOption(AccumuloConfiguration config, IteratorSetting iteratorSetting, String option, Serializer serializer) {
        String algo = config.get(Property.GENERAL_SERVER_ITERATOR_OPTIONS_COMPRESSION_ALGO);
        CompressionAlgorithm ca = Compression.getCompressionAlgorithmByName((String)algo);
        Compressor c = ca.getCompressor();
        ServerIteratorOptions.setAlgo(iteratorSetting, algo);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             DataOutputStream dos = new DataOutputStream(ca.createCompressionStream((OutputStream)baos, c, 32768));){
            serializer.serialize(dos);
            dos.close();
            String val = Base64.getEncoder().encodeToString(baos.toByteArray());
            iteratorSetting.addOption(option, val);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
        finally {
            ca.returnCompressor(c);
        }
    }

    private static void setAlgo(IteratorSetting iteratorSetting, String algo) {
        if (iteratorSetting.getOptions().containsKey(COMPRESSION_ALGO)) {
            Preconditions.checkArgument((boolean)((String)iteratorSetting.getOptions().get(COMPRESSION_ALGO)).equals(algo));
        } else {
            iteratorSetting.addOption(COMPRESSION_ALGO, algo);
        }
    }

    public static String decompressOption(Map<String, String> options, String option) {
        String algo = options.getOrDefault(COMPRESSION_ALGO, NONE);
        if (algo.equals(NONE)) {
            return options.get(option);
        }
        return ServerIteratorOptions.decompressOption(options, option, dataInput -> {
            int len = dataInput.readInt();
            byte[] data = new byte[len];
            dataInput.readFully(data);
            return new String(data, StandardCharsets.UTF_8);
        });
    }

    /*
     * Exception decompiling
     */
    public static <T> T decompressOption(Map<String, String> options, String option, Deserializer<T> deserializer) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static interface Serializer {
        public void serialize(DataOutput var1) throws IOException;
    }

    public static interface Deserializer<T> {
        public T deserialize(DataInputStream var1) throws IOException;
    }
}

