/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.conf.ColumnSet;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.replication.ReplicationTableOfflineException;
import org.apache.accumulo.core.replication.ReplicationTarget;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooCacheFactory;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.gc.SimpleGarbageCollector;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.log.WalStateManager;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.replication.ReplicaSystemFactory;
import org.apache.accumulo.server.replication.StatusCombiner;
import org.apache.accumulo.server.replication.StatusFormatter;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.server.util.ReplicationTableUtil;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.replication.MockReplicaSystem;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore(value="Replication ITs are not stable and not currently maintained")
public class ReplicationIT
extends ConfigurableMacBase {
    private static final Logger log = LoggerFactory.getLogger(ReplicationIT.class);
    private static final long MILLIS_BETWEEN_REPLICATION_TABLE_ONLINE_CHECKS = 5000L;

    @Override
    public int defaultTimeoutSeconds() {
        return 600;
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setProperty(Property.MASTER_REPLICATION_SCAN_INTERVAL, "1s");
        cfg.setProperty(Property.REPLICATION_WORK_ASSIGNMENT_SLEEP, "1s");
        cfg.setProperty(Property.TSERV_WALOG_MAX_SIZE, "1M");
        cfg.setProperty(Property.GC_CYCLE_START, "1s");
        cfg.setProperty(Property.GC_CYCLE_DELAY, "0");
        cfg.setProperty(Property.REPLICATION_NAME, "master");
        cfg.setProperty(Property.REPLICATION_WORK_PROCESSOR_DELAY, "1s");
        cfg.setProperty(Property.REPLICATION_WORK_PROCESSOR_PERIOD, "1s");
        cfg.setProperty(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX, "1M");
        cfg.setNumTservers(1);
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    private Multimap<String, String> getLogs(Connector conn) throws Exception {
        HashMultimap serverToTableID = HashMultimap.create();
        Scanner scanner = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
        scanner.setRange(MetadataSchema.TabletsSection.getRange());
        scanner.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
        for (Map.Entry entry : scanner) {
            TServerInstance key = new TServerInstance((Value)entry.getValue(), ((Key)entry.getKey()).getColumnQualifier());
            byte[] tableId = KeyExtent.tableOfMetadataRow((Text)((Key)entry.getKey()).getRow());
            serverToTableID.put((Object)key, (Object)new String(tableId, StandardCharsets.UTF_8));
        }
        HashMultimap logs = HashMultimap.create();
        Instance i = conn.getInstance();
        ZooReaderWriter zk = new ZooReaderWriter(i.getZooKeepers(), i.getZooKeepersSessionTimeOut(), "");
        WalStateManager wals = new WalStateManager(conn.getInstance(), zk);
        for (Map.Entry entry : wals.getAllMarkers().entrySet()) {
            for (UUID id : (List)entry.getValue()) {
                Pair state = wals.state((TServerInstance)entry.getKey(), id);
                for (String tableId : serverToTableID.get((Object)((TServerInstance)entry.getKey()))) {
                    logs.put((Object)((Path)state.getSecond()).toString(), (Object)tableId);
                }
            }
        }
        return logs;
    }

    private Multimap<String, String> getAllLogs(Connector conn) throws Exception {
        Multimap<String, String> logs = this.getLogs(conn);
        try {
            Scanner scanner = conn.createScanner("accumulo.replication", Authorizations.EMPTY);
            ReplicationSchema.StatusSection.limit((ScannerBase)scanner);
            Text buff = new Text();
            for (Map.Entry entry : scanner) {
                if (Thread.interrupted()) {
                    Thread.currentThread().interrupt();
                    return logs;
                }
                ReplicationSchema.StatusSection.getFile((Key)((Key)entry.getKey()), (Text)buff);
                String file = buff.toString();
                String tableId = ReplicationSchema.StatusSection.getTableId((Key)((Key)entry.getKey()));
                logs.put((Object)file, (Object)tableId);
            }
        }
        catch (TableOfflineException e) {
            log.debug("Replication table isn't online yet");
        }
        return logs;
    }

    private void waitForGCLock(Connector conn) throws InterruptedException {
        ZooKeeperInstance zki = (ZooKeeperInstance)conn.getInstance();
        ZooCacheFactory zcf = new ZooCacheFactory();
        ZooCache zcache = zcf.getZooCache(zki.getZooKeepers(), zki.getZooKeepersSessionTimeOut());
        String zkPath = ZooUtil.getRoot((Instance)conn.getInstance()) + "/gc/lock";
        log.info("Looking for GC lock at {}", (Object)zkPath);
        byte[] data = ZooLock.getLockData((ZooCache)zcache, (String)zkPath, null);
        while (null == data) {
            log.info("Waiting for GC ZooKeeper lock to be acquired");
            Thread.sleep(1000L);
            data = ZooLock.getLockData((ZooCache)zcache, (String)zkPath, null);
        }
    }

    @Test
    public void replicationTableCreated() throws AccumuloException, AccumuloSecurityException {
        Assert.assertTrue((boolean)this.getConnector().tableOperations().exists("accumulo.replication"));
        Assert.assertEquals((Object)"+rep", this.getConnector().tableOperations().tableIdMap().get("accumulo.replication"));
    }

    @Test
    public void verifyReplicationTableConfig() throws AccumuloException, TableNotFoundException, AccumuloSecurityException {
        TableOperations tops = this.getConnector().tableOperations();
        Map iterators = tops.listIterators("accumulo.replication");
        Assert.assertEquals((long)1L, (long)iterators.size());
        Assert.assertTrue((boolean)iterators.containsKey("statuscombiner"));
        Assert.assertTrue((boolean)((EnumSet)iterators.get("statuscombiner")).containsAll(EnumSet.allOf(IteratorUtil.IteratorScope.class)));
        for (IteratorUtil.IteratorScope scope : EnumSet.allOf(IteratorUtil.IteratorScope.class)) {
            IteratorSetting is = tops.getIteratorSetting("accumulo.replication", "statuscombiner", scope);
            Assert.assertEquals((long)30L, (long)is.getPriority());
            Assert.assertEquals((Object)StatusCombiner.class.getName(), (Object)is.getIteratorClass());
            Assert.assertEquals((long)1L, (long)is.getOptions().size());
            Assert.assertTrue((boolean)is.getOptions().containsKey("columns"));
            String cols = (String)is.getOptions().get("columns");
            IteratorSetting.Column statusSectionCol = new IteratorSetting.Column(ReplicationSchema.StatusSection.NAME);
            IteratorSetting.Column workSectionCol = new IteratorSetting.Column(ReplicationSchema.WorkSection.NAME);
            Assert.assertEquals((Object)(ColumnSet.encodeColumns((Text)statusSectionCol.getColumnFamily(), (Text)statusSectionCol.getColumnQualifier()) + "," + ColumnSet.encodeColumns((Text)workSectionCol.getColumnFamily(), (Text)workSectionCol.getColumnQualifier())), (Object)cols);
        }
        boolean foundLocalityGroups = false;
        boolean foundLocalityGroupDef1 = false;
        boolean foundLocalityGroupDef2 = false;
        boolean foundFormatter = false;
        Joiner j = Joiner.on((String)",");
        for (Map.Entry p : tops.getProperties("accumulo.replication")) {
            String key = (String)p.getKey();
            String val = (String)p.getValue();
            if (key.equals(Property.TABLE_FORMATTER_CLASS.getKey()) && val.equals(StatusFormatter.class.getName())) {
                foundFormatter = true;
                continue;
            }
            if (key.equals(Property.TABLE_LOCALITY_GROUPS.getKey()) && val.equals(j.join(ReplicationTable.LOCALITY_GROUPS.keySet()))) {
                foundLocalityGroups = true;
                continue;
            }
            if (!key.startsWith(Property.TABLE_LOCALITY_GROUP_PREFIX.getKey())) continue;
            if (key.equals(Property.TABLE_LOCALITY_GROUP_PREFIX.getKey() + ReplicationTable.STATUS_LG_NAME) && val.equals(j.join(Iterables.transform((Iterable)ReplicationTable.STATUS_LG_COLFAMS, Text::toString)))) {
                foundLocalityGroupDef1 = true;
                continue;
            }
            if (!key.equals(Property.TABLE_LOCALITY_GROUP_PREFIX.getKey() + ReplicationTable.WORK_LG_NAME) || !val.equals(j.join(Iterables.transform((Iterable)ReplicationTable.WORK_LG_COLFAMS, Text::toString)))) continue;
            foundLocalityGroupDef2 = true;
        }
        Assert.assertTrue((boolean)foundLocalityGroups);
        Assert.assertTrue((boolean)foundLocalityGroupDef1);
        Assert.assertTrue((boolean)foundLocalityGroupDef2);
        Assert.assertTrue((boolean)foundFormatter);
    }

    @Test
    public void correctRecordsCompleteFile() throws Exception {
        int i;
        Connector conn = this.getConnector();
        String table = "table1";
        conn.tableOperations().create(table);
        conn.tableOperations().setProperty(table, Property.TABLE_REPLICATION.getKey(), "true");
        BatchWriter bw = conn.createBatchWriter(table, new BatchWriterConfig());
        for (i = 0; i < 10; ++i) {
            Mutation m = new Mutation((CharSequence)Integer.toString(i));
            m.put(new byte[0], new byte[0], new byte[0]);
            bw.addMutation(m);
        }
        bw.close();
        while (!ReplicationTable.isOnline((Connector)conn)) {
            UtilWaitThread.sleepUninterruptibly((long)5000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        Assert.assertTrue((String)"Replication table did not exist", (boolean)ReplicationTable.isOnline((Connector)conn));
        for (i = 0; i < 5 && !conn.securityOperations().hasTablePermission("root", "accumulo.replication", TablePermission.READ); ++i) {
            log.info("Could not read replication table, waiting and will retry");
            Thread.sleep(2000L);
        }
        Assert.assertTrue((String)"'root' user could not read the replication table", (boolean)conn.securityOperations().hasTablePermission("root", "accumulo.replication", TablePermission.READ));
        HashSet<String> replRows = new HashSet<String>();
        int attempts = 5;
        while (replRows.isEmpty() && attempts > 0) {
            Scanner scanner = ReplicationTable.getScanner((Connector)conn);
            ReplicationSchema.StatusSection.limit((ScannerBase)scanner);
            for (Map.Entry entry : scanner) {
                Key k = (Key)entry.getKey();
                String fileUri = k.getRow().toString();
                try {
                    new URI(fileUri);
                }
                catch (URISyntaxException e) {
                    Assert.fail((String)("Expected a valid URI: " + fileUri));
                }
                replRows.add(fileUri);
            }
        }
        HashSet<String> wals = new HashSet<String>();
        Instance i2 = conn.getInstance();
        ZooReaderWriter zk = new ZooReaderWriter(i2.getZooKeepers(), i2.getZooKeepersSessionTimeOut(), "");
        for (attempts = 5; wals.isEmpty() && attempts > 0; --attempts) {
            WalStateManager markers = new WalStateManager(i2, zk);
            for (Map.Entry entry : markers.getAllState().entrySet()) {
                wals.add(((Path)entry.getKey()).toString());
            }
        }
        Assert.assertEquals((String)("Rows found: " + replRows), (long)1L, (long)replRows.size());
        replRows.removeAll(wals);
        Assert.assertEquals((long)2L, (long)wals.size());
        Assert.assertEquals((long)0L, (long)replRows.size());
    }

    @Test
    public void noRecordsWithoutReplication() throws Exception {
        Connector conn = this.getConnector();
        ArrayList<String> tables = new ArrayList<String>();
        Assert.assertFalse((boolean)ReplicationTable.isOnline((Connector)conn));
        for (int i = 0; i < 5; ++i) {
            String name = "table" + i;
            tables.add(name);
            conn.tableOperations().create(name);
        }
        Assert.assertFalse((boolean)ReplicationTable.isOnline((Connector)conn));
        for (String table : tables) {
            this.writeSomeData(conn, table, 5, 5);
        }
        Assert.assertFalse((boolean)ReplicationTable.isOnline((Connector)conn));
        for (String table : tables) {
            conn.tableOperations().compact(table, null, null, true, true);
        }
        Assert.assertFalse((boolean)ReplicationTable.isOnline((Connector)conn));
        for (String table : tables) {
            conn.tableOperations().delete(table);
        }
        Assert.assertFalse((boolean)ReplicationTable.isOnline((Connector)conn));
    }

    @Test
    public void twoEntriesForTwoTables() throws Exception {
        Connector conn = this.getConnector();
        String table1 = "table1";
        String table2 = "table2";
        Assert.assertFalse((String)"Replication table already online at the beginning of the test", (boolean)ReplicationTable.isOnline((Connector)conn));
        conn.tableOperations().create(table1);
        conn.tableOperations().create(table2);
        conn.securityOperations().grantTablePermission("root", "accumulo.replication", TablePermission.READ);
        Thread.sleep(5000L);
        conn.tableOperations().setProperty(table1, Property.TABLE_REPLICATION.getKey(), "true");
        Assert.assertFalse((boolean)ReplicationTable.isOnline((Connector)conn));
        this.writeSomeData(conn, table1, 50, 50);
        while (!ReplicationTable.isOnline((Connector)conn)) {
            UtilWaitThread.sleepUninterruptibly((long)5000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        Assert.assertTrue((boolean)ReplicationTable.isOnline((Connector)conn));
        Scanner s = ReplicationTable.getScanner((Connector)conn);
        ReplicationSchema.StatusSection.limit((ScannerBase)s);
        for (int i = 0; i < 5 && Iterators.size((Iterator)s.iterator()) != 1; ++i) {
            Thread.sleep(1000L);
        }
        Map.Entry entry = (Map.Entry)Iterators.getOnlyElement((Iterator)s.iterator());
        Assert.assertEquals((String)("Expected to find replication entry for " + table1), conn.tableOperations().tableIdMap().get(table1), (Object)((Key)entry.getKey()).getColumnQualifier().toString());
        s.close();
        conn.tableOperations().setProperty(table2, Property.TABLE_REPLICATION.getKey(), "true");
        this.writeSomeData(conn, table2, 50, 50);
        HashSet tableIds = Sets.newHashSet((Object[])new String[]{(String)conn.tableOperations().tableIdMap().get(table1), (String)conn.tableOperations().tableIdMap().get(table2)});
        HashSet tableIdsForMetadata = Sets.newHashSet((Iterable)tableIds);
        ArrayList<Map.Entry> records = new ArrayList<Map.Entry>();
        s = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
        s.setRange(MetadataSchema.ReplicationSection.getRange());
        for (Map.Entry metadata : s) {
            records.add(metadata);
            log.debug("Meta: {} => {}", (Object)((Key)metadata.getKey()).toStringNoTruncate(), (Object)((Value)metadata.getValue()).toString());
        }
        Assert.assertEquals((String)("Expected to find 2 records, but actually found " + records), (long)2L, (long)records.size());
        for (Map.Entry metadata : records) {
            Assert.assertTrue((String)("Expected record to be in metadata but wasn't " + ((Key)metadata.getKey()).toStringNoTruncate() + ", tableIds remaining " + tableIdsForMetadata), (boolean)tableIdsForMetadata.remove(((Key)metadata.getKey()).getColumnQualifier().toString()));
        }
        Assert.assertTrue((String)("Expected that we had removed all metadata entries " + tableIdsForMetadata), (boolean)tableIdsForMetadata.isEmpty());
        Thread.sleep(5000L);
        s = ReplicationTable.getScanner((Connector)conn);
        ReplicationSchema.StatusSection.limit((ScannerBase)s);
        Iterator iter = s.iterator();
        Assert.assertTrue((String)"Found no records in replication table", (boolean)iter.hasNext());
        entry = (Map.Entry)iter.next();
        Assert.assertTrue((String)"Expected to find element in replication table", (boolean)tableIds.remove(((Key)entry.getKey()).getColumnQualifier().toString()));
        Assert.assertTrue((String)"Expected to find two elements in replication table, only found one ", (boolean)iter.hasNext());
        entry = (Map.Entry)iter.next();
        Assert.assertTrue((String)"Expected to find element in replication table", (boolean)tableIds.remove(((Key)entry.getKey()).getColumnQualifier().toString()));
        Assert.assertFalse((String)"Expected to only find two elements in replication table", (boolean)iter.hasNext());
    }

    private void writeSomeData(Connector conn, String table, int rows, int cols) throws Exception {
        BatchWriter bw = conn.createBatchWriter(table, new BatchWriterConfig());
        for (int row = 0; row < rows; ++row) {
            Mutation m = new Mutation((CharSequence)Integer.toString(row));
            for (int col = 0; col < cols; ++col) {
                String value = Integer.toString(col);
                m.put((CharSequence)value, (CharSequence)"", (CharSequence)value);
            }
            bw.addMutation(m);
        }
        bw.close();
    }

    @Test
    public void replicationEntriesPrecludeWalDeletion() throws Exception {
        Connector conn = this.getConnector();
        String table1 = "table1";
        String table2 = "table2";
        String table3 = "table3";
        HashMultimap logs = HashMultimap.create();
        final AtomicBoolean keepRunning = new AtomicBoolean(true);
        Thread t = new Thread(new Runnable((Multimap)logs, conn){
            final /* synthetic */ Multimap val$logs;
            final /* synthetic */ Connector val$conn;
            {
                this.val$logs = multimap;
                this.val$conn = connector;
            }

            @Override
            public void run() {
                while (keepRunning.get()) {
                    try {
                        this.val$logs.putAll(ReplicationIT.this.getAllLogs(this.val$conn));
                    }
                    catch (Exception e) {
                        log.error("Error getting logs", (Throwable)e);
                    }
                }
            }
        });
        t.start();
        conn.tableOperations().create(table1);
        conn.tableOperations().setProperty(table1, Property.TABLE_REPLICATION.getKey(), "true");
        conn.tableOperations().setProperty(table1, Property.TABLE_REPLICATION_TARGET.getKey() + "cluster1", "1");
        Thread.sleep(2000L);
        this.writeSomeData(conn, table1, 200, 500);
        conn.tableOperations().create(table2);
        conn.tableOperations().setProperty(table2, Property.TABLE_REPLICATION.getKey(), "true");
        conn.tableOperations().setProperty(table2, Property.TABLE_REPLICATION_TARGET.getKey() + "cluster1", "1");
        Thread.sleep(2000L);
        this.writeSomeData(conn, table2, 200, 500);
        conn.tableOperations().create(table3);
        conn.tableOperations().setProperty(table3, Property.TABLE_REPLICATION.getKey(), "true");
        conn.tableOperations().setProperty(table3, Property.TABLE_REPLICATION_TARGET.getKey() + "cluster1", "1");
        Thread.sleep(2000L);
        this.writeSomeData(conn, table3, 200, 500);
        for (String table : Arrays.asList(table1, table2, table3)) {
            conn.tableOperations().flush(table, null, null, true);
        }
        keepRunning.set(false);
        t.join(5000L);
        Thread.sleep(5000L);
        Set<String> replFiles = this.getReferencesToFilesToBeReplicated(conn);
        String replicationTableId = (String)conn.tableOperations().tableIdMap().get("accumulo.replication");
        Iterator observedLogs = logs.entries().iterator();
        while (observedLogs.hasNext()) {
            Map.Entry observedLog = (Map.Entry)observedLogs.next();
            if (!replicationTableId.equals(observedLog.getValue())) continue;
            log.info("Removing {} because its tableId is for the replication table", (Object)observedLog);
            observedLogs.remove();
        }
        Assert.assertTrue((String)("Metadata log distribution: " + logs + "replFiles " + replFiles), (boolean)logs.keySet().containsAll(replFiles));
        Assert.assertTrue((String)"Difference between replication entries and current logs is bigger than one", (logs.keySet().size() - replFiles.size() <= 1 ? 1 : 0) != 0);
        Configuration conf = new Configuration();
        for (String replFile : replFiles) {
            Path p = new Path(replFile);
            FileSystem fs = p.getFileSystem(conf);
            if (fs.exists(p)) continue;
            Set<String> currentSet = this.getReferencesToFilesToBeReplicated(conn);
            log.info("Current references {}", currentSet);
            log.info("Looking for reference to {}", (Object)replFile);
            log.info("Contains? {}", (Object)currentSet.contains(replFile));
            Assert.assertTrue((String)("File does not exist anymore, it was likely incorrectly garbage collected: " + p), (!currentSet.contains(replFile) ? 1 : 0) != 0);
        }
    }

    private Set<String> getReferencesToFilesToBeReplicated(Connector conn) throws ReplicationTableOfflineException {
        Scanner s = ReplicationTable.getScanner((Connector)conn);
        ReplicationSchema.StatusSection.limit((ScannerBase)s);
        HashSet<String> replFiles = new HashSet<String>();
        for (Map.Entry entry : s) {
            replFiles.add(((Key)entry.getKey()).getRow().toString());
        }
        return replFiles;
    }

    @Test
    public void combinerWorksOnMetadata() throws Exception {
        Connector conn = this.getConnector();
        conn.securityOperations().grantTablePermission("root", "accumulo.metadata", TablePermission.WRITE);
        ReplicationTableUtil.configureMetadataTable((Connector)conn, (String)"accumulo.metadata");
        Replication.Status stat1 = StatusUtil.fileCreated((long)100L);
        Replication.Status stat2 = StatusUtil.fileClosed();
        BatchWriter bw = conn.createBatchWriter("accumulo.metadata", new BatchWriterConfig());
        Mutation m = new Mutation((CharSequence)(MetadataSchema.ReplicationSection.getRowPrefix() + "file:/accumulo/wals/tserver+port/uuid"));
        m.put(MetadataSchema.ReplicationSection.COLF, new Text("1"), ProtobufUtil.toValue((GeneratedMessage)stat1));
        bw.addMutation(m);
        bw.close();
        Scanner s = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
        s.setRange(MetadataSchema.ReplicationSection.getRange());
        Replication.Status actual = Replication.Status.parseFrom((byte[])((Value)((Map.Entry)Iterables.getOnlyElement((Iterable)s)).getValue()).get());
        Assert.assertEquals((Object)stat1, (Object)actual);
        bw = conn.createBatchWriter("accumulo.metadata", new BatchWriterConfig());
        m = new Mutation((CharSequence)(MetadataSchema.ReplicationSection.getRowPrefix() + "file:/accumulo/wals/tserver+port/uuid"));
        m.put(MetadataSchema.ReplicationSection.COLF, new Text("1"), ProtobufUtil.toValue((GeneratedMessage)stat2));
        bw.addMutation(m);
        bw.close();
        s = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
        s.setRange(MetadataSchema.ReplicationSection.getRange());
        actual = Replication.Status.parseFrom((byte[])((Value)((Map.Entry)Iterables.getOnlyElement((Iterable)s)).getValue()).get());
        Replication.Status expected = Replication.Status.newBuilder().setBegin(0L).setEnd(0L).setClosed(true).setInfiniteEnd(true).setCreatedTime(100L).build();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void noDeadlock() throws Exception {
        Connector conn = this.getConnector();
        ReplicationTable.setOnline((Connector)conn);
        conn.securityOperations().grantTablePermission("root", "accumulo.replication", TablePermission.WRITE);
        conn.tableOperations().deleteRows("accumulo.replication", null, null);
        String table1 = "table1";
        String table2 = "table2";
        String table3 = "table3";
        conn.tableOperations().create(table1);
        conn.tableOperations().setProperty(table1, Property.TABLE_REPLICATION.getKey(), "true");
        conn.tableOperations().setProperty(table1, Property.TABLE_REPLICATION_TARGET.getKey() + "cluster1", "1");
        conn.tableOperations().create(table2);
        conn.tableOperations().setProperty(table2, Property.TABLE_REPLICATION.getKey(), "true");
        conn.tableOperations().setProperty(table2, Property.TABLE_REPLICATION_TARGET.getKey() + "cluster1", "1");
        conn.tableOperations().create(table3);
        conn.tableOperations().setProperty(table3, Property.TABLE_REPLICATION.getKey(), "true");
        conn.tableOperations().setProperty(table3, Property.TABLE_REPLICATION_TARGET.getKey() + "cluster1", "1");
        this.writeSomeData(conn, table1, 200, 500);
        this.writeSomeData(conn, table2, 200, 500);
        this.writeSomeData(conn, table3, 200, 500);
        for (String table : Arrays.asList(table1, table2, table3)) {
            conn.tableOperations().flush(table, null, null, true);
        }
        for (String table : Arrays.asList(table1, table2, table3)) {
            conn.tableOperations().flush(table, null, null, true);
        }
        for (String table : Arrays.asList("accumulo.metadata", table1, table2, table3)) {
            Iterators.size((Iterator)conn.createScanner(table, Authorizations.EMPTY).iterator());
        }
    }

    @Test
    public void filesClosedAfterUnused() throws Exception {
        Connector conn = this.getConnector();
        String table = "table";
        conn.tableOperations().create(table);
        String tableId = (String)conn.tableOperations().tableIdMap().get(table);
        Assert.assertNotNull((Object)tableId);
        conn.tableOperations().setProperty(table, Property.TABLE_REPLICATION.getKey(), "true");
        conn.tableOperations().setProperty(table, Property.TABLE_REPLICATION_TARGET.getKey() + "cluster1", "1");
        conn.instanceOperations().setProperty(Property.REPLICATION_PEERS.getKey() + "cluster1", ReplicaSystemFactory.getPeerConfigurationValue(MockReplicaSystem.class, (String)"50000"));
        BatchWriter bw = conn.createBatchWriter(table, new BatchWriterConfig());
        Mutation m = new Mutation((CharSequence)"one");
        m.put((CharSequence)"", (CharSequence)"", (CharSequence)"");
        bw.addMutation(m);
        bw.close();
        bw = conn.createBatchWriter(table, new BatchWriterConfig());
        m = new Mutation((CharSequence)"three");
        m.put((CharSequence)"", (CharSequence)"", (CharSequence)"");
        bw.addMutation(m);
        bw.close();
        Scanner s = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
        s.fetchColumnFamily(MetadataSchema.TabletsSection.LogColumnFamily.NAME);
        s.setRange(MetadataSchema.TabletsSection.getRange((String)tableId));
        HashSet<String> wals = new HashSet<String>();
        for (Map.Entry entry : s) {
            LogEntry logEntry = LogEntry.fromKeyValue((Key)((Key)entry.getKey()), (Value)((Value)entry.getValue()));
            wals.add(new Path(logEntry.filename).toString());
        }
        log.warn("Found wals {}", wals);
        bw = conn.createBatchWriter(table, new BatchWriterConfig());
        m = new Mutation((CharSequence)"three");
        byte[] bytes = new byte[0x100000];
        m.put("1".getBytes(), new byte[0], bytes);
        m.put("2".getBytes(), new byte[0], bytes);
        m.put("3".getBytes(), new byte[0], bytes);
        m.put("4".getBytes(), new byte[0], bytes);
        m.put("5".getBytes(), new byte[0], bytes);
        bw.addMutation(m);
        bw.close();
        conn.tableOperations().flush(table, null, null, true);
        while (!ReplicationTable.isOnline((Connector)conn)) {
            UtilWaitThread.sleepUninterruptibly((long)5000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        block7: for (int i = 0; i < 10; ++i) {
            s = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
            s.fetchColumnFamily(MetadataSchema.TabletsSection.LogColumnFamily.NAME);
            s.setRange(MetadataSchema.TabletsSection.getRange((String)tableId));
            for (Map.Entry entry : s) {
                log.info(((Key)entry.getKey()).toStringNoTruncate() + "=" + entry.getValue());
            }
            try {
                s = ReplicationTable.getScanner((Connector)conn);
                ReplicationSchema.StatusSection.limit((ScannerBase)s);
                Text buff = new Text();
                boolean allReferencedLogsClosed = true;
                int recordsFound = 0;
                for (Map.Entry e : s) {
                    Replication.Status stat;
                    ++recordsFound;
                    allReferencedLogsClosed = true;
                    ReplicationSchema.StatusSection.getFile((Key)((Key)e.getKey()), (Text)buff);
                    String file = buff.toString();
                    if (!wals.contains(file) || (stat = Replication.Status.parseFrom((byte[])((Value)e.getValue()).get())).getClosed()) continue;
                    log.info("{} wasn't closed", (Object)file);
                    allReferencedLogsClosed = false;
                }
                if (recordsFound > 0 && allReferencedLogsClosed) {
                    return;
                }
                Thread.sleep(2000L);
                continue;
            }
            catch (RuntimeException e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof AccumuloSecurityException)) continue;
                AccumuloSecurityException ase = (AccumuloSecurityException)cause;
                switch (ase.getSecurityErrorCode()) {
                    case PERMISSION_DENIED: {
                        Thread.sleep(2000L);
                        continue block7;
                    }
                    default: {
                        throw e;
                    }
                }
            }
        }
        Assert.fail((String)"We had a file that was referenced but didn't get closed");
    }

    @Test
    public void singleTableWithSingleTarget() throws Exception {
        Replication.Status actual;
        this.getCluster().getClusterControl().stop(ServerType.GARBAGE_COLLECTOR);
        Connector conn = this.getConnector();
        String table1 = "table1";
        Assert.assertFalse((boolean)ReplicationTable.isOnline((Connector)conn));
        conn.tableOperations().create(table1);
        int attempts = 10;
        while (attempts > 0) {
            try {
                conn.tableOperations().setProperty(table1, Property.TABLE_REPLICATION.getKey(), "true");
                conn.tableOperations().setProperty(table1, Property.TABLE_REPLICATION_TARGET.getKey() + "cluster1", "4");
                conn.instanceOperations().setProperty(Property.REPLICATION_PEERS.getKey() + "cluster1", ReplicaSystemFactory.getPeerConfigurationValue(MockReplicaSystem.class, (String)"100000"));
                break;
            }
            catch (Exception e) {
                if (--attempts <= 0) {
                    throw e;
                }
                UtilWaitThread.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.SECONDS);
            }
        }
        this.writeSomeData(conn, table1, 2000, 50);
        while (!ReplicationTable.isOnline((Connector)conn)) {
            UtilWaitThread.sleepUninterruptibly((long)5000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        Assert.assertTrue((String)"Replication table was never created", (boolean)ReplicationTable.isOnline((Connector)conn));
        for (int i = 0; i < 10 && !conn.tableOperations().listIterators("accumulo.replication").keySet().contains("statuscombiner"); ++i) {
            UtilWaitThread.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.SECONDS);
        }
        Assert.assertTrue((String)"Combiner was never set on replication table", (boolean)conn.tableOperations().listIterators("accumulo.replication").keySet().contains("statuscombiner"));
        conn.tableOperations().flush(table1, null, null, true);
        Scanner s = ReplicationTable.getScanner((Connector)conn);
        ReplicationSchema.StatusSection.limit((ScannerBase)s);
        Map.Entry entry = null;
        Replication.Status expectedStatus = StatusUtil.openWithUnknownLength();
        attempts = 10;
        while (null == entry && attempts > 0) {
            try {
                entry = (Map.Entry)Iterables.getOnlyElement((Iterable)s);
                actual = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
                if (actual.getInfiniteEnd() == expectedStatus.getInfiniteEnd()) continue;
                entry = null;
                Thread.sleep(1000L);
            }
            catch (NoSuchElementException e) {
                entry = null;
                Thread.sleep(500L);
            }
            catch (IllegalArgumentException e) {
                s = ReplicationTable.getScanner((Connector)conn);
                ReplicationSchema.StatusSection.limit((ScannerBase)s);
                for (Map.Entry content : s) {
                    log.info(((Key)content.getKey()).toStringNoTruncate() + " => " + content.getValue());
                }
                throw e;
            }
            finally {
                --attempts;
            }
        }
        Assert.assertNotNull((String)"Could not find expected entry in replication table", entry);
        actual = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
        Assert.assertTrue((String)("Expected to find a replication entry that is open with infinite length: " + ProtobufUtil.toString((GeneratedMessage)actual)), (!actual.getClosed() && actual.getInfiniteEnd() ? 1 : 0) != 0);
        boolean notFound = true;
        for (int i = 0; i < 10 && notFound; ++i) {
            s = ReplicationTable.getScanner((Connector)conn);
            ReplicationSchema.WorkSection.limit((ScannerBase)s);
            int elementsFound = Iterables.size((Iterable)s);
            if (0 < elementsFound) {
                Assert.assertEquals((long)1L, (long)elementsFound);
                notFound = false;
            }
            Thread.sleep(500L);
        }
        if (notFound) {
            s = ReplicationTable.getScanner((Connector)conn);
            for (Map.Entry content : s) {
                log.info(((Key)content.getKey()).toStringNoTruncate() + " => " + content.getValue());
            }
            Assert.assertFalse((String)"Did not find the work entry for the status entry", (boolean)notFound);
        }
        this.writeSomeData(conn, table1, 3000, 50);
        log.info("Issued compaction for table");
        conn.tableOperations().compact(table1, null, null, true, true);
        log.info("Compaction completed");
        Thread.sleep(5000L);
        s = ReplicationTable.getScanner((Connector)conn);
        ReplicationSchema.StatusSection.limit((ScannerBase)s);
        int numRecords = 0;
        for (Map.Entry e : s) {
            ++numRecords;
            log.info("Found status record {}\t{}", (Object)((Key)e.getKey()).toStringNoTruncate(), (Object)ProtobufUtil.toString((GeneratedMessage)Replication.Status.parseFrom((byte[])((Value)e.getValue()).get())));
        }
        Assert.assertEquals((long)2L, (long)numRecords);
        notFound = true;
        for (int i = 0; i < 10 && notFound; ++i) {
            s = ReplicationTable.getScanner((Connector)conn);
            ReplicationSchema.WorkSection.limit((ScannerBase)s);
            int elementsFound = Iterables.size((Iterable)s);
            if (2 == elementsFound) {
                notFound = false;
            }
            Thread.sleep(500L);
        }
        if (notFound) {
            s = ReplicationTable.getScanner((Connector)conn);
            for (Map.Entry content : s) {
                log.info(((Key)content.getKey()).toStringNoTruncate() + " => " + content.getValue());
            }
            Assert.assertFalse((String)"Did not find the work entries for the status entries", (boolean)notFound);
        }
    }

    @Test
    public void correctClusterNameInWorkEntry() throws Exception {
        Scanner s;
        Connector conn = this.getConnector();
        String table1 = "table1";
        Assert.assertFalse((boolean)ReplicationTable.isOnline((Connector)conn));
        conn.tableOperations().create(table1);
        int attempts = 5;
        while (attempts > 0) {
            try {
                conn.tableOperations().setProperty(table1, Property.TABLE_REPLICATION.getKey(), "true");
                conn.tableOperations().setProperty(table1, Property.TABLE_REPLICATION_TARGET.getKey() + "cluster1", "4");
                attempts = 0;
            }
            catch (Exception e) {
                if (--attempts <= 0) {
                    throw e;
                }
                UtilWaitThread.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }
        this.writeSomeData(conn, table1, 2000, 50);
        conn.tableOperations().flush(table1, null, null, true);
        String tableId = (String)conn.tableOperations().tableIdMap().get(table1);
        Assert.assertNotNull((String)"Table ID was null", (Object)tableId);
        while (!ReplicationTable.isOnline((Connector)conn)) {
            UtilWaitThread.sleepUninterruptibly((long)5000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        Assert.assertTrue((String)"Replication table did not exist", (boolean)ReplicationTable.isOnline((Connector)conn));
        for (int i = 0; i < 5 && !conn.securityOperations().hasTablePermission("root", "accumulo.replication", TablePermission.READ); ++i) {
            Thread.sleep(1000L);
        }
        Assert.assertTrue((boolean)conn.securityOperations().hasTablePermission("root", "accumulo.replication", TablePermission.READ));
        boolean notFound = true;
        for (int i = 0; i < 10 && notFound; ++i) {
            s = ReplicationTable.getScanner((Connector)conn);
            ReplicationSchema.WorkSection.limit((ScannerBase)s);
            try {
                Map.Entry e = (Map.Entry)Iterables.getOnlyElement((Iterable)s);
                Text expectedColqual = new ReplicationTarget("cluster1", "4", tableId).toText();
                Assert.assertEquals((Object)expectedColqual, (Object)((Key)e.getKey()).getColumnQualifier());
                notFound = false;
            }
            catch (NoSuchElementException e) {
            }
            catch (IllegalArgumentException e) {
                s = ReplicationTable.getScanner((Connector)conn);
                for (Map.Entry content : s) {
                    log.info(((Key)content.getKey()).toStringNoTruncate() + " => " + content.getValue());
                }
                Assert.fail((String)"Found more than one work section entry");
            }
            Thread.sleep(500L);
        }
        if (notFound) {
            s = ReplicationTable.getScanner((Connector)conn);
            for (Map.Entry content : s) {
                log.info(((Key)content.getKey()).toStringNoTruncate() + " => " + content.getValue());
            }
            Assert.assertFalse((String)"Did not find the work entry for the status entry", (boolean)notFound);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void replicationRecordsAreClosedAfterGarbageCollection() throws Exception {
        this.getCluster().getClusterControl().stop(ServerType.GARBAGE_COLLECTOR);
        final Connector conn = this.getConnector();
        ReplicationTable.setOnline((Connector)conn);
        conn.securityOperations().grantTablePermission("root", "accumulo.replication", TablePermission.WRITE);
        conn.tableOperations().deleteRows("accumulo.replication", null, null);
        final AtomicBoolean keepRunning = new AtomicBoolean(true);
        final HashSet metadataWals = new HashSet();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                while (keepRunning.get()) {
                    try {
                        metadataWals.addAll(ReplicationIT.this.getLogs(conn).keySet());
                    }
                    catch (Exception e) {
                        log.error("Metadata table doesn't exist");
                    }
                }
            }
        });
        t.start();
        String table1 = "table1";
        String table2 = "table2";
        String table3 = "table3";
        try {
            conn.tableOperations().create(table1);
            conn.tableOperations().setProperty(table1, Property.TABLE_REPLICATION.getKey(), "true");
            conn.tableOperations().setProperty(table1, Property.TABLE_REPLICATION_TARGET.getKey() + "cluster1", "1");
            conn.instanceOperations().setProperty(Property.REPLICATION_PEERS.getKey() + "cluster1", ReplicaSystemFactory.getPeerConfigurationValue(MockReplicaSystem.class, null));
            this.writeSomeData(conn, table1, 200, 500);
            conn.tableOperations().create(table2);
            conn.tableOperations().setProperty(table2, Property.TABLE_REPLICATION.getKey(), "true");
            conn.tableOperations().setProperty(table2, Property.TABLE_REPLICATION_TARGET.getKey() + "cluster1", "1");
            this.writeSomeData(conn, table2, 200, 500);
            conn.tableOperations().create(table3);
            conn.tableOperations().setProperty(table3, Property.TABLE_REPLICATION.getKey(), "true");
            conn.tableOperations().setProperty(table3, Property.TABLE_REPLICATION_TARGET.getKey() + "cluster1", "1");
            this.writeSomeData(conn, table3, 200, 500);
            for (String table : Arrays.asList(table1, table2, table3)) {
                conn.tableOperations().compact(table, null, null, true, true);
            }
        }
        finally {
            keepRunning.set(false);
            t.join(5000L);
            Assert.assertFalse((boolean)t.isAlive());
        }
        this.cluster.getClusterControl().stop(ServerType.TABLET_SERVER);
        this.cluster.getClusterControl().start(ServerType.TABLET_SERVER);
        for (String table : Arrays.asList(table1, table2, table3)) {
            Iterators.size((Iterator)conn.createScanner(table, Authorizations.EMPTY).iterator());
        }
        Process gc = this.cluster.exec(SimpleGarbageCollector.class, new String[0]);
        this.waitForGCLock(conn);
        Thread.sleep(1000L);
        log.info("GC is up and should have had time to run at least once by now");
        try {
            Replication.Status status;
            String wal;
            Map.Entry entry;
            long recordsFound;
            Iterator iter;
            Object s;
            boolean allClosed = true;
            for (int i = 0; i < 10; ++i) {
                s = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
                s.setRange(Range.prefix((CharSequence)MetadataSchema.ReplicationSection.getRowPrefix()));
                iter = s.iterator();
                recordsFound = 0L;
                while (allClosed && iter.hasNext()) {
                    entry = (Map.Entry)iter.next();
                    wal = ((Key)entry.getKey()).getRow().toString();
                    if (!metadataWals.contains(wal)) continue;
                    status = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
                    log.info("{}={}", (Object)((Key)entry.getKey()).toStringNoTruncate(), (Object)ProtobufUtil.toString((GeneratedMessage)status));
                    allClosed &= status.getClosed();
                    ++recordsFound;
                }
                log.info("Found {} records from the metadata table", (Object)recordsFound);
                if (allClosed) break;
                UtilWaitThread.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.SECONDS);
            }
            if (!allClosed) {
                Scanner s2 = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
                s2.setRange(Range.prefix((CharSequence)MetadataSchema.ReplicationSection.getRowPrefix()));
                for (Map.Entry entry2 : s2) {
                    log.info(((Key)entry2.getKey()).toStringNoTruncate() + " " + ProtobufUtil.toString((GeneratedMessage)Replication.Status.parseFrom((byte[])((Value)entry2.getValue()).get())));
                }
                Assert.fail((String)"Expected all replication records in the metadata table to be closed");
            }
            for (int i = 0; i < 10; ++i) {
                allClosed = true;
                s = ReplicationTable.getScanner((Connector)conn);
                iter = s.iterator();
                recordsFound = 0L;
                while (allClosed && iter.hasNext()) {
                    entry = (Map.Entry)iter.next();
                    wal = ((Key)entry.getKey()).getRow().toString();
                    if (!metadataWals.contains(wal)) continue;
                    status = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
                    log.info("{}={}", (Object)((Key)entry.getKey()).toStringNoTruncate(), (Object)ProtobufUtil.toString((GeneratedMessage)status));
                    allClosed &= status.getClosed();
                    ++recordsFound;
                }
                log.info("Found {} records from the replication table", (Object)recordsFound);
                if (allClosed) break;
                UtilWaitThread.sleepUninterruptibly((long)3L, (TimeUnit)TimeUnit.SECONDS);
            }
            if (!allClosed) {
                Scanner s3 = ReplicationTable.getScanner((Connector)conn);
                ReplicationSchema.StatusSection.limit((ScannerBase)s3);
                for (Map.Entry entry2 : s3) {
                    log.info(((Key)entry2.getKey()).toStringNoTruncate() + " " + TextFormat.shortDebugString((MessageOrBuilder)Replication.Status.parseFrom((byte[])((Value)entry2.getValue()).get())));
                }
                Assert.fail((String)"Expected all replication records in the replication table to be closed");
            }
        }
        finally {
            gc.destroy();
            gc.waitFor();
        }
    }

    @Test
    public void replicatedStatusEntriesAreDeleted() throws Exception {
        Scanner s;
        this.getCluster().getClusterControl().stop(ServerType.GARBAGE_COLLECTOR);
        Connector conn = this.getConnector();
        log.info("Got connector to MAC");
        String table1 = "table1";
        Assert.assertFalse((boolean)ReplicationTable.isOnline((Connector)conn));
        conn.tableOperations().create(table1);
        int attempts = 5;
        while (attempts > 0) {
            try {
                conn.tableOperations().setProperty(table1, Property.TABLE_REPLICATION.getKey(), "true");
                conn.tableOperations().setProperty(table1, Property.TABLE_REPLICATION_TARGET.getKey() + "cluster1", "4");
                conn.instanceOperations().setProperty(Property.REPLICATION_PEERS.getKey() + "cluster1", ReplicaSystemFactory.getPeerConfigurationValue(MockReplicaSystem.class, (String)"1000"));
                attempts = 0;
            }
            catch (Exception e) {
                if (--attempts <= 0) {
                    throw e;
                }
                UtilWaitThread.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }
        String tableId = (String)conn.tableOperations().tableIdMap().get(table1);
        Assert.assertNotNull((String)("Could not determine table id for " + table1), (Object)tableId);
        this.writeSomeData(conn, table1, 2000, 50);
        conn.tableOperations().flush(table1, null, null, true);
        while (!ReplicationTable.isOnline((Connector)conn)) {
            UtilWaitThread.sleepUninterruptibly((long)5000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        Assert.assertTrue((String)"Replication table did not exist", (boolean)ReplicationTable.isOnline((Connector)conn));
        conn.securityOperations().grantTablePermission("root", "accumulo.replication", TablePermission.WRITE);
        log.info("Checking for replication entries in replication");
        HashSet<String> entries = new HashSet<String>();
        for (int i = 0; i < 5; ++i) {
            s = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
            s.setRange(MetadataSchema.ReplicationSection.getRange());
            entries.clear();
            for (Map.Entry entry : s) {
                entries.add(((Key)entry.getKey()).getRow().toString());
                log.info("{}={}", (Object)((Key)entry.getKey()).toStringNoTruncate(), entry.getValue());
            }
            if (!entries.isEmpty()) {
                log.info("Replication entries {}", entries);
                break;
            }
            Thread.sleep(1000L);
        }
        Assert.assertFalse((String)"Did not find any replication entries in the replication table", (boolean)entries.isEmpty());
        boolean notFound = true;
        for (int i = 0; i < 10 && notFound; ++i) {
            try {
                s = ReplicationTable.getScanner((Connector)conn);
                ReplicationSchema.WorkSection.limit((ScannerBase)s);
                Map.Entry e = (Map.Entry)Iterables.getOnlyElement((Iterable)s);
                log.info("Found entry: " + ((Key)e.getKey()).toStringNoTruncate());
                Iterator expectedColqual = new ReplicationTarget("cluster1", "4", tableId).toText();
                Assert.assertEquals((Object)expectedColqual, (Object)((Key)e.getKey()).getColumnQualifier());
                notFound = false;
            }
            catch (NoSuchElementException e) {
            }
            catch (IllegalArgumentException e) {
                s = ReplicationTable.getScanner((Connector)conn);
                for (Map.Entry content : s) {
                    log.info(((Key)content.getKey()).toStringNoTruncate() + " => " + content.getValue());
                }
                Assert.fail((String)"Found more than one work section entry");
            }
            catch (RuntimeException e) {
                Throwable cause = e.getCause();
                if (cause instanceof AccumuloSecurityException) {
                    AccumuloSecurityException sec = (AccumuloSecurityException)cause;
                    switch (sec.getSecurityErrorCode()) {
                        case PERMISSION_DENIED: {
                            log.warn("Sleeping because permission was denied");
                            break;
                        }
                        default: {
                            throw e;
                        }
                    }
                }
                throw e;
            }
            Thread.sleep(2000L);
        }
        if (notFound) {
            s = ReplicationTable.getScanner((Connector)conn);
            for (Map.Entry content : s) {
                log.info(((Key)content.getKey()).toStringNoTruncate() + " => " + ProtobufUtil.toString((GeneratedMessage)Replication.Status.parseFrom((byte[])((Value)content.getValue()).get())));
            }
            Assert.assertFalse((String)"Did not find the work entry for the status entry", (boolean)notFound);
        }
        log.info("Killing tserver");
        this.cluster.getClusterControl().stop(ServerType.TABLET_SERVER);
        log.info("Starting tserver");
        this.cluster.getClusterControl().start(ServerType.TABLET_SERVER);
        log.info("Waiting to read tables");
        UtilWaitThread.sleepUninterruptibly((long)6L, (TimeUnit)TimeUnit.SECONDS);
        for (String table : new String[]{"accumulo.metadata", table1}) {
            Iterators.size((Iterator)conn.createScanner(table, Authorizations.EMPTY).iterator());
        }
        log.info("Recovered metadata:");
        s = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
        for (Map.Entry entry : s) {
            log.info("{}={}", (Object)((Key)entry.getKey()).toStringNoTruncate(), entry.getValue());
        }
        this.cluster.getClusterControl().start(ServerType.GARBAGE_COLLECTOR);
        this.waitForGCLock(conn);
        Thread.sleep(1000L);
        log.info("After GC");
        s = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
        for (Map.Entry entry : s) {
            log.info("{}={}", (Object)((Key)entry.getKey()).toStringNoTruncate(), entry.getValue());
        }
        log.info("Checking metadata table for replication entries");
        HashSet<String> remaining = new HashSet<String>();
        for (int i = 0; i < 10; ++i) {
            s = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
            s.setRange(MetadataSchema.ReplicationSection.getRange());
            remaining.clear();
            for (Map.Entry e : s) {
                remaining.add(((Key)e.getKey()).getRow().toString());
            }
            remaining.retainAll(entries);
            if (remaining.isEmpty()) break;
            log.info("remaining {}", remaining);
            Thread.sleep(2000L);
            log.info("");
        }
        Assert.assertTrue((String)"Replication status messages were not cleaned up from metadata table", (boolean)remaining.isEmpty());
        int recordsFound = 0;
        for (int i = 0; i < 30; ++i) {
            s = ReplicationTable.getScanner((Connector)conn);
            recordsFound = 0;
            for (Map.Entry entry : s) {
                ++recordsFound;
                log.info("{} {}", (Object)((Key)entry.getKey()).toStringNoTruncate(), (Object)ProtobufUtil.toString((GeneratedMessage)Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get())));
            }
            if (recordsFound <= 2) break;
            Thread.sleep(1000L);
            log.info("");
        }
        Assert.assertTrue((String)"Found unexpected replication records in the replication table", (recordsFound <= 2 ? 1 : 0) != 0);
    }
}

