/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication;

import com.google.common.collect.Iterators;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.harness.AccumuloITBase;
import org.apache.accumulo.harness.MiniClusterConfigurationCallback;
import org.apache.accumulo.harness.MiniClusterHarness;
import org.apache.accumulo.harness.TestingKdc;
import org.apache.accumulo.master.replication.SequentialWorkAssigner;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloClusterImpl;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.minicluster.impl.ProcessReference;
import org.apache.accumulo.server.replication.ReplicaSystemFactory;
import org.apache.accumulo.test.categories.MiniClusterOnlyTests;
import org.apache.accumulo.test.functional.KerberosIT;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.replication.AccumuloReplicaSystem;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore(value="Replication ITs are not stable and not currently maintained")
@Category(value={MiniClusterOnlyTests.class})
public class KerberosReplicationIT
extends AccumuloITBase {
    private static final Logger log = LoggerFactory.getLogger(KerberosIT.class);
    private static TestingKdc kdc;
    private static String krbEnabledForITs;
    private static ClusterUser rootUser;
    private MiniAccumuloClusterImpl primary;
    private MiniAccumuloClusterImpl peer;
    private String PRIMARY_NAME = "primary";
    private String PEER_NAME = "peer";

    @BeforeClass
    public static void startKdc() throws Exception {
        kdc = new TestingKdc();
        kdc.start();
        krbEnabledForITs = System.getProperty("org.apache.accumulo.test.functional.useKrbForIT");
        if (null == krbEnabledForITs || !Boolean.parseBoolean(krbEnabledForITs)) {
            System.setProperty("org.apache.accumulo.test.functional.useKrbForIT", "true");
        }
        rootUser = kdc.getRootUser();
    }

    @AfterClass
    public static void stopKdc() throws Exception {
        if (null != kdc) {
            kdc.stop();
        }
        if (null != krbEnabledForITs) {
            System.setProperty("org.apache.accumulo.test.functional.useKrbForIT", krbEnabledForITs);
        }
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 180;
    }

    private MiniClusterConfigurationCallback getConfigCallback(final String name) {
        return new MiniClusterConfigurationCallback(){

            @Override
            public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration coreSite) {
                cfg.setNumTservers(1);
                cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
                cfg.setProperty(Property.TSERV_WALOG_MAX_SIZE, "2M");
                cfg.setProperty(Property.GC_CYCLE_START, "1s");
                cfg.setProperty(Property.GC_CYCLE_DELAY, "5s");
                cfg.setProperty(Property.REPLICATION_WORK_ASSIGNMENT_SLEEP, "1s");
                cfg.setProperty(Property.MASTER_REPLICATION_SCAN_INTERVAL, "1s");
                cfg.setProperty(Property.REPLICATION_NAME, name);
                cfg.setProperty(Property.REPLICATION_MAX_UNIT_SIZE, "8M");
                cfg.setProperty(Property.REPLICATION_WORK_ASSIGNER, SequentialWorkAssigner.class.getName());
                cfg.setProperty(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX, "1M");
                coreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
                coreSite.set("fs.defaultFS", "file:///");
            }
        };
    }

    @Before
    public void setup() throws Exception {
        MiniClusterHarness harness = new MiniClusterHarness();
        this.primary = harness.create(this.getClass().getName(), this.testName.getMethodName(), (AuthenticationToken)new PasswordToken((CharSequence)"unused"), this.getConfigCallback(this.PRIMARY_NAME), kdc);
        this.primary.start();
        this.peer = harness.create(this.getClass().getName(), this.testName.getMethodName() + "_peer", (AuthenticationToken)new PasswordToken((CharSequence)"unused"), this.getConfigCallback(this.PEER_NAME), kdc);
        this.peer.start();
        Configuration conf = new Configuration(false);
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
    }

    @After
    public void teardown() throws Exception {
        if (null != this.peer) {
            this.peer.stop();
        }
        if (null != this.primary) {
            this.primary.stop();
        }
        UserGroupInformation.setConfiguration((Configuration)new Configuration(false));
    }

    @Test
    public void dataReplicatedToCorrectTable() throws Exception {
        final UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().toURI().toString());
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                log.info("testing {}", (Object)ugi);
                KerberosToken token = new KerberosToken();
                Connector primaryConn = KerberosReplicationIT.this.primary.getConnector(rootUser.getPrincipal(), (AuthenticationToken)token);
                Connector peerConn = KerberosReplicationIT.this.peer.getConnector(rootUser.getPrincipal(), (AuthenticationToken)token);
                ClusterUser replicationUser = kdc.getClientPrincipal(0);
                peerConn.securityOperations().createLocalUser(replicationUser.getPrincipal(), null);
                primaryConn.instanceOperations().setProperty(Property.REPLICATION_PEER_USER.getKey() + KerberosReplicationIT.this.PEER_NAME, replicationUser.getPrincipal());
                primaryConn.instanceOperations().setProperty(Property.REPLICATION_PEER_KEYTAB.getKey() + KerberosReplicationIT.this.PEER_NAME, replicationUser.getKeytab().getAbsolutePath());
                primaryConn.instanceOperations().setProperty(Property.REPLICATION_PEERS.getKey() + KerberosReplicationIT.this.PEER_NAME, ReplicaSystemFactory.getPeerConfigurationValue(AccumuloReplicaSystem.class, (String)AccumuloReplicaSystem.buildConfiguration((String)peerConn.getInstance().getInstanceName(), (String)peerConn.getInstance().getZooKeepers())));
                String primaryTable1 = "primary";
                String peerTable1 = "peer";
                primaryConn.tableOperations().create(primaryTable1);
                String masterTableId1 = (String)primaryConn.tableOperations().tableIdMap().get(primaryTable1);
                Assert.assertNotNull((Object)masterTableId1);
                peerConn.tableOperations().create(peerTable1);
                String peerTableId1 = (String)peerConn.tableOperations().tableIdMap().get(peerTable1);
                Assert.assertNotNull((Object)peerTableId1);
                peerConn.securityOperations().grantTablePermission(replicationUser.getPrincipal(), peerTable1, TablePermission.WRITE);
                primaryConn.tableOperations().setProperty(primaryTable1, Property.TABLE_REPLICATION.getKey(), "true");
                primaryConn.tableOperations().setProperty(primaryTable1, Property.TABLE_REPLICATION_TARGET.getKey() + KerberosReplicationIT.this.PEER_NAME, peerTableId1);
                BatchWriter bw = primaryConn.createBatchWriter(primaryTable1, new BatchWriterConfig());
                long masterTable1Records = 0L;
                for (int rows = 0; rows < 2500; ++rows) {
                    Mutation m = new Mutation((CharSequence)(primaryTable1 + rows));
                    for (int cols = 0; cols < 100; ++cols) {
                        String value = Integer.toString(cols);
                        m.put((CharSequence)value, (CharSequence)"", (CharSequence)value);
                        ++masterTable1Records;
                    }
                    bw.addMutation(m);
                }
                bw.close();
                log.info("Wrote all data to primary cluster");
                Set filesFor1 = primaryConn.replicationOperations().referencedFiles(primaryTable1);
                for (ProcessReference proc : (Collection)KerberosReplicationIT.this.primary.getProcesses().get(ServerType.TABLET_SERVER)) {
                    KerberosReplicationIT.this.primary.killProcess(ServerType.TABLET_SERVER, proc);
                }
                KerberosReplicationIT.this.primary.exec(TabletServer.class, new String[0]);
                log.info("Restarted the tserver");
                Iterators.size((Iterator)primaryConn.createScanner(primaryTable1, Authorizations.EMPTY).iterator());
                log.info("Waiting for {} for {}", (Object)filesFor1, (Object)primaryTable1);
                primaryConn.replicationOperations().drain(primaryTable1, filesFor1);
                long countTable = 0L;
                try (Scanner s = peerConn.createScanner(peerTable1, Authorizations.EMPTY);){
                    for (Map.Entry entry : s) {
                        ++countTable;
                        Assert.assertTrue((String)("Found unexpected key-value" + ((Key)entry.getKey()).toStringNoTruncate() + " " + entry.getValue()), (boolean)((Key)entry.getKey()).getRow().toString().startsWith(primaryTable1));
                    }
                }
                log.info("Found {} records in {}", (Object)countTable, (Object)peerTable1);
                Assert.assertEquals((long)masterTable1Records, (long)countTable);
                return null;
            }
        });
    }

    static {
        krbEnabledForITs = null;
    }
}

