/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.minicluster.impl.ProcessReference;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;

public class ZookeeperRestartIT
extends ConfigurableMacBase {
    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        HashMap<String, String> siteConfig = new HashMap<String, String>();
        siteConfig.put(Property.INSTANCE_ZK_TIMEOUT.getKey(), "15s");
        cfg.setSiteConfig(siteConfig);
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    @Test
    public void test() throws Exception {
        Connector c = this.getConnector();
        c.tableOperations().create("test_ingest");
        BatchWriter bw = c.createBatchWriter("test_ingest", null);
        Mutation m = new Mutation((CharSequence)"row");
        m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"value");
        bw.addMutation(m);
        bw.close();
        for (ProcessReference proc : (Collection)this.cluster.getProcesses().get(ServerType.ZOOKEEPER)) {
            this.cluster.killProcess(ServerType.ZOOKEEPER, proc);
        }
        UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        this.cluster.start();
        Scanner s = c.createScanner("test_ingest", Authorizations.EMPTY);
        Iterator i = s.iterator();
        Assert.assertTrue((boolean)i.hasNext());
        Assert.assertEquals((Object)"row", (Object)((Key)((Map.Entry)i.next()).getKey()).getRow().toString());
        Assert.assertFalse((boolean)i.hasNext());
        c.tableOperations().delete("test_ingest");
    }
}

