/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.Merge;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.server.util.TabletIterator;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class MergeIT
extends AccumuloClusterHarness {
    @Override
    public int defaultTimeoutSeconds() {
        return 480;
    }

    SortedSet<Text> splits(String[] points) {
        TreeSet<Text> result = new TreeSet<Text>();
        for (String point : points) {
            result.add(new Text(point));
        }
        return result;
    }

    @Test
    public void merge() throws Exception {
        Connector c = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        c.tableOperations().create(tableName);
        c.tableOperations().addSplits(tableName, this.splits("a b c d e f g h i j k".split(" ")));
        BatchWriter bw = c.createBatchWriter(tableName, null);
        for (String row : "a b c d e f g h i j k".split(" ")) {
            Mutation m = new Mutation((CharSequence)row);
            m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"value");
            bw.addMutation(m);
        }
        bw.close();
        c.tableOperations().flush(tableName, null, null, true);
        c.tableOperations().merge(tableName, new Text("c1"), new Text("f1"));
        Assert.assertEquals((long)8L, (long)c.tableOperations().listSplits(tableName).size());
    }

    @Test
    public void mergeSize() throws Exception {
        Connector c = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        c.tableOperations().create(tableName);
        c.tableOperations().addSplits(tableName, this.splits("a b c d e f g h i j k l m n o p q r s t u v w x y z".split(" ")));
        BatchWriter bw = c.createBatchWriter(tableName, null);
        for (String row : "c e f y".split(" ")) {
            Mutation m = new Mutation((CharSequence)row);
            m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"mersydotesanddozeydotesanlittolamsiedives");
            bw.addMutation(m);
        }
        bw.close();
        c.tableOperations().flush(tableName, null, null, true);
        Merge merge = new Merge();
        merge.mergomatic(c, tableName, null, null, 100L, false);
        Assert.assertArrayEquals((Object[])"b c d e f x y".split(" "), (Object[])this.toStrings(c.tableOperations().listSplits(tableName)));
        merge.mergomatic(c, tableName, null, null, 100L, true);
        Assert.assertArrayEquals((Object[])"c e f y".split(" "), (Object[])this.toStrings(c.tableOperations().listSplits(tableName)));
    }

    private String[] toStrings(Collection<Text> listSplits) {
        String[] result = new String[listSplits.size()];
        int i = 0;
        for (Text t : listSplits) {
            result[i++] = t.toString();
        }
        return result;
    }

    private String[] ns(String ... strings) {
        return strings;
    }

    @Test
    public void mergeTest() throws Exception {
        int tc = 0;
        Connector c = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        this.runMergeTest(c, tableName + tc++, this.ns(new String[0]), this.ns(new String[0]), this.ns("l", "m", "n"), this.ns(null, "l"), this.ns(null, "n"));
        this.runMergeTest(c, tableName + tc++, this.ns("m"), this.ns(new String[0]), this.ns("l", "m", "n"), this.ns(null, "l"), this.ns(null, "n"));
        this.runMergeTest(c, tableName + tc++, this.ns("m"), this.ns("m"), this.ns("l", "m", "n"), this.ns("m", "n"), this.ns(null, "z"));
        this.runMergeTest(c, tableName + tc++, this.ns("m"), this.ns("m"), this.ns("l", "m", "n"), this.ns(null, "b"), this.ns("l", "m"));
        this.runMergeTest(c, tableName + tc++, this.ns("b", "m", "r"), this.ns(new String[0]), this.ns("a", "b", "c", "l", "m", "n", "q", "r", "s"), this.ns(null, "a"), this.ns(null, "s"));
        this.runMergeTest(c, tableName + tc++, this.ns("b", "m", "r"), this.ns("m", "r"), this.ns("a", "b", "c", "l", "m", "n", "q", "r", "s"), this.ns(null, "a"), this.ns("c", "m"));
        this.runMergeTest(c, tableName + tc++, this.ns("b", "m", "r"), this.ns("r"), this.ns("a", "b", "c", "l", "m", "n", "q", "r", "s"), this.ns(null, "a"), this.ns("n", "r"));
        this.runMergeTest(c, tableName + tc++, this.ns("b", "m", "r"), this.ns("b"), this.ns("a", "b", "c", "l", "m", "n", "q", "r", "s"), this.ns("b", "c"), this.ns(null, "s"));
        this.runMergeTest(c, tableName + tc++, this.ns("b", "m", "r"), this.ns("b", "m"), this.ns("a", "b", "c", "l", "m", "n", "q", "r", "s"), this.ns("m", "n"), this.ns(null, "s"));
        this.runMergeTest(c, tableName + tc++, this.ns("b", "m", "r"), this.ns("b", "r"), this.ns("a", "b", "c", "l", "m", "n", "q", "r", "s"), this.ns("b", "c"), this.ns("q", "r"));
        this.runMergeTest(c, tableName + tc++, this.ns("b", "m", "r"), this.ns("b", "m", "r"), this.ns("a", "b", "c", "l", "m", "n", "q", "r", "s"), this.ns(null, "a"), this.ns("aa", "b"));
        this.runMergeTest(c, tableName + tc++, this.ns("b", "m", "r"), this.ns("b", "m", "r"), this.ns("a", "b", "c", "l", "m", "n", "q", "r", "s"), this.ns("r", "s"), this.ns(null, "z"));
        this.runMergeTest(c, tableName + tc++, this.ns("b", "m", "r"), this.ns("b", "m", "r"), this.ns("a", "b", "c", "l", "m", "n", "q", "r", "s"), this.ns("b", "c"), this.ns("l", "m"));
        this.runMergeTest(c, tableName + tc++, this.ns("b", "m", "r"), this.ns("b", "m", "r"), this.ns("a", "b", "c", "l", "m", "n", "q", "r", "s"), this.ns("m", "n"), this.ns("q", "r"));
    }

    private void runMergeTest(Connector c, String table, String[] splits, String[] expectedSplits, String[] inserts, String[] start, String[] end) throws Exception {
        int count = 0;
        for (String s : start) {
            for (String e : end) {
                this.runMergeTest(c, table + "_" + count++, splits, expectedSplits, inserts, s, e);
            }
        }
    }

    private void runMergeTest(Connector conn, String table, String[] splits, String[] expectedSplits, String[] inserts, String start, String end) throws Exception {
        System.out.println("Running merge test " + table + " " + Arrays.asList(splits) + " " + start + " " + end);
        conn.tableOperations().create(table, new NewTableConfiguration().setTimeType(TimeType.LOGICAL));
        TreeSet<Text> splitSet = new TreeSet<Text>();
        for (String split : splits) {
            splitSet.add(new Text(split));
        }
        conn.tableOperations().addSplits(table, splitSet);
        BatchWriter bw = conn.createBatchWriter(table, null);
        HashSet<String> expected = new HashSet<String>();
        for (String row : inserts) {
            Mutation m = new Mutation((CharSequence)row);
            m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)row);
            bw.addMutation(m);
            expected.add(row);
        }
        bw.close();
        conn.tableOperations().merge(table, start == null ? null : new Text(start), end == null ? null : new Text(end));
        Scanner scanner = conn.createScanner(table, Authorizations.EMPTY);
        HashSet<String> observed = new HashSet<String>();
        for (Map.Entry entry : scanner) {
            String row = ((Key)entry.getKey()).getRowData().toString();
            if (observed.add(row)) continue;
            throw new Exception("Saw data twice " + table + " " + row);
        }
        if (!observed.equals(expected)) {
            throw new Exception("data inconsistency " + table + " " + observed + " != " + expected);
        }
        HashSet currentSplits = new HashSet(conn.tableOperations().listSplits(table));
        HashSet<Text> ess = new HashSet<Text>();
        for (String es : expectedSplits) {
            ess.add(new Text(es));
        }
        if (!currentSplits.equals(ess)) {
            throw new Exception("split inconsistency " + table + " " + currentSplits + " != " + ess);
        }
    }

    @Test
    public void testMerge() throws Exception {
        String metadataTableName = this.getUniqueNames(1)[0];
        this.getConnector().tableOperations().create(metadataTableName);
        KeyExtent ke1 = new KeyExtent("0", new Text("m"), null);
        Mutation mut1 = ke1.getPrevRowUpdateMutation();
        MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.put(mut1, new Value("/d1".getBytes()));
        KeyExtent ke2 = new KeyExtent("0", null, null);
        Mutation mut2 = ke2.getPrevRowUpdateMutation();
        MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.put(mut2, new Value("/d2".getBytes()));
        BatchWriter bw1 = this.getConnector().createBatchWriter(metadataTableName, new BatchWriterConfig());
        bw1.addMutation(mut1);
        bw1.addMutation(mut2);
        bw1.close();
        TestTabletIterator tabIter = new TestTabletIterator(this.getConnector(), metadataTableName);
        Assert.assertThrows(TabletIterator.TabletDeletedException.class, () -> {
            while (tabIter.hasNext()) {
                tabIter.next();
            }
        });
    }

    private static class TestTabletIterator
    extends TabletIterator {
        private final Connector conn;
        private final String metadataTableName;

        public TestTabletIterator(Connector conn, String metadataTableName) throws Exception {
            super(conn.createScanner(metadataTableName, Authorizations.EMPTY), MetadataSchema.TabletsSection.getRange(), true, true);
            this.conn = conn;
            this.metadataTableName = metadataTableName;
        }

        protected void resetScanner() {
            try {
                Scanner ds = this.conn.createScanner(this.metadataTableName, Authorizations.EMPTY);
                Text tablet = new KeyExtent("0", new Text("m"), null).getMetadataEntry();
                ds.setRange(new Range(tablet, true, tablet, true));
                Mutation m = new Mutation(tablet);
                BatchWriter bw = this.conn.createBatchWriter(this.metadataTableName, new BatchWriterConfig());
                for (Map.Entry entry : ds) {
                    Key k = (Key)entry.getKey();
                    m.putDelete(k.getColumnFamily(), k.getColumnQualifier(), k.getTimestamp());
                }
                bw.addMutation(m);
                bw.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            super.resetScanner();
        }
    }
}

