/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class BulkIT
extends AccumuloClusterHarness {
    private static final int N = 100000;
    private static final int COUNT = 5;
    private static final BatchWriterOpts BWOPTS = new BatchWriterOpts();
    private static final ScannerOpts SOPTS = new ScannerOpts();
    private Configuration origConf;

    @Override
    protected int defaultTimeoutSeconds() {
        return 240;
    }

    @Before
    public void saveConf() {
        this.origConf = CachedConfiguration.getInstance();
    }

    @After
    public void restoreConf() {
        if (null != this.origConf) {
            CachedConfiguration.setInstance((Configuration)this.origConf);
        }
    }

    @Test
    public void test() throws Exception {
        BulkIT.runTest(this.getConnector(), BulkIT.getCluster().getFileSystem(), BulkIT.getCluster().getTemporaryPath(), BulkIT.getAdminPrincipal(), this.getUniqueNames(1)[0], this.getClass().getName(), this.testName.getMethodName());
    }

    static void runTest(Connector c, FileSystem fs, Path basePath, String principal, String tableName, String filePrefix, String dirSuffix) throws Exception {
        c.tableOperations().create(tableName);
        Path base = new Path(basePath, "testBulkFail_" + dirSuffix);
        fs.delete(base, true);
        fs.mkdirs(base);
        Path bulkFailures = new Path(base, "failures");
        Path files = new Path(base, "files");
        fs.mkdirs(bulkFailures);
        fs.mkdirs(files);
        TestIngest.Opts opts = new TestIngest.Opts();
        opts.timestamp = 1L;
        opts.random = 56;
        opts.rows = 100000;
        opts.instance = c.getInstance().getInstanceName();
        opts.cols = 1;
        opts.setTableName(tableName);
        opts.conf = new Configuration(false);
        opts.fs = fs;
        String fileFormat = filePrefix + "rf%02d";
        for (int i = 0; i < 5; ++i) {
            opts.outputFile = new Path(files, String.format(fileFormat, i)).toString();
            opts.startRow = 100000 * i;
            TestIngest.ingest(c, fs, opts, BWOPTS);
        }
        opts.outputFile = new Path(files, String.format(fileFormat, 100000)).toString();
        opts.startRow = 100000;
        opts.rows = 1;
        TestIngest.ingest(c, fs, opts, BWOPTS);
        c.tableOperations().importDirectory(tableName, files.toString(), bulkFailures.toString(), false);
        VerifyIngest.Opts vopts = new VerifyIngest.Opts();
        vopts.setTableName(tableName);
        vopts.random = 56;
        vopts.setPrincipal(principal);
        for (int i = 0; i < 5; ++i) {
            vopts.startRow = i * 100000;
            vopts.rows = 100000;
            VerifyIngest.verifyIngest(c, vopts, SOPTS);
        }
        vopts.startRow = 100000;
        vopts.rows = 1;
        VerifyIngest.verifyIngest(c, vopts, SOPTS);
    }
}

