/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;

public class BigRootTabletIT
extends AccumuloClusterHarness {
    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        Map siteConfig = cfg.getSiteConfig();
        siteConfig.put(Property.TABLE_SCAN_MAXMEM.getKey(), "1024");
        siteConfig.put(Property.TSERV_MAJC_DELAY.getKey(), "60m");
        cfg.setSiteConfig(siteConfig);
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 240;
    }

    @Test
    public void test() throws Exception {
        String[] names;
        Connector c = this.getConnector();
        c.tableOperations().addSplits("accumulo.metadata", FunctionalTestUtils.splits("0 1 2 3 4 5 6 7 8 9 a".split(" ")));
        for (String name : names = this.getUniqueNames(10)) {
            c.tableOperations().create(name);
            c.tableOperations().flush("accumulo.metadata", null, null, true);
            c.tableOperations().flush("accumulo.root", null, null, true);
        }
        cluster.stop();
        cluster.start();
        Assert.assertTrue((Iterators.size((Iterator)c.createScanner("accumulo.root", Authorizations.EMPTY).iterator()) > 0 ? 1 : 0) != 0);
    }
}

