/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.FastFormat;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.tserver.NativeMap;
import org.apache.hadoop.io.Text;

public class NativeMapPerformanceTest {
    private static final byte[] ROW_PREFIX = new byte[]{114};
    private static final byte[] COL_PREFIX = new byte[]{99};
    static Text ET = new Text();

    static Key newKey(int r, int c) {
        return new Key(new Text(FastFormat.toZeroPaddedString((long)r, (int)9, (int)10, (byte[])ROW_PREFIX)), new Text(FastFormat.toZeroPaddedString((long)c, (int)6, (int)10, (byte[])COL_PREFIX)));
    }

    static Mutation newMutation(int r) {
        return new Mutation(new Text(FastFormat.toZeroPaddedString((long)r, (int)9, (int)10, (byte[])ROW_PREFIX)));
    }

    private static void pc(Mutation m, int c, Value v) {
        m.put(new Text(FastFormat.toZeroPaddedString((long)c, (int)6, (int)10, (byte[])COL_PREFIX)), ET, Long.MAX_VALUE, v);
    }

    static void runPerformanceTest(int numRows, int numCols, int numLookups, String mapType) {
        int i;
        Value val;
        int row;
        int i2;
        SortedMap<Key, Value> tm = null;
        NativeMap nm = null;
        if (mapType.equals("SKIP_LIST")) {
            tm = new ConcurrentSkipListMap();
        } else if (mapType.equals("TREE_MAP")) {
            tm = Collections.synchronizedSortedMap(new TreeMap());
        } else if (mapType.equals("NATIVE_MAP")) {
            nm = new NativeMap();
        } else {
            throw new IllegalArgumentException(" map type must be SKIP_LIST, TREE_MAP, or NATIVE_MAP");
        }
        Random rand = new Random(19L);
        long tps = System.currentTimeMillis();
        if (nm != null) {
            for (i2 = 0; i2 < numRows; ++i2) {
                row = rand.nextInt(1000000000);
                Mutation m = NativeMapPerformanceTest.newMutation(row);
                for (int j = 0; j < numCols; ++j) {
                    int col = rand.nextInt(1000000);
                    val = new Value("test".getBytes(StandardCharsets.UTF_8));
                    NativeMapPerformanceTest.pc(m, col, val);
                }
                nm.mutate(m, i2);
            }
        } else {
            for (i2 = 0; i2 < numRows; ++i2) {
                row = rand.nextInt(1000000000);
                for (int j = 0; j < numCols; ++j) {
                    int col = rand.nextInt(1000000);
                    Key key = NativeMapPerformanceTest.newKey(row, col);
                    val = new Value("test".getBytes(StandardCharsets.UTF_8));
                    tm.put(key, val);
                }
            }
        }
        long tpe = System.currentTimeMillis();
        Iterator iter = nm != null ? nm.iterator() : tm.entrySet().iterator();
        long tis = System.currentTimeMillis();
        while (iter.hasNext()) {
            iter.next();
        }
        long tie = System.currentTimeMillis();
        rand = new Random(19L);
        int[] rowsToLookup = new int[numLookups];
        int[] colsToLookup = new int[numLookups];
        for (int i3 = 0; i3 < Math.min(numLookups, numRows); ++i3) {
            int row2 = rand.nextInt(1000000000);
            int col = -1;
            for (int j = 0; j < numCols; ++j) {
                col = rand.nextInt(1000000);
            }
            rowsToLookup[i3] = row2;
            colsToLookup[i3] = col;
        }
        long tgs = System.currentTimeMillis();
        if (nm != null) {
            for (i = 0; i < numLookups; ++i) {
                Key key = NativeMapPerformanceTest.newKey(rowsToLookup[i], colsToLookup[i]);
                if (nm.get(key) != null) continue;
                throw new RuntimeException("Did not find " + rowsToLookup[i] + " " + colsToLookup[i] + " " + i);
            }
        } else {
            for (i = 0; i < numLookups; ++i) {
                Key key = NativeMapPerformanceTest.newKey(rowsToLookup[i], colsToLookup[i]);
                if (tm.get(key) != null) continue;
                throw new RuntimeException("Did not find " + rowsToLookup[i] + " " + colsToLookup[i] + " " + i);
            }
        }
        long tge = System.currentTimeMillis();
        long memUsed = 0L;
        if (nm != null) {
            memUsed = nm.getMemoryUsed();
        }
        int size = nm == null ? tm.size() : nm.size();
        long tds = System.currentTimeMillis();
        if (nm != null) {
            nm.delete();
        }
        long tde = System.currentTimeMillis();
        if (tm != null) {
            tm.clear();
        }
        System.gc();
        System.gc();
        System.gc();
        System.gc();
        UtilWaitThread.sleepUninterruptibly((long)3L, (TimeUnit)TimeUnit.SECONDS);
        System.out.printf("mapType:%10s   put rate:%,6.2f  scan rate:%,6.2f  get rate:%,6.2f  delete time : %6.2f  mem : %,d%n", "" + mapType, (double)(numRows * numCols) / ((double)(tpe - tps) / 1000.0), (double)size / ((double)(tie - tis) / 1000.0), (double)numLookups / ((double)(tge - tgs) / 1000.0), (double)(tde - tds) / 1000.0, memUsed);
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            throw new IllegalArgumentException("Usage : " + NativeMapPerformanceTest.class.getName() + " <map type> <rows> <columns>");
        }
        String mapType = args[0];
        int rows = Integer.parseInt(args[1]);
        int cols = Integer.parseInt(args[2]);
        NativeMapPerformanceTest.runPerformanceTest(rows, cols, 10000, mapType);
        NativeMapPerformanceTest.runPerformanceTest(rows, cols, 10000, mapType);
        NativeMapPerformanceTest.runPerformanceTest(rows, cols, 10000, mapType);
    }
}

