/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.FastFormat;
import org.apache.accumulo.core.util.Stat;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.hadoop.io.Text;

public class IMMLGBenchmark {
    public static void main(String[] args) throws Exception {
        ZooKeeperInstance zki = new ZooKeeperInstance(ClientConfiguration.create().withInstance("test16").withZkHosts("localhost"));
        Connector conn = zki.getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)"secret"));
        int numlg = Integer.parseInt(args[0]);
        ArrayList<byte[]> cfset = new ArrayList<byte[]>();
        for (int i = 0; i < 32; ++i) {
            cfset.add(String.format("%04x", i).getBytes());
        }
        TreeMap<String, Stat> stats = new TreeMap<String, Stat>();
        for (int i = 0; i < 5; ++i) {
            IMMLGBenchmark.runTest(conn, numlg, cfset, i > 1 ? stats : null);
            System.out.println();
        }
        for (Map.Entry entry : stats.entrySet()) {
            System.out.printf("%20s : %6.2f\n", entry.getKey(), ((Stat)entry.getValue()).getAverage());
        }
    }

    private static void runTest(Connector conn, int numlg, ArrayList<byte[]> cfset, Map<String, Stat> stats) throws Exception {
        String table = "immlgb";
        try {
            conn.tableOperations().delete(table);
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        conn.tableOperations().create(table);
        conn.tableOperations().setProperty(table, Property.TABLE_FILE_COMPRESSION_TYPE.getKey(), "snappy");
        IMMLGBenchmark.setupLocalityGroups(conn, numlg, cfset, table);
        IMMLGBenchmark.addStat(stats, "write", IMMLGBenchmark.write(conn, cfset, table));
        IMMLGBenchmark.addStat(stats, "scan cf", IMMLGBenchmark.scan(conn, cfset, table, false));
        IMMLGBenchmark.addStat(stats, "scan cf:cq", IMMLGBenchmark.scan(conn, cfset, table, true));
        long t1 = System.currentTimeMillis();
        conn.tableOperations().flush(table, null, null, true);
        long t2 = System.currentTimeMillis();
        IMMLGBenchmark.addStat(stats, "flush", t2 - t1);
    }

    private static void addStat(Map<String, Stat> stats, String s, long wt) {
        System.out.println(s + ":" + wt);
        if (stats == null) {
            return;
        }
        Stat stat = stats.get(s);
        if (stat == null) {
            stat = new Stat();
            stats.put(s, stat);
        }
        stat.addStat(wt);
    }

    private static long scan(Connector conn, ArrayList<byte[]> cfset, String table, boolean cq) throws TableNotFoundException {
        Scanner scanner = conn.createScanner(table, Authorizations.EMPTY);
        if (!cq) {
            scanner.fetchColumnFamily(new Text(cfset.get(15)));
        } else {
            scanner.fetchColumn(new Text(cfset.get(15)), new Text(cfset.get(15)));
        }
        long t1 = System.currentTimeMillis();
        Iterators.size((Iterator)scanner.iterator());
        long t2 = System.currentTimeMillis();
        return t2 - t1;
    }

    private static long write(Connector conn, ArrayList<byte[]> cfset, String table) throws TableNotFoundException, MutationsRejectedException {
        Random rand = new Random();
        byte[] val = new byte[50];
        BatchWriter bw = conn.createBatchWriter(table, new BatchWriterConfig());
        long t1 = System.currentTimeMillis();
        for (int i = 0; i < 32768; ++i) {
            byte[] row = FastFormat.toZeroPaddedString((long)IMMLGBenchmark.abs(rand.nextLong()), (int)16, (int)16, (byte[])new byte[0]);
            Mutation m = new Mutation(row);
            for (byte[] cf : cfset) {
                byte[] cq = FastFormat.toZeroPaddedString((long)rand.nextInt(65536), (int)4, (int)16, (byte[])new byte[0]);
                rand.nextBytes(val);
                m.put(cf, cq, val);
            }
            bw.addMutation(m);
        }
        bw.close();
        long t2 = System.currentTimeMillis();
        return t2 - t1;
    }

    private static void setupLocalityGroups(Connector conn, int numlg, ArrayList<byte[]> cfset, String table) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        if (numlg > 1) {
            int numCF = cfset.size() / numlg;
            int gNum = 0;
            Iterator<byte[]> cfiter = cfset.iterator();
            HashMap groups = new HashMap();
            while (cfiter.hasNext()) {
                HashSet<Text> groupCols = new HashSet<Text>();
                for (int i = 0; i < numCF && cfiter.hasNext(); ++i) {
                    groupCols.add(new Text(cfiter.next()));
                }
                groups.put("lg" + gNum++, groupCols);
            }
            conn.tableOperations().setLocalityGroups(table, groups);
            conn.tableOperations().offline(table);
            UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            conn.tableOperations().online(table);
        }
    }

    public static long abs(long l) {
        if ((l = Math.abs(l)) < 0L) {
            return 0L;
        }
        return l;
    }
}

