/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import org.apache.accumulo.core.client.ConditionalWriter;
import org.apache.accumulo.core.data.ConditionalMutation;

public class FaultyConditionalWriter
implements ConditionalWriter {
    private ConditionalWriter cw;
    private double up;
    private Random rand;
    private double wp;

    public FaultyConditionalWriter(ConditionalWriter cw, double unknownProbability, double writeProbability) {
        this.cw = cw;
        this.up = unknownProbability;
        this.wp = writeProbability;
        this.rand = new Random();
    }

    public Iterator<ConditionalWriter.Result> write(Iterator<ConditionalMutation> mutations) {
        ArrayList<ConditionalWriter.Result> resultList = new ArrayList<ConditionalWriter.Result>();
        ArrayList<ConditionalMutation> writes = new ArrayList<ConditionalMutation>();
        while (mutations.hasNext()) {
            ConditionalMutation cm = mutations.next();
            if (this.rand.nextDouble() <= this.up && this.rand.nextDouble() > this.wp) {
                resultList.add(new ConditionalWriter.Result(ConditionalWriter.Status.UNKNOWN, cm, null));
                continue;
            }
            writes.add(cm);
        }
        if (writes.size() > 0) {
            Iterator results = this.cw.write(writes.iterator());
            while (results.hasNext()) {
                ConditionalWriter.Result result = (ConditionalWriter.Result)results.next();
                if (this.rand.nextDouble() <= this.up && this.rand.nextDouble() <= this.wp) {
                    result = new ConditionalWriter.Result(ConditionalWriter.Status.UNKNOWN, result.getMutation(), result.getTabletServer());
                }
                resultList.add(result);
            }
        }
        return resultList.iterator();
    }

    public ConditionalWriter.Result write(ConditionalMutation mutation) {
        return this.write(Collections.singleton(mutation).iterator()).next();
    }

    public void close() {
        this.cw.close();
    }
}

