/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.commands.TableOperation;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class OnlineCommand
extends TableOperation {
    private boolean wait;
    private Option waitOpt;

    @Override
    public String description() {
        return "starts the process of putting a table online";
    }

    @Override
    protected void doTableOp(Shell shellState, String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        if (tableName.equals("accumulo.root")) {
            Shell.log.info((Object)"  The accumulo.root is always online.");
        } else {
            shellState.getConnector().tableOperations().online(tableName, this.wait);
            Shell.log.info((Object)("Online of table " + tableName + (this.wait ? " completed." : " initiated...")));
        }
    }

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        this.wait = cl.hasOption(this.waitOpt.getLongOpt());
        return super.execute(fullCommand, cl, shellState);
    }

    @Override
    public Options getOptions() {
        Options opts = super.getOptions();
        this.waitOpt = new Option("w", "wait", false, "wait for online to finish");
        opts.addOption(this.waitOpt);
        return opts;
    }
}

