/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.Token;
import org.apache.accumulo.shell.commands.OptUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class ImportDirectoryCommand
extends Shell.Command {
    @Override
    public String description() {
        return "bulk imports an entire directory of data files into an existing table. The table is either passed with the -t tablename opt, or into to the current table if the -t option is not provided. The boolean argument determines if accumulo sets the time.";
    }

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws IOException, AccumuloException, AccumuloSecurityException, TableNotFoundException {
        String tableName = OptUtil.getTableOpt(cl, shellState);
        String dir = cl.getArgs()[0];
        String failureDir = cl.getArgs()[1];
        boolean setTime = Boolean.parseBoolean(cl.getArgs()[2]);
        shellState.getConnector().tableOperations().importDirectory(tableName, dir, failureDir, setTime);
        return 0;
    }

    @Override
    public int numArgs() {
        return 3;
    }

    @Override
    public String usage() {
        return this.getName() + "[-t tablename] <directory> <failureDirectory> true|false";
    }

    @Override
    public Options getOptions() {
        Options opts = super.getOptions();
        opts.addOption(OptUtil.tableOpt("name of the table to import files into"));
        return opts;
    }

    @Override
    public void registerCompletion(Token root, Map<Shell.Command.CompletionSet, Set<String>> completionSet) {
        this.registerCompletionForTables(root, completionSet);
    }
}

